/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.util.Comparator;
import org.eclipse.jst.validation.sample.parser.PropertyLine;

public class PropertyLineComparator {
    private static PropertyLineComparator inst;
    private static final Comparator _messagePrefixComparator;
    private static final Comparator _messageIdComparator;
    private static Comparator _stringLengthComparator;
    private static final Comparator _valueComparator;
    private static final Comparator _lineNoComparator;

    static {
        PropertyLineComparator propertyLineComparator = inst = new PropertyLineComparator();
        propertyLineComparator.getClass();
        _messagePrefixComparator = propertyLineComparator.new MessagePrefixComparator();
        PropertyLineComparator propertyLineComparator2 = inst;
        propertyLineComparator2.getClass();
        _messageIdComparator = propertyLineComparator2.new MessageIdComparator();
        _stringLengthComparator = new StringLengthComparator();
        PropertyLineComparator propertyLineComparator3 = inst;
        propertyLineComparator3.getClass();
        _valueComparator = propertyLineComparator3.new ValueComparator();
        PropertyLineComparator propertyLineComparator4 = inst;
        propertyLineComparator4.getClass();
        _lineNoComparator = propertyLineComparator4.new LineNoComparator();
    }

    private PropertyLineComparator() {
    }

    public static Comparator getMessagePrefixComparator() {
        return _messagePrefixComparator;
    }

    public static Comparator getMessageIdComparator() {
        return _messageIdComparator;
    }

    public static Comparator getStringLengthComparator(int length) {
        StringLengthComparator.length = length;
        return _stringLengthComparator;
    }

    public static Comparator getValueComparator() {
        return _valueComparator;
    }

    public static Comparator getLineNoComparator() {
        return _lineNoComparator;
    }

    private class LineNoComparator
    implements Comparator {
        private LineNoComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int aLineNo = ((PropertyLine)a).getLineNumber();
            int bLineNo = ((PropertyLine)b).getLineNumber();
            if (aLineNo < 0 && bLineNo < 0) {
                return 0;
            }
            if (aLineNo < 0) {
                return -1;
            }
            if (bLineNo < 0) {
                return 1;
            }
            return aLineNo - bLineNo;
        }
    }

    private class MessageIdComparator
    implements Comparator {
        private MessageIdComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            String aMessageId = null;
            String bMessageId = null;
            aMessageId = a instanceof PropertyLine ? ((PropertyLine)a).getMessageId() : (String)a;
            bMessageId = b instanceof PropertyLine ? ((PropertyLine)b).getMessageId() : (String)b;
            if (aMessageId == null && bMessageId == null) {
                return 0;
            }
            if (aMessageId == null) {
                return -1;
            }
            if (bMessageId == null) {
                return 1;
            }
            return aMessageId.compareTo(bMessageId);
        }
    }

    private class MessagePrefixComparator
    implements Comparator {
        private MessagePrefixComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            String aid = ((PropertyLine)a).getMessagePrefix();
            String bid = ((PropertyLine)b).getMessagePrefix();
            if (aid == null && bid == null) {
                return 0;
            }
            if (aid == null) {
                return -1;
            }
            if (bid == null) {
                return 1;
            }
            aid = aid.toUpperCase().trim();
            bid = bid.toUpperCase().trim();
            if (aid.equals("") && bid.equals("")) {
                return 0;
            }
            if (aid.equals("")) {
                return -1;
            }
            if (bid.equals("")) {
                return 1;
            }
            return ((PropertyLine)a).getShortMessagePrefix().toUpperCase().compareTo(((PropertyLine)b).getShortMessagePrefix().toUpperCase());
        }
    }

    static class StringLengthComparator
    implements Comparator {
        public static int length = 0;

        StringLengthComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int aLength = ((PropertyLine)a).getExpectedLength(length);
            int bLength = ((PropertyLine)b).getExpectedLength(length);
            return aLength - bLength;
        }
    }

    private class ValueComparator
    implements Comparator {
        private ValueComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            String aMessage = ((PropertyLine)a).getMessage();
            String bMessage = ((PropertyLine)b).getMessage();
            if (aMessage == null && bMessage == null) {
                return 0;
            }
            if (aMessage == null) {
                return -1;
            }
            if (bMessage == null) {
                return 1;
            }
            return aMessage.compareTo(bMessage);
        }
    }
}

