/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.internal.GenericRuntimeUtil;
import org.eclipse.jst.server.core.internal.IGenericRuntime;
import org.eclipse.jst.server.core.internal.IGenericRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class GenericRuntimeTestCase
extends TestCase {
    private static final String RUNTIME_TYPE_ID = "org.eclipse.jst.server.core.runtimeType";
    protected static IRuntime runtime;
    protected static IRuntime runtimeWC;
    protected static IGenericRuntime genericRuntime;
    protected static IGenericRuntimeWorkingCopy genericRuntimeWC;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void test00CreateRuntime() throws Exception {
        IRuntimeType rt = ServerCore.findRuntimeType((String)RUNTIME_TYPE_ID);
        IRuntimeWorkingCopy wc = rt.createRuntime("a", null);
        wc.setLocation((IPath)new Path("c://test"));
        runtime = wc.save(false, null);
        GenericRuntimeTestCase.assertTrue((!runtime.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void test01ValidateRuntime() throws Exception {
        IStatus status = runtime.validate(null);
        GenericRuntimeTestCase.assertTrue((!status.isOK() ? 1 : 0) != 0);
    }

    public void test02Util() throws Exception {
        GenericRuntimeTestCase.assertTrue((boolean)GenericRuntimeUtil.isGenericJ2EERuntime((IRuntime)runtime));
    }

    public void test03Adapt() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.internal.IGenericRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        genericRuntime = (IGenericRuntime)runtime.getAdapter((Class)clazz);
        GenericRuntimeTestCase.assertNotNull((Object)genericRuntime);
    }

    public void test04Adapt() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.internal.IGenericRuntimeWorkingCopy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericRuntimeTestCase.assertNotNull((Object)runtime.getAdapter((Class)clazz));
    }

    public void test05GetJVM() throws Exception {
        GenericRuntimeTestCase.assertNotNull((Object)genericRuntime.getVMInstall());
    }

    public void test06Adapt() throws Exception {
        runtimeWC = runtime.createWorkingCopy();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.internal.IGenericRuntimeWorkingCopy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        genericRuntimeWC = (IGenericRuntimeWorkingCopy)runtimeWC.loadAdapter((Class)clazz, null);
        GenericRuntimeTestCase.assertNotNull((Object)genericRuntimeWC);
    }

    public void test07Adapt() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.internal.IGenericRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericRuntimeTestCase.assertNotNull((Object)runtimeWC.loadAdapter((Class)clazz, null));
    }

    public void test08SetJVM() throws Exception {
        GenericRuntimeTestCase.assertNotNull((Object)genericRuntimeWC.getVMInstall());
        genericRuntimeWC.setVMInstall(null);
        GenericRuntimeTestCase.assertNotNull((Object)genericRuntimeWC.getVMInstall());
    }

    public void test09DeleteRuntime() throws Exception {
        runtime.delete();
        runtime = null;
        runtimeWC = null;
        genericRuntime = null;
        genericRuntimeWC = null;
    }
}

