/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query;

import java.util.Collections;
import java.util.List;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;

public abstract class AbstractResultSet
implements IResultSet {
    private List _results;
    private boolean _isClosed = false;

    public List getResults() throws MetaDataException {
        this.initIfNecessary();
        return this._results;
    }

    public final void close() throws MetaDataException {
        this.doClose();
        this._isClosed = true;
        this._results = null;
    }

    protected void doClose() throws MetaDataException {
    }

    public final boolean isClosed() {
        return this._isClosed;
    }

    protected abstract List getInternalResults();

    private void initIfNecessary() throws MetaDataException {
        if (this._isClosed) {
            throw new MetaDataException("Attempt to access a closed resultset.");
        }
        if (this._results == null) {
            List checkNullResults = this.getInternalResults();
            if (checkNullResults == null) {
                checkNullResults = Collections.EMPTY_LIST;
            }
            this._results = Collections.unmodifiableList(checkNullResults);
        }
    }
}

