/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.EnumerationType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ColorType
extends EnumerationType
implements IPossibleValues {
    public static String[] COLORS = new String[]{"Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua"};
    private RGB[] _rgb;

    protected String getReturnType() {
        return "java.lang.String";
    }

    public boolean isValidValue(String value) {
        boolean bValid = true;
        String trimmedVal = value.trim();
        if (trimmedVal.length() == 0) {
            bValid = false;
        } else if (trimmedVal.charAt(0) == '#' && trimmedVal.length() == 7) {
            int i = 1;
            while (i < 7) {
                if (trimmedVal.charAt(i) < '0' || trimmedVal.charAt(i) > '9' && trimmedVal.charAt(i) < 'A' || trimmedVal.charAt(i) > 'F' && trimmedVal.charAt(i) < 'a' || trimmedVal.charAt(i) > 'f') {
                    bValid = false;
                    break;
                }
                ++i;
            }
        } else {
            bValid = false;
            int i = 0;
            while (i < COLORS.length) {
                if (trimmedVal.equalsIgnoreCase(COLORS[i])) {
                    bValid = true;
                    break;
                }
                ++i;
            }
        }
        if (!bValid) {
            this.addNewValidationMessage(Messages.ColorType_invalid_color);
        }
        return this.getValidationMessages().isEmpty();
    }

    public List getPossibleValues() {
        ArrayList<PossibleValue> ret = new ArrayList<PossibleValue>(COLORS.length);
        int i = 0;
        while (i < COLORS.length) {
            PossibleValue pv = new PossibleValue(COLORS[i]);
            pv.setIcon(this.createImage(i));
            ret.add(pv);
            ++i;
        }
        return ret;
    }

    private ImageDescriptor createImage(int color) {
        PaletteData pd = this.getPaletteData(color);
        return ImageDescriptor.createFromImageData((ImageData)new ImageData(16, 16, 1, pd));
    }

    private PaletteData getPaletteData(int color) {
        if (this._rgb == null) {
            this._rgb = new RGB[16];
            this._rgb[0] = new RGB(0, 0, 0);
            this._rgb[1] = new RGB(192, 192, 192);
            this._rgb[2] = new RGB(128, 128, 128);
            this._rgb[3] = new RGB(255, 255, 255);
            this._rgb[4] = new RGB(128, 0, 0);
            this._rgb[5] = new RGB(255, 0, 0);
            this._rgb[6] = new RGB(128, 0, 128);
            this._rgb[7] = new RGB(255, 0, 255);
            this._rgb[8] = new RGB(0, 128, 0);
            this._rgb[9] = new RGB(0, 255, 0);
            this._rgb[10] = new RGB(128, 128, 0);
            this._rgb[11] = new RGB(255, 255, 0);
            this._rgb[12] = new RGB(0, 0, 128);
            this._rgb[13] = new RGB(0, 0, 255);
            this._rgb[14] = new RGB(0, 128, 128);
            this._rgb[15] = new RGB(0, 255, 255);
        }
        RGB[] rgbColor = new RGB[1];
        System.arraycopy(this._rgb, color, rgbColor, 0, 1);
        return new PaletteData(rgbColor);
    }
}

