/***************************************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM Corporation - initial API and implementation
 *   Oracle Corporation - revision
 **************************************************************************************************/
package org.eclipse.jst.jsf.facesconfig.edit.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jst.jsf.facesconfig.emf.util.FacesConfigAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FacesConfigItemProviderAdapterFactory extends FacesConfigAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation and others";

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection supportedTypes = new ArrayList();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated NOT
     */
	public FacesConfigItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);		
        supportedTypes.add(ITableItemLabelProvider.class);
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ActionListenerType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ActionListenerTypeItemProvider actionListenerTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ActionListenerType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createActionListenerTypeAdapter() {
        if (actionListenerTypeItemProvider == null) {
            actionListenerTypeItemProvider = new ActionListenerTypeItemProvider(this);
        }

        return actionListenerTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ApplicationFactoryType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ApplicationFactoryTypeItemProvider applicationFactoryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ApplicationFactoryType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createApplicationFactoryTypeAdapter() {
        if (applicationFactoryTypeItemProvider == null) {
            applicationFactoryTypeItemProvider = new ApplicationFactoryTypeItemProvider(this);
        }

        return applicationFactoryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ApplicationType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ApplicationTypeItemProvider applicationTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ApplicationType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createApplicationTypeAdapter() {
        if (applicationTypeItemProvider == null) {
            applicationTypeItemProvider = new ApplicationTypeItemProvider(this);
        }

        return applicationTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.AttributeClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected AttributeClassTypeItemProvider attributeClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.AttributeClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createAttributeClassTypeAdapter() {
        if (attributeClassTypeItemProvider == null) {
            attributeClassTypeItemProvider = new AttributeClassTypeItemProvider(this);
        }

        return attributeClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.AttributeExtensionType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected AttributeExtensionTypeItemProvider attributeExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.AttributeExtensionType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createAttributeExtensionTypeAdapter() {
        if (attributeExtensionTypeItemProvider == null) {
            attributeExtensionTypeItemProvider = new AttributeExtensionTypeItemProvider(this);
        }

        return attributeExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.AttributeNameType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected AttributeNameTypeItemProvider attributeNameTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.AttributeNameType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createAttributeNameTypeAdapter() {
        if (attributeNameTypeItemProvider == null) {
            attributeNameTypeItemProvider = new AttributeNameTypeItemProvider(this);
        }

        return attributeNameTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.AttributeType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected AttributeTypeItemProvider attributeTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.AttributeType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createAttributeTypeAdapter() {
        if (attributeTypeItemProvider == null) {
            attributeTypeItemProvider = new AttributeTypeItemProvider(this);
        }

        return attributeTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComponentClassTypeItemProvider componentClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createComponentClassTypeAdapter() {
        if (componentClassTypeItemProvider == null) {
            componentClassTypeItemProvider = new ComponentClassTypeItemProvider(this);
        }

        return componentClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentExtensionType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComponentExtensionTypeItemProvider componentExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentExtensionType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createComponentExtensionTypeAdapter() {
        if (componentExtensionTypeItemProvider == null) {
            componentExtensionTypeItemProvider = new ComponentExtensionTypeItemProvider(this);
        }

        return componentExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentFamilyType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComponentFamilyTypeItemProvider componentFamilyTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentFamilyType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createComponentFamilyTypeAdapter() {
        if (componentFamilyTypeItemProvider == null) {
            componentFamilyTypeItemProvider = new ComponentFamilyTypeItemProvider(this);
        }

        return componentFamilyTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComponentTypeItemProvider componentTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createComponentTypeAdapter() {
        if (componentTypeItemProvider == null) {
            componentTypeItemProvider = new ComponentTypeItemProvider(this);
        }

        return componentTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentTypeType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComponentTypeTypeItemProvider componentTypeTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ComponentTypeType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createComponentTypeTypeAdapter() {
        if (componentTypeTypeItemProvider == null) {
            componentTypeTypeItemProvider = new ComponentTypeTypeItemProvider(this);
        }

        return componentTypeTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ConverterClassTypeItemProvider converterClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createConverterClassTypeAdapter() {
        if (converterClassTypeItemProvider == null) {
            converterClassTypeItemProvider = new ConverterClassTypeItemProvider(this);
        }

        return converterClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ConverterForClassTypeItemProvider converterForClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createConverterForClassTypeAdapter() {
        if (converterForClassTypeItemProvider == null) {
            converterForClassTypeItemProvider = new ConverterForClassTypeItemProvider(this);
        }

        return converterForClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ConverterIdTypeItemProvider converterIdTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createConverterIdTypeAdapter() {
        if (converterIdTypeItemProvider == null) {
            converterIdTypeItemProvider = new ConverterIdTypeItemProvider(this);
        }

        return converterIdTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ConverterTypeItemProvider converterTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createConverterTypeAdapter() {
        if (converterTypeItemProvider == null) {
            converterTypeItemProvider = new ConverterTypeItemProvider(this);
        }

        return converterTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DefaultLocaleTypeItemProvider defaultLocaleTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDefaultLocaleTypeAdapter() {
        if (defaultLocaleTypeItemProvider == null) {
            defaultLocaleTypeItemProvider = new DefaultLocaleTypeItemProvider(this);
        }

        return defaultLocaleTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DefaultRenderKitIdTypeItemProvider defaultRenderKitIdTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDefaultRenderKitIdTypeAdapter() {
        if (defaultRenderKitIdTypeItemProvider == null) {
            defaultRenderKitIdTypeItemProvider = new DefaultRenderKitIdTypeItemProvider(this);
        }

        return defaultRenderKitIdTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.DefaultValueType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DefaultValueTypeItemProvider defaultValueTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.DefaultValueType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDefaultValueTypeAdapter() {
        if (defaultValueTypeItemProvider == null) {
            defaultValueTypeItemProvider = new DefaultValueTypeItemProvider(this);
        }

        return defaultValueTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.DescriptionType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DescriptionTypeItemProvider descriptionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.DescriptionType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDescriptionTypeAdapter() {
        if (descriptionTypeItemProvider == null) {
            descriptionTypeItemProvider = new DescriptionTypeItemProvider(this);
        }

        return descriptionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DisplayNameTypeItemProvider displayNameTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDisplayNameTypeAdapter() {
        if (displayNameTypeItemProvider == null) {
            displayNameTypeItemProvider = new DisplayNameTypeItemProvider(this);
        }

        return displayNameTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.DocumentRoot} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DocumentRootItemProvider documentRootItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.DocumentRoot}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDocumentRootAdapter() {
        if (documentRootItemProvider == null) {
            documentRootItemProvider = new DocumentRootItemProvider(this);
        }

        return documentRootItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.DynamicAttribute} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DynamicAttributeItemProvider dynamicAttributeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.DynamicAttribute}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createDynamicAttributeAdapter() {
        if (dynamicAttributeItemProvider == null) {
            dynamicAttributeItemProvider = new DynamicAttributeItemProvider(this);
        }

        return dynamicAttributeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.DynamicElement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DynamicElementItemProvider dynamicElementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.DynamicElement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createDynamicElementAdapter() {
        if (dynamicElementItemProvider == null) {
            dynamicElementItemProvider = new DynamicElementItemProvider(this);
        }

        return dynamicElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ELResolverType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ELResolverTypeItemProvider elResolverTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ELResolverType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createELResolverTypeAdapter() {
        if (elResolverTypeItemProvider == null) {
            elResolverTypeItemProvider = new ELResolverTypeItemProvider(this);
        }

        return elResolverTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FacesConfigExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FacesConfigExtensionTypeItemProvider facesConfigExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FacesConfigExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createFacesConfigExtensionTypeAdapter() {
        if (facesConfigExtensionTypeItemProvider == null) {
            facesConfigExtensionTypeItemProvider = new FacesConfigExtensionTypeItemProvider(this);
        }

        return facesConfigExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FactoryExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FactoryExtensionTypeItemProvider factoryExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FactoryExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createFactoryExtensionTypeAdapter() {
        if (factoryExtensionTypeItemProvider == null) {
            factoryExtensionTypeItemProvider = new FactoryExtensionTypeItemProvider(this);
        }

        return factoryExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.LifecycleExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected LifecycleExtensionTypeItemProvider lifecycleExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.LifecycleExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createLifecycleExtensionTypeAdapter() {
        if (lifecycleExtensionTypeItemProvider == null) {
            lifecycleExtensionTypeItemProvider = new LifecycleExtensionTypeItemProvider(this);
        }

        return lifecycleExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ManagedBeanExtensionTypeItemProvider managedBeanExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createManagedBeanExtensionTypeAdapter() {
        if (managedBeanExtensionTypeItemProvider == null) {
            managedBeanExtensionTypeItemProvider = new ManagedBeanExtensionTypeItemProvider(this);
        }

        return managedBeanExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected NavigationRuleExtensionTypeItemProvider navigationRuleExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createNavigationRuleExtensionTypeAdapter() {
        if (navigationRuleExtensionTypeItemProvider == null) {
            navigationRuleExtensionTypeItemProvider = new NavigationRuleExtensionTypeItemProvider(this);
        }

        return navigationRuleExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ValidatorExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ValidatorExtensionTypeItemProvider validatorExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ValidatorExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createValidatorExtensionTypeAdapter() {
        if (validatorExtensionTypeItemProvider == null) {
            validatorExtensionTypeItemProvider = new ValidatorExtensionTypeItemProvider(this);
        }

        return validatorExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FacesConfigTypeItemProvider facesConfigTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFacesConfigTypeAdapter() {
        if (facesConfigTypeItemProvider == null) {
            facesConfigTypeItemProvider = new FacesConfigTypeItemProvider(this);
        }

        return facesConfigTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FacesContextFactoryType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FacesContextFactoryTypeItemProvider facesContextFactoryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FacesContextFactoryType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFacesContextFactoryTypeAdapter() {
        if (facesContextFactoryTypeItemProvider == null) {
            facesContextFactoryTypeItemProvider = new FacesContextFactoryTypeItemProvider(this);
        }

        return facesContextFactoryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FacetExtensionType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FacetExtensionTypeItemProvider facetExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FacetExtensionType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFacetExtensionTypeAdapter() {
        if (facetExtensionTypeItemProvider == null) {
            facetExtensionTypeItemProvider = new FacetExtensionTypeItemProvider(this);
        }

        return facetExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FacetNameType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FacetNameTypeItemProvider facetNameTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FacetNameType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFacetNameTypeAdapter() {
        if (facetNameTypeItemProvider == null) {
            facetNameTypeItemProvider = new FacetNameTypeItemProvider(this);
        }

        return facetNameTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FacetType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FacetTypeItemProvider facetTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FacetType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFacetTypeAdapter() {
        if (facetTypeItemProvider == null) {
            facetTypeItemProvider = new FacetTypeItemProvider(this);
        }

        return facetTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FactoryType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FactoryTypeItemProvider factoryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FactoryType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFactoryTypeAdapter() {
        if (factoryTypeItemProvider == null) {
            factoryTypeItemProvider = new FactoryTypeItemProvider(this);
        }

        return factoryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FromActionType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FromActionTypeItemProvider fromActionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FromActionType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFromActionTypeAdapter() {
        if (fromActionTypeItemProvider == null) {
            fromActionTypeItemProvider = new FromActionTypeItemProvider(this);
        }

        return fromActionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FromOutcomeTypeItemProvider fromOutcomeTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFromOutcomeTypeAdapter() {
        if (fromOutcomeTypeItemProvider == null) {
            fromOutcomeTypeItemProvider = new FromOutcomeTypeItemProvider(this);
        }

        return fromOutcomeTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FromViewIdTypeItemProvider fromViewIdTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFromViewIdTypeAdapter() {
        if (fromViewIdTypeItemProvider == null) {
            fromViewIdTypeItemProvider = new FromViewIdTypeItemProvider(this);
        }

        return fromViewIdTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.IconType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IconTypeItemProvider iconTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.IconType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createIconTypeAdapter() {
        if (iconTypeItemProvider == null) {
            iconTypeItemProvider = new IconTypeItemProvider(this);
        }

        return iconTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.KeyClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected KeyClassTypeItemProvider keyClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.KeyClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createKeyClassTypeAdapter() {
        if (keyClassTypeItemProvider == null) {
            keyClassTypeItemProvider = new KeyClassTypeItemProvider(this);
        }

        return keyClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.KeyType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected KeyTypeItemProvider keyTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.KeyType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createKeyTypeAdapter() {
        if (keyTypeItemProvider == null) {
            keyTypeItemProvider = new KeyTypeItemProvider(this);
        }

        return keyTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.LargeIconType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected LargeIconTypeItemProvider largeIconTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.LargeIconType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createLargeIconTypeAdapter() {
        if (largeIconTypeItemProvider == null) {
            largeIconTypeItemProvider = new LargeIconTypeItemProvider(this);
        }

        return largeIconTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.LifecycleFactoryType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected LifecycleFactoryTypeItemProvider lifecycleFactoryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.LifecycleFactoryType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createLifecycleFactoryTypeAdapter() {
        if (lifecycleFactoryTypeItemProvider == null) {
            lifecycleFactoryTypeItemProvider = new LifecycleFactoryTypeItemProvider(this);
        }

        return lifecycleFactoryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.LifecycleType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected LifecycleTypeItemProvider lifecycleTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.LifecycleType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createLifecycleTypeAdapter() {
        if (lifecycleTypeItemProvider == null) {
            lifecycleTypeItemProvider = new LifecycleTypeItemProvider(this);
        }

        return lifecycleTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ListEntriesTypeItemProvider listEntriesTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createListEntriesTypeAdapter() {
        if (listEntriesTypeItemProvider == null) {
            listEntriesTypeItemProvider = new ListEntriesTypeItemProvider(this);
        }

        return listEntriesTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected LocaleConfigTypeItemProvider localeConfigTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createLocaleConfigTypeAdapter() {
        if (localeConfigTypeItemProvider == null) {
            localeConfigTypeItemProvider = new LocaleConfigTypeItemProvider(this);
        }

        return localeConfigTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ManagedBeanClassTypeItemProvider managedBeanClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createManagedBeanClassTypeAdapter() {
        if (managedBeanClassTypeItemProvider == null) {
            managedBeanClassTypeItemProvider = new ManagedBeanClassTypeItemProvider(this);
        }

        return managedBeanClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ManagedBeanNameTypeItemProvider managedBeanNameTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createManagedBeanNameTypeAdapter() {
        if (managedBeanNameTypeItemProvider == null) {
            managedBeanNameTypeItemProvider = new ManagedBeanNameTypeItemProvider(this);
        }

        return managedBeanNameTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ManagedBeanScopeTypeItemProvider managedBeanScopeTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createManagedBeanScopeTypeAdapter() {
        if (managedBeanScopeTypeItemProvider == null) {
            managedBeanScopeTypeItemProvider = new ManagedBeanScopeTypeItemProvider(this);
        }

        return managedBeanScopeTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ManagedBeanTypeItemProvider managedBeanTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createManagedBeanTypeAdapter() {
        if (managedBeanTypeItemProvider == null) {
            managedBeanTypeItemProvider = new ManagedBeanTypeItemProvider(this);
        }

        return managedBeanTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ManagedPropertyTypeItemProvider managedPropertyTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createManagedPropertyTypeAdapter() {
        if (managedPropertyTypeItemProvider == null) {
            managedPropertyTypeItemProvider = new ManagedPropertyTypeItemProvider(this);
        }

        return managedPropertyTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected MapEntriesTypeItemProvider mapEntriesTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createMapEntriesTypeAdapter() {
        if (mapEntriesTypeItemProvider == null) {
            mapEntriesTypeItemProvider = new MapEntriesTypeItemProvider(this);
        }

        return mapEntriesTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.MapEntryType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected MapEntryTypeItemProvider mapEntryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.MapEntryType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createMapEntryTypeAdapter() {
        if (mapEntryTypeItemProvider == null) {
            mapEntryTypeItemProvider = new MapEntryTypeItemProvider(this);
        }

        return mapEntryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.MessageBundleType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected MessageBundleTypeItemProvider messageBundleTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.MessageBundleType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createMessageBundleTypeAdapter() {
        if (messageBundleTypeItemProvider == null) {
            messageBundleTypeItemProvider = new MessageBundleTypeItemProvider(this);
        }

        return messageBundleTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected NavigationCaseTypeItemProvider navigationCaseTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createNavigationCaseTypeAdapter() {
        if (navigationCaseTypeItemProvider == null) {
            navigationCaseTypeItemProvider = new NavigationCaseTypeItemProvider(this);
        }

        return navigationCaseTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.NavigationHandlerType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected NavigationHandlerTypeItemProvider navigationHandlerTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.NavigationHandlerType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createNavigationHandlerTypeAdapter() {
        if (navigationHandlerTypeItemProvider == null) {
            navigationHandlerTypeItemProvider = new NavigationHandlerTypeItemProvider(this);
        }

        return navigationHandlerTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected NavigationRuleTypeItemProvider navigationRuleTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createNavigationRuleTypeAdapter() {
        if (navigationRuleTypeItemProvider == null) {
            navigationRuleTypeItemProvider = new NavigationRuleTypeItemProvider(this);
        }

        return navigationRuleTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.NullValueType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected NullValueTypeItemProvider nullValueTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.NullValueType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createNullValueTypeAdapter() {
        if (nullValueTypeItemProvider == null) {
            nullValueTypeItemProvider = new NullValueTypeItemProvider(this);
        }

        return nullValueTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.PhaseListenerType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected PhaseListenerTypeItemProvider phaseListenerTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.PhaseListenerType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createPhaseListenerTypeAdapter() {
        if (phaseListenerTypeItemProvider == null) {
            phaseListenerTypeItemProvider = new PhaseListenerTypeItemProvider(this);
        }

        return phaseListenerTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected PropertyClassTypeItemProvider propertyClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createPropertyClassTypeAdapter() {
        if (propertyClassTypeItemProvider == null) {
            propertyClassTypeItemProvider = new PropertyClassTypeItemProvider(this);
        }

        return propertyClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyExtensionType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected PropertyExtensionTypeItemProvider propertyExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyExtensionType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createPropertyExtensionTypeAdapter() {
        if (propertyExtensionTypeItemProvider == null) {
            propertyExtensionTypeItemProvider = new PropertyExtensionTypeItemProvider(this);
        }

        return propertyExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected PropertyNameTypeItemProvider propertyNameTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createPropertyNameTypeAdapter() {
        if (propertyNameTypeItemProvider == null) {
            propertyNameTypeItemProvider = new PropertyNameTypeItemProvider(this);
        }

        return propertyNameTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyResolverType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected PropertyResolverTypeItemProvider propertyResolverTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyResolverType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createPropertyResolverTypeAdapter() {
        if (propertyResolverTypeItemProvider == null) {
            propertyResolverTypeItemProvider = new PropertyResolverTypeItemProvider(this);
        }

        return propertyResolverTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected PropertyTypeItemProvider propertyTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.PropertyType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createPropertyTypeAdapter() {
        if (propertyTypeItemProvider == null) {
            propertyTypeItemProvider = new PropertyTypeItemProvider(this);
        }

        return propertyTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RedirectType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RedirectTypeItemProvider redirectTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RedirectType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRedirectTypeAdapter() {
        if (redirectTypeItemProvider == null) {
            redirectTypeItemProvider = new RedirectTypeItemProvider(this);
        }

        return redirectTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ReferencedBeanClassTypeItemProvider referencedBeanClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createReferencedBeanClassTypeAdapter() {
        if (referencedBeanClassTypeItemProvider == null) {
            referencedBeanClassTypeItemProvider = new ReferencedBeanClassTypeItemProvider(this);
        }

        return referencedBeanClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanNameType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ReferencedBeanNameTypeItemProvider referencedBeanNameTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanNameType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createReferencedBeanNameTypeAdapter() {
        if (referencedBeanNameTypeItemProvider == null) {
            referencedBeanNameTypeItemProvider = new ReferencedBeanNameTypeItemProvider(this);
        }

        return referencedBeanNameTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ReferencedBeanTypeItemProvider referencedBeanTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createReferencedBeanTypeAdapter() {
        if (referencedBeanTypeItemProvider == null) {
            referencedBeanTypeItemProvider = new ReferencedBeanTypeItemProvider(this);
        }

        return referencedBeanTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RendererClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RendererClassTypeItemProvider rendererClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RendererClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRendererClassTypeAdapter() {
        if (rendererClassTypeItemProvider == null) {
            rendererClassTypeItemProvider = new RendererClassTypeItemProvider(this);
        }

        return rendererClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RendererExtensionType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RendererExtensionTypeItemProvider rendererExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RendererExtensionType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRendererExtensionTypeAdapter() {
        if (rendererExtensionTypeItemProvider == null) {
            rendererExtensionTypeItemProvider = new RendererExtensionTypeItemProvider(this);
        }

        return rendererExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RendererType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RendererTypeItemProvider rendererTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RendererType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRendererTypeAdapter() {
        if (rendererTypeItemProvider == null) {
            rendererTypeItemProvider = new RendererTypeItemProvider(this);
        }

        return rendererTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RendererTypeType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RendererTypeTypeItemProvider rendererTypeTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RendererTypeType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRendererTypeTypeAdapter() {
        if (rendererTypeTypeItemProvider == null) {
            rendererTypeTypeItemProvider = new RendererTypeTypeItemProvider(this);
        }

        return rendererTypeTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RenderKitClassTypeItemProvider renderKitClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRenderKitClassTypeAdapter() {
        if (renderKitClassTypeItemProvider == null) {
            renderKitClassTypeItemProvider = new RenderKitClassTypeItemProvider(this);
        }

        return renderKitClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitFactoryType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RenderKitFactoryTypeItemProvider renderKitFactoryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitFactoryType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRenderKitFactoryTypeAdapter() {
        if (renderKitFactoryTypeItemProvider == null) {
            renderKitFactoryTypeItemProvider = new RenderKitFactoryTypeItemProvider(this);
        }

        return renderKitFactoryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitIdType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RenderKitIdTypeItemProvider renderKitIdTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitIdType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRenderKitIdTypeAdapter() {
        if (renderKitIdTypeItemProvider == null) {
            renderKitIdTypeItemProvider = new RenderKitIdTypeItemProvider(this);
        }

        return renderKitIdTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RenderKitTypeItemProvider renderKitTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRenderKitTypeAdapter() {
        if (renderKitTypeItemProvider == null) {
            renderKitTypeItemProvider = new RenderKitTypeItemProvider(this);
        }

        return renderKitTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.SmallIconType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SmallIconTypeItemProvider smallIconTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.SmallIconType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createSmallIconTypeAdapter() {
        if (smallIconTypeItemProvider == null) {
            smallIconTypeItemProvider = new SmallIconTypeItemProvider(this);
        }

        return smallIconTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.StateManagerType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected StateManagerTypeItemProvider stateManagerTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.StateManagerType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createStateManagerTypeAdapter() {
        if (stateManagerTypeItemProvider == null) {
            stateManagerTypeItemProvider = new StateManagerTypeItemProvider(this);
        }

        return stateManagerTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.SuggestedValueType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SuggestedValueTypeItemProvider suggestedValueTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.SuggestedValueType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createSuggestedValueTypeAdapter() {
        if (suggestedValueTypeItemProvider == null) {
            suggestedValueTypeItemProvider = new SuggestedValueTypeItemProvider(this);
        }

        return suggestedValueTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SupportedLocaleTypeItemProvider supportedLocaleTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createSupportedLocaleTypeAdapter() {
        if (supportedLocaleTypeItemProvider == null) {
            supportedLocaleTypeItemProvider = new SupportedLocaleTypeItemProvider(this);
        }

        return supportedLocaleTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ToViewIdTypeItemProvider toViewIdTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createToViewIdTypeAdapter() {
        if (toViewIdTypeItemProvider == null) {
            toViewIdTypeItemProvider = new ToViewIdTypeItemProvider(this);
        }

        return toViewIdTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ValidatorClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ValidatorClassTypeItemProvider validatorClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ValidatorClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createValidatorClassTypeAdapter() {
        if (validatorClassTypeItemProvider == null) {
            validatorClassTypeItemProvider = new ValidatorClassTypeItemProvider(this);
        }

        return validatorClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ValidatorIdTypeItemProvider validatorIdTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createValidatorIdTypeAdapter() {
        if (validatorIdTypeItemProvider == null) {
            validatorIdTypeItemProvider = new ValidatorIdTypeItemProvider(this);
        }

        return validatorIdTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ValidatorType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ValidatorTypeItemProvider validatorTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ValidatorType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createValidatorTypeAdapter() {
        if (validatorTypeItemProvider == null) {
            validatorTypeItemProvider = new ValidatorTypeItemProvider(this);
        }

        return validatorTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ValueClassType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ValueClassTypeItemProvider valueClassTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ValueClassType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createValueClassTypeAdapter() {
        if (valueClassTypeItemProvider == null) {
            valueClassTypeItemProvider = new ValueClassTypeItemProvider(this);
        }

        return valueClassTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ValueType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ValueTypeItemProvider valueTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ValueType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createValueTypeAdapter() {
        if (valueTypeItemProvider == null) {
            valueTypeItemProvider = new ValueTypeItemProvider(this);
        }

        return valueTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.VariableResolverType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected VariableResolverTypeItemProvider variableResolverTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.VariableResolverType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createVariableResolverTypeAdapter() {
        if (variableResolverTypeItemProvider == null) {
            variableResolverTypeItemProvider = new VariableResolverTypeItemProvider(this);
        }

        return variableResolverTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ViewHandlerTypeItemProvider viewHandlerTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createViewHandlerTypeAdapter() {
        if (viewHandlerTypeItemProvider == null) {
            viewHandlerTypeItemProvider = new ViewHandlerTypeItemProvider(this);
        }

        return viewHandlerTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ApplicationExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ApplicationExtensionTypeItemProvider applicationExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ApplicationExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createApplicationExtensionTypeAdapter() {
        if (applicationExtensionTypeItemProvider == null) {
            applicationExtensionTypeItemProvider = new ApplicationExtensionTypeItemProvider(this);
        }

        return applicationExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConverterExtensionTypeItemProvider converterExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ConverterExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createConverterExtensionTypeAdapter() {
        if (converterExtensionTypeItemProvider == null) {
            converterExtensionTypeItemProvider = new ConverterExtensionTypeItemProvider(this);
        }

        return converterExtensionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.ResourceBundleType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ResourceBundleTypeItemProvider resourceBundleTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.ResourceBundleType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createResourceBundleTypeAdapter() {
        if (resourceBundleTypeItemProvider == null) {
            resourceBundleTypeItemProvider = new ResourceBundleTypeItemProvider(this);
        }

        return resourceBundleTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.BaseNameType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BaseNameTypeItemProvider baseNameTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.BaseNameType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createBaseNameTypeAdapter() {
        if (baseNameTypeItemProvider == null) {
            baseNameTypeItemProvider = new BaseNameTypeItemProvider(this);
        }

        return baseNameTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.VarType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected VarTypeItemProvider varTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.VarType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createVarTypeAdapter() {
        if (varTypeItemProvider == null) {
            varTypeItemProvider = new VarTypeItemProvider(this);
        }

        return varTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitExtensionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RenderKitExtensionTypeItemProvider renderKitExtensionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.jst.jsf.facesconfig.emf.RenderKitExtensionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createRenderKitExtensionTypeAdapter() {
        if (renderKitExtensionTypeItemProvider == null) {
            renderKitExtensionTypeItemProvider = new RenderKitExtensionTypeItemProvider(this);
        }

        return renderKitExtensionTypeItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (actionListenerTypeItemProvider != null) actionListenerTypeItemProvider.dispose();
        if (applicationFactoryTypeItemProvider != null) applicationFactoryTypeItemProvider.dispose();
        if (applicationTypeItemProvider != null) applicationTypeItemProvider.dispose();
        if (attributeClassTypeItemProvider != null) attributeClassTypeItemProvider.dispose();
        if (attributeExtensionTypeItemProvider != null) attributeExtensionTypeItemProvider.dispose();
        if (attributeNameTypeItemProvider != null) attributeNameTypeItemProvider.dispose();
        if (attributeTypeItemProvider != null) attributeTypeItemProvider.dispose();
        if (componentClassTypeItemProvider != null) componentClassTypeItemProvider.dispose();
        if (componentExtensionTypeItemProvider != null) componentExtensionTypeItemProvider.dispose();
        if (componentFamilyTypeItemProvider != null) componentFamilyTypeItemProvider.dispose();
        if (componentTypeItemProvider != null) componentTypeItemProvider.dispose();
        if (componentTypeTypeItemProvider != null) componentTypeTypeItemProvider.dispose();
        if (converterClassTypeItemProvider != null) converterClassTypeItemProvider.dispose();
        if (converterForClassTypeItemProvider != null) converterForClassTypeItemProvider.dispose();
        if (converterIdTypeItemProvider != null) converterIdTypeItemProvider.dispose();
        if (converterTypeItemProvider != null) converterTypeItemProvider.dispose();
        if (defaultLocaleTypeItemProvider != null) defaultLocaleTypeItemProvider.dispose();
        if (defaultRenderKitIdTypeItemProvider != null) defaultRenderKitIdTypeItemProvider.dispose();
        if (defaultValueTypeItemProvider != null) defaultValueTypeItemProvider.dispose();
        if (descriptionTypeItemProvider != null) descriptionTypeItemProvider.dispose();
        if (displayNameTypeItemProvider != null) displayNameTypeItemProvider.dispose();
        if (documentRootItemProvider != null) documentRootItemProvider.dispose();
        if (dynamicAttributeItemProvider != null) dynamicAttributeItemProvider.dispose();
        if (dynamicElementItemProvider != null) dynamicElementItemProvider.dispose();
        if (facesConfigTypeItemProvider != null) facesConfigTypeItemProvider.dispose();
        if (facesContextFactoryTypeItemProvider != null) facesContextFactoryTypeItemProvider.dispose();
        if (facetExtensionTypeItemProvider != null) facetExtensionTypeItemProvider.dispose();
        if (facetNameTypeItemProvider != null) facetNameTypeItemProvider.dispose();
        if (facetTypeItemProvider != null) facetTypeItemProvider.dispose();
        if (factoryTypeItemProvider != null) factoryTypeItemProvider.dispose();
        if (fromActionTypeItemProvider != null) fromActionTypeItemProvider.dispose();
        if (fromOutcomeTypeItemProvider != null) fromOutcomeTypeItemProvider.dispose();
        if (fromViewIdTypeItemProvider != null) fromViewIdTypeItemProvider.dispose();
        if (iconTypeItemProvider != null) iconTypeItemProvider.dispose();
        if (keyClassTypeItemProvider != null) keyClassTypeItemProvider.dispose();
        if (keyTypeItemProvider != null) keyTypeItemProvider.dispose();
        if (largeIconTypeItemProvider != null) largeIconTypeItemProvider.dispose();
        if (lifecycleFactoryTypeItemProvider != null) lifecycleFactoryTypeItemProvider.dispose();
        if (lifecycleTypeItemProvider != null) lifecycleTypeItemProvider.dispose();
        if (listEntriesTypeItemProvider != null) listEntriesTypeItemProvider.dispose();
        if (localeConfigTypeItemProvider != null) localeConfigTypeItemProvider.dispose();
        if (managedBeanClassTypeItemProvider != null) managedBeanClassTypeItemProvider.dispose();
        if (managedBeanNameTypeItemProvider != null) managedBeanNameTypeItemProvider.dispose();
        if (managedBeanScopeTypeItemProvider != null) managedBeanScopeTypeItemProvider.dispose();
        if (managedBeanTypeItemProvider != null) managedBeanTypeItemProvider.dispose();
        if (managedPropertyTypeItemProvider != null) managedPropertyTypeItemProvider.dispose();
        if (mapEntriesTypeItemProvider != null) mapEntriesTypeItemProvider.dispose();
        if (mapEntryTypeItemProvider != null) mapEntryTypeItemProvider.dispose();
        if (messageBundleTypeItemProvider != null) messageBundleTypeItemProvider.dispose();
        if (navigationCaseTypeItemProvider != null) navigationCaseTypeItemProvider.dispose();
        if (navigationHandlerTypeItemProvider != null) navigationHandlerTypeItemProvider.dispose();
        if (navigationRuleTypeItemProvider != null) navigationRuleTypeItemProvider.dispose();
        if (nullValueTypeItemProvider != null) nullValueTypeItemProvider.dispose();
        if (phaseListenerTypeItemProvider != null) phaseListenerTypeItemProvider.dispose();
        if (propertyClassTypeItemProvider != null) propertyClassTypeItemProvider.dispose();
        if (propertyExtensionTypeItemProvider != null) propertyExtensionTypeItemProvider.dispose();
        if (propertyNameTypeItemProvider != null) propertyNameTypeItemProvider.dispose();
        if (propertyResolverTypeItemProvider != null) propertyResolverTypeItemProvider.dispose();
        if (propertyTypeItemProvider != null) propertyTypeItemProvider.dispose();
        if (redirectTypeItemProvider != null) redirectTypeItemProvider.dispose();
        if (referencedBeanClassTypeItemProvider != null) referencedBeanClassTypeItemProvider.dispose();
        if (referencedBeanNameTypeItemProvider != null) referencedBeanNameTypeItemProvider.dispose();
        if (referencedBeanTypeItemProvider != null) referencedBeanTypeItemProvider.dispose();
        if (rendererClassTypeItemProvider != null) rendererClassTypeItemProvider.dispose();
        if (rendererExtensionTypeItemProvider != null) rendererExtensionTypeItemProvider.dispose();
        if (rendererTypeItemProvider != null) rendererTypeItemProvider.dispose();
        if (rendererTypeTypeItemProvider != null) rendererTypeTypeItemProvider.dispose();
        if (renderKitClassTypeItemProvider != null) renderKitClassTypeItemProvider.dispose();
        if (renderKitFactoryTypeItemProvider != null) renderKitFactoryTypeItemProvider.dispose();
        if (renderKitIdTypeItemProvider != null) renderKitIdTypeItemProvider.dispose();
        if (renderKitTypeItemProvider != null) renderKitTypeItemProvider.dispose();
        if (smallIconTypeItemProvider != null) smallIconTypeItemProvider.dispose();
        if (stateManagerTypeItemProvider != null) stateManagerTypeItemProvider.dispose();
        if (suggestedValueTypeItemProvider != null) suggestedValueTypeItemProvider.dispose();
        if (supportedLocaleTypeItemProvider != null) supportedLocaleTypeItemProvider.dispose();
        if (toViewIdTypeItemProvider != null) toViewIdTypeItemProvider.dispose();
        if (validatorClassTypeItemProvider != null) validatorClassTypeItemProvider.dispose();
        if (validatorIdTypeItemProvider != null) validatorIdTypeItemProvider.dispose();
        if (validatorTypeItemProvider != null) validatorTypeItemProvider.dispose();
        if (valueClassTypeItemProvider != null) valueClassTypeItemProvider.dispose();
        if (valueTypeItemProvider != null) valueTypeItemProvider.dispose();
        if (variableResolverTypeItemProvider != null) variableResolverTypeItemProvider.dispose();
        if (viewHandlerTypeItemProvider != null) viewHandlerTypeItemProvider.dispose();
        if (applicationExtensionTypeItemProvider != null) applicationExtensionTypeItemProvider.dispose();
        if (converterExtensionTypeItemProvider != null) converterExtensionTypeItemProvider.dispose();
        if (elResolverTypeItemProvider != null) elResolverTypeItemProvider.dispose();
        if (facesConfigExtensionTypeItemProvider != null) facesConfigExtensionTypeItemProvider.dispose();
        if (factoryExtensionTypeItemProvider != null) factoryExtensionTypeItemProvider.dispose();
        if (lifecycleExtensionTypeItemProvider != null) lifecycleExtensionTypeItemProvider.dispose();
        if (managedBeanExtensionTypeItemProvider != null) managedBeanExtensionTypeItemProvider.dispose();
        if (navigationRuleExtensionTypeItemProvider != null) navigationRuleExtensionTypeItemProvider.dispose();
        if (validatorExtensionTypeItemProvider != null) validatorExtensionTypeItemProvider.dispose();
        if (resourceBundleTypeItemProvider != null) resourceBundleTypeItemProvider.dispose();
        if (baseNameTypeItemProvider != null) baseNameTypeItemProvider.dispose();
        if (varTypeItemProvider != null) varTypeItemProvider.dispose();
        if (renderKitExtensionTypeItemProvider != null) renderKitExtensionTypeItemProvider.dispose();
    }

}
