/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.w3c.dom.NodeList;

public class TestOpenEditorXML
extends TestCase {
    private final String PROJECT_NAME = "TestOpenEditorXML";
    private final String FILE_NAME = "testStructuredTextEditorXML.xml";
    private static IEditorPart fEditor;
    private static IFile fFile;
    private static boolean fIsSetup;
    static /* synthetic */ Class class$0;

    static {
        fIsSetup = false;
    }

    public TestOpenEditorXML() {
        super("TestStructredTextEditorXML");
    }

    protected void setUp() throws Exception {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage page;
        if (!fIsSetup) {
            this.createProject("TestOpenEditorXML");
            fFile = this.getOrCreateFile("TestOpenEditorXML/testStructuredTextEditorXML.xml");
            fIsSetup = true;
        }
        if (fIsSetup && fEditor == null && !((fEditor = IDE.openEditor((IWorkbenchPage)(page = (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()), (IFile)fFile, (boolean)true, (boolean)true)) instanceof XMLMultiPageEditorPart) && !(fEditor instanceof StructuredTextEditor)) {
            TestOpenEditorXML.assertTrue((String)"Unable to open structured text editor", (boolean)false);
        }
    }

    protected void tearDown() throws Exception {
        if (fEditor != null) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            page.closeEditor(fEditor, false);
            TestOpenEditorXML.assertTrue((String)"Unable to close editor", (boolean)true);
            fEditor = null;
        }
    }

    private void createProject(String projName) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private IFile getOrCreateFile(String filePath) {
        IFile blankFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (blankFile != null && !blankFile.exists()) {
            try {
                blankFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return blankFile;
    }

    public void testSetDocument() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument document = (IDocument)fEditor.getAdapter((Class)clazz);
        try {
            document.set("<hello></hello>");
        }
        catch (Exception e) {
            TestOpenEditorXML.assertTrue((String)("Unable to set text in editor: " + e), (boolean)false);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug151069() {
        IDocument doc;
        block8: {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            doc = (IDocument)fEditor.getAdapter((Class)clazz);
            doc.set("<html><body><h1>Title</h1></body></html>");
            IModelManager modelManager = StructuredModelManager.getModelManager();
            IDOMModel model = null;
            try {
                model = (IDOMModel)modelManager.getExistingModelForEdit(doc);
                if (model != null) {
                    NodeList nl = model.getDocument().getElementsByTagName("h1");
                    IDOMElement h1 = (IDOMElement)nl.item(0);
                    h1.setEditable(false, true);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (model != null) {
                    model.releaseFromEdit();
                }
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (model == null) break block8;
            }
            model.releaseFromEdit();
        }
        String newContent = "new content";
        ((IDocumentExtension4)doc).set(newContent, fFile.getModificationStamp());
        TestOpenEditorXML.assertEquals((String)"Set contents in document with read only regions failed", (String)newContent, (String)doc.get());
    }
}

