/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.extensions;

import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.binding.http.HTTPAddress;
import org.eclipse.wst.wsdl.binding.http.HTTPBinding;
import org.eclipse.wst.wsdl.binding.http.HTTPFactory;
import org.eclipse.wst.wsdl.binding.http.HTTPOperation;
import org.eclipse.wst.wsdl.binding.http.HTTPPackage;
import org.eclipse.wst.wsdl.binding.http.HTTPUrlEncoded;
import org.eclipse.wst.wsdl.binding.http.HTTPUrlReplacement;
import org.eclipse.wst.wsdl.binding.http.internal.generator.HTTPContentGenerator;
import org.eclipse.wst.wsdl.internal.generator.extension.ContentGeneratorExtensionFactoryRegistry;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.extensions.WSDLExtensionsTest;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;

public class HTTPExtensionsTest
extends WSDLExtensionsTest {
    private static final String ADDRESS_LOCATION_URI = "http://www.example.org/";
    private static final HTTPFactory HTTP_FACTORY = HTTPFactory.eINSTANCE;
    private static final String HTTP_LOCATION_URI = "http://www.example.org/HTTPTest/NewOperation";
    private static final String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();
    private static final String TARGET_NAMESPACE = "http://www.example.org/HTTPTest/";
    private static final String VERB_GET = "GET";
    private static final String VERB_PUT = "PUT";

    public static void main(String[] args) {
        TestRunner.run((Test)HTTPExtensionsTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new HTTPExtensionsTest("HTTPExtensionsCreation"){

            protected void runTest() {
                this.testHTTPExtensionsCreation();
            }
        });
        suite.addTest((Test)new HTTPExtensionsTest("EMFSerialization"){

            protected void runTest() {
                this.testEMFSerialization();
            }
        });
        suite.addTest((Test)new HTTPExtensionsTest("HTTPExtensionsReconciliation"){

            protected void runTest() {
                this.testHTTPExtensionsReconciliation();
            }
        });
        suite.addTest((Test)new HTTPExtensionsTest("HTTPContentGenerator"){

            protected void runTest() {
                this.testHTTPContentGenerator();
            }
        });
        return suite;
    }

    public HTTPExtensionsTest(String name) {
        super(name);
    }

    public void testHTTPExtensionsCreation() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/HTTP/HTTPTest.wsdl");
            String bindingName = "HTTPTestHTTP";
            QName bindingQName = new QName(TARGET_NAMESPACE, bindingName);
            Binding binding = (Binding)definition.getBinding(bindingQName);
            this.addHTTPBinding(binding);
            BindingOperation bindingOperation = (BindingOperation)binding.getBindingOperation("NewOperation", null, null);
            this.addHTTPOperation(bindingOperation);
            BindingInput bindingInput = bindingOperation.getEBindingInput();
            this.addHTTPBindingInput(bindingInput);
            this.addHTTPAddress(definition);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testHTTPExtensionsReconciliation() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/HTTP/HTTPExample.wsdl", true);
            String serviceName = "HTTPExample";
            String targetNamespace = "http://www.example.org/HTTPExample/";
            QName serviceQName = new QName(targetNamespace, serviceName);
            Service service = (Service)definition.getService(serviceQName);
            service.toString();
            Port port = (Port)service.getPort("HTTPExampleHTTP");
            List extensibilityElements = port.getExtensibilityElements();
            HTTPExtensionsTest.assertEquals((int)1, (int)extensibilityElements.size());
            HTTPAddress httpAddress = (HTTPAddress)extensibilityElements.get(0);
            String locationURI = httpAddress.getLocationURI();
            HTTPExtensionsTest.assertEquals((String)ADDRESS_LOCATION_URI, (String)locationURI);
            this.checkStringAttributeReconciliation((WSDLElement)httpAddress, "location", "test", (EStructuralFeature)HTTPPackage.Literals.HTTP_ADDRESS__LOCATION_URI);
            String bindingName = "HTTPExampleHTTP";
            QName bindingQName = new QName(targetNamespace, bindingName);
            Binding binding = (Binding)definition.getBinding(bindingQName);
            extensibilityElements = binding.getExtensibilityElements();
            HTTPExtensionsTest.assertEquals((int)1, (int)extensibilityElements.size());
            HTTPBinding httpBinding = (HTTPBinding)extensibilityElements.get(0);
            String verb = httpBinding.getVerb();
            HTTPExtensionsTest.assertEquals((String)VERB_GET, (String)verb);
            this.checkStringAttributeReconciliation((WSDLElement)httpBinding, "verb", VERB_PUT, (EStructuralFeature)HTTPPackage.Literals.HTTP_BINDING__VERB);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testEMFSerialization() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/HTTP/HTTPExample.wsdl", true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/generated/HTTPExample.xml"));
            Resource resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)definition);
            resource.save(null);
            resourceSet = new ResourceSetImpl();
            resource = resourceSet.getResource(fileURI, true);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testHTTPContentGenerator() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/HTTP/HTTPTest.wsdl");
            HTTPContentGenerator contentGenerator = (HTTPContentGenerator)ContentGeneratorExtensionFactoryRegistry.getInstance().getGeneratorClassFromName("HTTP");
            String locationURI = "http://test.org/example";
            contentGenerator.setAddressLocation(locationURI);
            contentGenerator.setVerb(1);
            String serviceName = "HTTPTest";
            QName serviceQName = new QName(TARGET_NAMESPACE, serviceName);
            Service service = (Service)definition.getService(serviceQName);
            Port port = (Port)service.getPort("HTTPTestHTTP");
            List extensibilityElements = port.getExtensibilityElements();
            HTTPExtensionsTest.assertEquals((int)0, (int)extensibilityElements.size());
            contentGenerator.generatePortContent(port);
            extensibilityElements = port.getExtensibilityElements();
            HTTPExtensionsTest.assertEquals((int)1, (int)extensibilityElements.size());
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)extensibilityElements.get(0);
            HTTPExtensionsTest.assertTrue((boolean)(extensibilityElement instanceof HTTPAddress));
            HTTPAddress httpAddress = (HTTPAddress)extensibilityElement;
            HTTPExtensionsTest.assertEquals((String)locationURI, (String)httpAddress.getLocationURI());
            QName bindingQName = new QName(TARGET_NAMESPACE, "HTTPTestHTTP");
            Binding binding = (Binding)definition.getBinding(bindingQName);
            QName portTypeQName = new QName(TARGET_NAMESPACE, "HTTPTest");
            PortType portType = (PortType)definition.getPortType(portTypeQName);
            contentGenerator.generateBindingContent(binding, portType);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    private void addHTTPAddress(Definition definition) {
        HTTPAddress httpAddress = HTTP_FACTORY.createHTTPAddress();
        httpAddress.setLocationURI(ADDRESS_LOCATION_URI);
        httpAddress.toString();
        String serviceName = "HTTPTest";
        QName serviceQName = new QName(TARGET_NAMESPACE, serviceName);
        Service service = (Service)definition.getService(serviceQName);
        service.toString();
        Port port = (Port)service.getPort("HTTPTestHTTP");
        port.addExtensibilityElement((javax.wsdl.extensions.ExtensibilityElement)httpAddress);
        port.toString();
    }

    private void addHTTPBinding(Binding binding) {
        binding.toString();
        HTTPBinding httpBinding = HTTP_FACTORY.createHTTPBinding();
        binding.addExtensibilityElement((javax.wsdl.extensions.ExtensibilityElement)httpBinding);
        httpBinding.setVerb(VERB_GET);
        httpBinding.toString();
    }

    private void addHTTPBindingInput(BindingInput bindingInput) {
        bindingInput.toString();
        HTTPUrlEncoded httpURLEncoded = HTTP_FACTORY.createHTTPUrlEncoded();
        bindingInput.addExtensibilityElement((javax.wsdl.extensions.ExtensibilityElement)httpURLEncoded);
        bindingInput.getExtensibilityElements().clear();
        HTTPUrlReplacement httpURLReplacement = HTTP_FACTORY.createHTTPUrlReplacement();
        bindingInput.addExtensibilityElement((javax.wsdl.extensions.ExtensibilityElement)httpURLReplacement);
    }

    private void addHTTPOperation(BindingOperation bindingOperation) {
        bindingOperation.toString();
        HTTPOperation httpOperation = HTTP_FACTORY.createHTTPOperation();
        httpOperation.setLocationURI(HTTP_LOCATION_URI);
        httpOperation.toString();
        bindingOperation.addExtensibilityElement((javax.wsdl.extensions.ExtensibilityElement)httpOperation);
    }
}

