/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.extensions;

import java.util.List;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.binding.mime.MIMEContent;
import org.eclipse.wst.wsdl.binding.mime.MIMEFactory;
import org.eclipse.wst.wsdl.binding.mime.MIMEMimeXml;
import org.eclipse.wst.wsdl.binding.mime.MIMEMultipartRelated;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;

public class MIMEExtensionsTest
extends TestCase {
    private static final MIMEFactory MIME_FACTORY = MIMEFactory.eINSTANCE;
    private static final SOAPFactory SOAP_FACTORY = SOAPFactory.eINSTANCE;
    private static final String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();
    private static final String TARGET_NAMESPACE = "http://www.example.org/MIMETest";

    public static void main(String[] args) {
        TestRunner.run((Test)MIMEExtensionsTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new MIMEExtensionsTest("MIMEExtensionsCreation"){

            protected void runTest() {
                this.testMIMEExtensionsCreation();
            }
        });
        suite.addTest((Test)new MIMEExtensionsTest("EMFSerialization"){

            protected void runTest() {
                this.testMIMEEMFSerialization();
            }
        });
        suite.addTest((Test)new MIMEExtensionsTest("MIMEExtensionsReconciliation"){

            protected void runTest() {
                this.testMIMEExtensionsReconciliation();
            }
        });
        return suite;
    }

    public MIMEExtensionsTest(String name) {
        super(name);
    }

    public void testMIMEExtensionsCreation() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/MIME/MIMETest.wsdl");
            String bindingName = "MIMETestBinding";
            QName bindingQName = new QName(TARGET_NAMESPACE, bindingName);
            Binding binding = (Binding)definition.getBinding(bindingQName);
            BindingOperation bindingOperation = (BindingOperation)binding.getBindingOperation("testOperation", null, null);
            BindingOutput bindingOutput = bindingOperation.getEBindingOutput();
            MIMEMultipartRelated multipart = MIME_FACTORY.createMIMEMultipartRelated();
            bindingOutput.addExtensibilityElement((ExtensibilityElement)multipart);
            multipart.toString();
            org.eclipse.wst.wsdl.binding.mime.MIMEPart mimePart = MIME_FACTORY.createMIMEPart();
            multipart.addMIMEPart((MIMEPart)mimePart);
            SOAPBody soapBody = SOAP_FACTORY.createSOAPBody();
            soapBody.setUse("literal");
            mimePart.addExtensibilityElement((ExtensibilityElement)soapBody);
            mimePart.toString();
            mimePart = MIME_FACTORY.createMIMEPart();
            multipart.addMIMEPart((MIMEPart)mimePart);
            MIMEContent mimeContent = MIME_FACTORY.createMIMEContent();
            mimeContent.setPart("responseData");
            mimeContent.setType("text/binary");
            mimeContent.toString();
            mimePart.addExtensibilityElement((ExtensibilityElement)mimeContent);
            List mimeParts = multipart.getMIMEParts();
            MIMEExtensionsTest.assertEquals((int)2, (int)mimeParts.size());
            MIMEMimeXml mimeXML = MIME_FACTORY.createMIMEMimeXml();
            bindingOutput.addExtensibilityElement((ExtensibilityElement)mimeXML);
            mimeXML.setPart("xmlData");
            mimeXML.toString();
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testMIMEExtensionsReconciliation() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/MIME/MIMEExample.wsdl", true);
            String targetNamespace = "http://www.example.org/MIMEExample";
            String bindingName = "MIMEExampleBinding";
            QName bindingQName = new QName(targetNamespace, bindingName);
            definition.getBinding(bindingQName);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testMIMEEMFSerialization() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/MIME/MIMEExample.wsdl", true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/generated/MIMEExample.xml"));
            Resource resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)definition);
            resource.save(null);
            resourceSet = new ResourceSetImpl();
            resource = resourceSet.getResource(fileURI, false);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }
}

