/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.IActionConfigFactory;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.util.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionDefinition
implements IActionDefinition {
    private String id;
    private String pluginId;
    private IProjectFacet facet;
    private IVersionExpr versionMatchExpr;
    private IFacetedProject.Action.Type type;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> propertiesReadOnly = Collections.unmodifiableMap(this.properties);
    private String delegateClassName;
    private IDelegate delegate;
    private String configFactoryClassName;

    ActionDefinition() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public IProjectFacet getProjectFacet() {
        return this.facet;
    }

    void setProjectFacet(IProjectFacet facet) {
        this.facet = facet;
    }

    @Override
    public IVersionExpr getVersionExpr() {
        return this.versionMatchExpr;
    }

    void setVersionExpr(IVersionExpr expr) {
        this.versionMatchExpr = expr;
    }

    @Override
    public IFacetedProject.Action.Type getActionType() {
        return this.type;
    }

    void setActionType(IFacetedProject.Action.Type type) {
        this.type = type;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.propertiesReadOnly;
    }

    void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Object createConfigObject(IProjectFacetVersion fv, String pjname) throws CoreException {
        if (this.configFactoryClassName == null) {
            return null;
        }
        IActionConfigFactory factory = PluginUtil.instantiate(this.pluginId, this.configFactoryClassName, IActionConfigFactory.class);
        Object config = factory.create();
        IActionConfig cfg = null;
        if (config instanceof IActionConfig) {
            cfg = (IActionConfig)config;
        } else {
            IAdapterManager m = Platform.getAdapterManager();
            cfg = (IActionConfig)m.loadAdapter(config, IActionConfig.class.getName());
        }
        if (cfg != null) {
            cfg.setVersion(fv);
            cfg.setProjectName(pjname);
        }
        return config;
    }

    String getDelegateClassName() {
        return this.delegateClassName;
    }

    void setDelegateClassName(String delegateClassName) {
        this.delegateClassName = delegateClassName;
    }

    IDelegate getDelegate() throws CoreException {
        if (this.delegate == null) {
            IDelegate obj;
            this.delegate = obj = PluginUtil.instantiate(this.pluginId, this.delegateClassName, IDelegate.class);
        }
        return this.delegate;
    }

    String getConfigFactoryClassName() {
        return this.configFactoryClassName;
    }

    void setConfigFactoryClassName(String configFactoryClassName) {
        this.configFactoryClassName = configFactoryClassName;
    }
}

