/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.registry;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationException;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.ITestcaseMetaData;
import org.eclipse.jst.validation.test.internal.registry.MessageMetaData;
import org.eclipse.jst.validation.test.internal.registry.TestcaseUtility;
import org.eclipse.jst.validation.test.internal.util.BVTRunner;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.VThreadManager;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.ValidatorSubsetOperation;

public class ValidatorTestcase
implements ITestcaseMetaData {
    private String _pluginId = null;
    private ValidatorMetaData _vmd = null;
    private MessageMetaData[] _messages = null;
    private String _projectName = null;
    private String[] _resourceNames = null;
    private String _inputFileName = null;
    private String _name = null;
    private boolean _visible = true;

    public ValidatorTestcase(String pluginName, String project, ValidatorMetaData vmd, String inputFileName, boolean visible) {
        this._pluginId = pluginName;
        this._projectName = project;
        this._vmd = vmd;
        this._inputFileName = inputFileName;
        this._visible = visible;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public String getDeclaringPluginId() {
        return this._pluginId;
    }

    public String getProjectName() {
        return this._projectName;
    }

    public IProject getProject() {
        return TestcaseUtility.findProject(this);
    }

    public String getInputFileName() {
        return this._inputFileName;
    }

    public int getNumMessages() {
        return this.getMessages(0).size();
    }

    public List getMessages(int buildType) {
        switch (buildType) {
            case 9: 
            case 10: {
                if (this.getValidatorMetaData().isIncremental()) break;
                return Collections.EMPTY_LIST;
            }
            case 6: {
                if (this.getValidatorMetaData().isFullBuild()) break;
                return Collections.EMPTY_LIST;
            }
        }
        ArrayList<MessageMetaData> copy = new ArrayList<MessageMetaData>();
        int i = 0;
        while (i < this._messages.length) {
            copy.add(this._messages[i]);
            ++i;
        }
        return copy;
    }

    public IResource[] getResources(IProject project) {
        HashSet<IResource> temp = new HashSet<IResource>();
        String[] resourceNames = this.getResourceNames();
        int i = 0;
        while (i < resourceNames.length) {
            String resourceName = resourceNames[i];
            IResource resource = project.findMember(resourceName);
            if (resource != null) {
                temp.add(resource);
            }
            ++i;
        }
        IResource[] result = new IResource[temp.size()];
        temp.toArray(result);
        return result;
    }

    public String[] getResourceNames() {
        if (this._resourceNames == null) {
            this._resourceNames = new String[this._messages.length];
            int i = 0;
            while (i < this._messages.length) {
                this._resourceNames[i] = this._messages[i].getResource();
                ++i;
            }
        }
        return this._resourceNames;
    }

    public void setResourceNames(String[] resourceNames) {
        this._resourceNames = resourceNames;
    }

    public void setMessages(MessageMetaData[] messages) {
        this._messages = messages == null ? new MessageMetaData[]{} : messages;
    }

    public ValidatorMetaData getValidatorMetaData() {
        return this._vmd;
    }

    public String getValidatorClass() {
        return this.getValidatorMetaData().getValidatorUniqueName();
    }

    public String getName() {
        if (this._name == null) {
            this._name = String.valueOf(this._vmd.getValidatorDisplayName()) + "::" + this.getProjectName();
        }
        return this._name;
    }

    public void run(IBuffer buffer, IProject project) {
        String status = ">>>>>RUN VALIDATION TEST PASS [" + project.getName() + "]>>>>>";
        buffer.getProgressMonitor().subTask(status);
        buffer.write(status);
        buffer.addExecutionStatus(this.getName(), "RUN_VALIDATION", this.validate(buffer, project, 0, "RUN_VALIDATION"));
        status = ">>>>>END RUN VALIDATION TEST PASS [" + project.getName() + "]>>>>>";
        buffer.getProgressMonitor().subTask(status);
        buffer.write(status);
        status = ">>>>>FULL BUILD TEST PASS [" + project.getName() + "]>>>>>";
        buffer.getProgressMonitor().subTask(status);
        buffer.write(status);
        buffer.addExecutionStatus(this.getName(), "FULL_BUILD", this.validate(buffer, project, 6, "FULL_BUILD"));
        status = ">>>>>END FULL BUILD TEST PASS [" + project.getName() + "]>>>>>";
        buffer.getProgressMonitor().subTask(status);
        buffer.write(status);
        status = ">>>>>INCREMENTAL BUILD TEST PASS [" + project.getName() + "]>>>>>";
        buffer.getProgressMonitor().subTask(status);
        buffer.write(status);
        buffer.addExecutionStatus(this.getName(), "INCREMENTAL_BUILD", this.validate(buffer, project, 10, "INCREMENTAL_BUILD"));
        status = ">>>>>END INCREMENTAL BUILD TEST PASS [" + project.getName() + "]>>>>>";
        buffer.getProgressMonitor().subTask(status);
        buffer.write(status);
        status = ">>>>>AUTO BUILD TEST PASS [" + project.getName() + "]>>>>>";
        buffer.getProgressMonitor().subTask(status);
        buffer.write(status);
        buffer.addExecutionStatus(this.getName(), "AUTO_BUILD", this.validate(buffer, project, 9, "AUTO_BUILD"));
        status = ">>>>>END AUTO BUILD TEST PASS [" + project.getName() + "]>>>>>";
        buffer.getProgressMonitor().subTask(status);
        buffer.write(status);
        if (this.getValidatorMetaData().isAsync()) {
            status = ">>>>>ASYNCHRONOUS VALIDATION TEST PASS [" + project.getName() + "]>>>>>";
            buffer.getProgressMonitor().subTask(status);
            buffer.write(status);
            buffer.addExecutionStatus(this.getName(), "ASYNC", this.asyncValidate(buffer, project, "ASYNC"));
            status = ">>>>>END ASYNCHRONOUS VALIDATION TEST PASS [" + project.getName() + "]>>>>>";
            buffer.getProgressMonitor().subTask(status);
            buffer.write(status);
        } else {
            buffer.addExecutionStatus(this.getName(), "ASYNC", true);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validate(IBuffer buffer, IProject project, int validationTypeEnum, String taskName) {
        long start = System.currentTimeMillis();
        boolean passed = true;
        try {
            try {
                passed = BVTRunner.singleton().test(buffer, project, this, validationTypeEnum);
            }
            catch (BVTValidationException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)exc);
                    if (exc.getTargetException() != null) {
                        logger.write(Level.SEVERE, exc.getTargetException());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            long end = System.currentTimeMillis();
            buffer.addElapsedTime(taskName, end - start);
            buffer.write("Total time for validator " + this.getValidatorMetaData().getValidatorDisplayName() + " of project " + project.getName() + " in " + taskName + " mode was " + (end - start) + " milliseconds.");
            throw throwable;
        }
        {
            Object var10_11 = null;
        }
        long end = System.currentTimeMillis();
        buffer.addElapsedTime(taskName, end - start);
        buffer.write("Total time for validator " + this.getValidatorMetaData().getValidatorDisplayName() + " of project " + project.getName() + " in " + taskName + " mode was " + (end - start) + " milliseconds.");
        return passed;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean asyncValidate(IBuffer buffer, IProject project, String subTaskName) {
        boolean passed = true;
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            try {
                GlobalConfiguration gconf = ConfigurationManager.getManager().getGlobalConfiguration();
                try {
                    try {
                        gconf.passivate();
                        boolean pass1 = this.validateAndCompare(buffer, project, subTaskName);
                        boolean pass2 = this.validateChangeAndCompare(buffer, project, 2, subTaskName);
                        boolean pass3 = this.validateChangeAndCompare(buffer, project, 3, subTaskName);
                        passed = pass1 && pass2 && pass3;
                    }
                    catch (CoreException exc) {
                        Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            logger.write(Level.SEVERE, (Exception)((Object)exc));
                        }
                    }
                    catch (BVTValidationException exc) {
                        Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            logger.write(Level.SEVERE, (Exception)exc);
                            if (exc.getTargetException() != null) {
                                logger.write(Level.SEVERE, exc.getTargetException());
                            }
                        }
                    }
                    catch (Throwable exc) {
                        Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            logger.write(Level.SEVERE, exc);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var13_20 = null;
                    gconf.passivate();
                    throw throwable;
                }
                {
                    Object var13_21 = null;
                    gconf.passivate();
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)exc);
                    if (exc.getTargetException() != null) {
                        logger.write(Level.SEVERE, exc.getTargetException());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            end = System.currentTimeMillis();
            buffer.addElapsedTime("ASYNC", end - start);
            buffer.write("Total time for validator " + this.getValidatorMetaData().getValidatorDisplayName() + " of project " + project.getName() + " in asynchronous mode was " + (end - start) + " milliseconds.");
            throw throwable;
        }
        {
            Object var15_24 = null;
        }
        end = System.currentTimeMillis();
        buffer.addElapsedTime("ASYNC", end - start);
        buffer.write("Total time for validator " + this.getValidatorMetaData().getValidatorDisplayName() + " of project " + project.getName() + " in asynchronous mode was " + (end - start) + " milliseconds.");
        return passed;
    }

    private boolean validateAndCompare(IBuffer buffer, IProject project, String subTaskName) throws CoreException, BVTValidationException {
        ValidatorSubsetOperation noForkOp = new ValidatorSubsetOperation(project, true, false);
        noForkOp.setValidators(this.getValidatorMetaData().getValidatorNames());
        noForkOp.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOp = new ValidatorSubsetOperation(project, true, true);
        forkOp.setValidators(this.getValidatorMetaData().getValidatorNames());
        forkOp.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation noForkOp2 = new ValidatorSubsetOperation(project, true, false);
        noForkOp2.setValidators(this.getValidatorMetaData().getValidatorNames());
        noForkOp2.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOp2 = new ValidatorSubsetOperation(project, true, true);
        forkOp2.setValidators(this.getValidatorMetaData().getValidatorNames());
        forkOp2.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOp3 = new ValidatorSubsetOperation(project, true, true);
        forkOp3.setValidators(this.getValidatorMetaData().getValidatorNames());
        forkOp3.run(buffer.getProgressMonitor());
        buffer.getProgressMonitor().subTask("Waiting for all forked threads to finish...");
        while (!VThreadManager.getManager().isDone() && !buffer.getProgressMonitor().isCanceled()) {
        }
        buffer.getProgressMonitor().subTask("All threads are complete. Beginning the comparison.");
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        IMarker[] markers = TaskListUtility.getValidationTasks((IResource)project, (String[])this.getValidatorMetaData().getValidatorNames());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        return BVTRunner.singleton().verify(buffer, this.getName(), subTaskName, project, this.getMessages(0), markers);
    }

    private boolean validateChangeAndCompare(IBuffer buffer, IProject project, int ifileDeltaType, String subTaskName) throws BVTValidationException, CoreException {
        boolean passed = true;
        ValidatorMetaData[] vmds = new ValidatorMetaData[]{this.getValidatorMetaData()};
        ValidatorSubsetOperation noForkOpOrig = new ValidatorSubsetOperation(project, true, false);
        noForkOpOrig.setValidators(this.getValidatorMetaData().getValidatorNames());
        noForkOpOrig.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation noForkOpChanged = new ValidatorSubsetOperation(project, vmds, this.getResources(project), ifileDeltaType, false, false);
        noForkOpChanged.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOpOrig = new ValidatorSubsetOperation(project, true, true);
        forkOpOrig.setValidators(this.getValidatorMetaData().getValidatorNames());
        forkOpOrig.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOpChanged = new ValidatorSubsetOperation(project, vmds, this.getResources(project), ifileDeltaType, false, true);
        forkOpChanged.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation noForkOp2Orig = new ValidatorSubsetOperation(project, true, false);
        noForkOp2Orig.setValidators(this.getValidatorMetaData().getValidatorNames());
        noForkOp2Orig.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation noForkOp2Changed = new ValidatorSubsetOperation(project, vmds, this.getResources(project), ifileDeltaType, false, false);
        noForkOp2Changed.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOp2Orig = new ValidatorSubsetOperation(project, true, true);
        forkOp2Orig.setValidators(this.getValidatorMetaData().getValidatorNames());
        forkOp2Orig.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOp2Changed = new ValidatorSubsetOperation(project, vmds, this.getResources(project), ifileDeltaType, false, true);
        forkOp2Changed.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOp3Orig = new ValidatorSubsetOperation(project, true, true);
        forkOp3Orig.setValidators(this.getValidatorMetaData().getValidatorNames());
        forkOp3Orig.run(buffer.getProgressMonitor());
        if (buffer.getProgressMonitor().isCanceled()) {
            return false;
        }
        ValidatorSubsetOperation forkOp3Changed = new ValidatorSubsetOperation(project, vmds, this.getResources(project), ifileDeltaType, false, true);
        forkOp3Changed.run(buffer.getProgressMonitor());
        buffer.getProgressMonitor().subTask("Waiting for all forked threads to finish...");
        while (!VThreadManager.getManager().isDone() && !buffer.getProgressMonitor().isCanceled()) {
        }
        if (buffer.getProgressMonitor().isCanceled()) {
            buffer.getProgressMonitor().subTask("Comparison cancelled. Performing cleanup.");
            return false;
        }
        buffer.getProgressMonitor().subTask("All threads are complete. Beginning the comparison.");
        IMarker[] markers = TaskListUtility.getValidationTasks((IResource)project, (String[])this.getValidatorMetaData().getValidatorNames());
        passed = BVTRunner.singleton().verify(buffer, this.getName(), subTaskName, project, this.getMessages(0), markers);
        ResourcesPlugin.getWorkspace().deleteMarkers(markers);
        return passed;
    }
}

