/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.wst.wsdl.tests.util.WSDLConverter;

public class ConvertWSDL20ActionDelegate
implements IActionDelegate {
    private ISelection selection = null;

    public void run(IAction action) {
        IFile ifile = null;
        if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
            Object element = structuredSelection.getFirstElement();
            if (element instanceof IFile) {
                ifile = (IFile)element;
                IPath path = ifile.getLocation();
                IPath path2 = path.removeLastSegments(1);
                String output = String.valueOf(path2.toString()) + "/" + this.getNewName(ifile);
                try {
                    Definition def = DefinitionLoader.load((String)("file:/" + path.toString()));
                    WSDLConverter converter = new WSDLConverter(def);
                    converter.generate20(output);
                    IContainer folder = ifile.getParent();
                    folder.refreshLocal(1, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                return;
            }
        }
    }

    private String getNewName(IFile ifile) {
        String currentName = ifile.getName();
        String name = currentName.substring(0, currentName.indexOf("."));
        String extension = currentName.substring(currentName.indexOf("."));
        String newName = String.valueOf(name) + "V20" + extension;
        return newName;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

