/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.appclient.operations;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleProjectCreationOperationTest;

public class AppClientProjectCreationOperationTest
extends ModuleProjectCreationOperationTest {
    public AppClientProjectCreationOperationTest() {
        super("AppClientProjectCreationOperationTests");
    }

    public AppClientProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(AppClientProjectCreationOperationTest.class);
        return suite;
    }

    public void testAC12_Defaults() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("randomApp", null, JavaEEFacetConstants.APP_CLIENT_12, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC13_Defaults() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("coolApp", null, JavaEEFacetConstants.APP_CLIENT_13, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC14_Defaults() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("awesomeApp", null, JavaEEFacetConstants.APP_CLIENT_14, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_Defaults() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("amazingApp", null, JavaEEFacetConstants.APP_CLIENT_5, true, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC12_NoDefaultClass() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("randomApp", null, JavaEEFacetConstants.APP_CLIENT_12, false, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC13_NoDefaultClass() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("coolApp", null, JavaEEFacetConstants.APP_CLIENT_13, false, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC14_NoDefaultClass() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("awesomeApp", null, JavaEEFacetConstants.APP_CLIENT_14, false, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_NoDefaultClass() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("amazingApp", null, JavaEEFacetConstants.APP_CLIENT_5, false, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC12_AddToEAR() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("fooAppToEar", "someEar", JavaEEFacetConstants.APP_CLIENT_12, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC13_AddToEAR() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("fooAppToEar", "coolEar", JavaEEFacetConstants.APP_CLIENT_13, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC14_AddToEAR() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("fooAppToEar", "sweetEar", JavaEEFacetConstants.APP_CLIENT_14, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_AddToEAR() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("fooAppToEar", "netoEar", JavaEEFacetConstants.APP_CLIENT_5, true, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC12_InterestingName() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("kd3(2k_djfD3", null, JavaEEFacetConstants.APP_CLIENT_12, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC13_InterestingName() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("a_dD3dj8)f7", null, JavaEEFacetConstants.APP_CLIENT_13, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC14_InterestingName() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("_Jid7dh)3a", null, JavaEEFacetConstants.APP_CLIENT_14, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_InterestingName() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("a_1B2c()3D4", null, JavaEEFacetConstants.APP_CLIENT_5, true, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC12_AddToEAR_InterestingName() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("kd(32k_djfD)3", "hFdf(8G_Fij))3", JavaEEFacetConstants.APP_CLIENT_12, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC13_AddToEAR_InterestingName() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("adD__3dj8)df7", "(53_hdj(f8HD", JavaEEFacetConstants.APP_CLIENT_13, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC14_AddToEAR_InterestingName() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("J_id7((dh3a_", "d_3Dk)j(f8", JavaEEFacetConstants.APP_CLIENT_14, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_AddToEAR_InterestingName() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("a1B_2c)3D4", "4D_3c2)B1a", JavaEEFacetConstants.APP_CLIENT_5, true, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_WithDD() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("insaneApp", null, JavaEEFacetConstants.APP_CLIENT_5, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_NoDefaultClass_WithDD() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("insaneApp", null, JavaEEFacetConstants.APP_CLIENT_5, false, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_AddToEAR_WithDD() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("appToEARwithDD", "bigEAR", JavaEEFacetConstants.APP_CLIENT_5, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testAC50_AddToEAR_InterestingName_WithDD() throws Exception {
        IDataModel dm = AppClientProjectCreationOperationTest.getAppClientCreationDataModel("D875)_DFj", "7D_3cF2)BaQ", JavaEEFacetConstants.APP_CLIENT_5, true, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public static IDataModel getAppClientCreationDataModel(String projName, String earName, IProjectFacetVersion version, boolean createDefaultMainClass, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AppClientFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        if (earName != null) {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        } else {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.appclient");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        facetModel.setProperty("IAppClientComponentCreationDataModelProperties.CREATE_DEFAULT_MAIN_CLASS", (Object)createDefaultMainClass);
        if (version == JavaEEFacetConstants.APP_CLIENT_5) {
            facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
            IDataModel javaFacetModel = facetMap.getFacetDataModel("jst.java");
            javaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaEEFacetConstants.JAVA_5);
        }
        return dm;
    }
}

