/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ejb.operations;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleProjectCreationOperationTest;

public class EJBProjectCreationOperationTest
extends ModuleProjectCreationOperationTest {
    public EJBProjectCreationOperationTest() {
        super("EJBProjectCreationOperationTest");
    }

    public EJBProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(EJBProjectCreationOperationTest.class);
        return suite;
    }

    public void testEJB11_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("insaneEJB", null, null, null, JavaEEFacetConstants.EJB_11, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB20_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("fooEJB", null, null, null, JavaEEFacetConstants.EJB_2, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB21_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("barEJB", null, null, null, JavaEEFacetConstants.EJB_21, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("penEJB", null, null, null, JavaEEFacetConstants.EJB_3, false);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB11_AddToEAR_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("testEJB", null, null, "testEAR", JavaEEFacetConstants.EJB_11, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB20_AddToEAR_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("coolEJB", null, null, "booEAR", JavaEEFacetConstants.EJB_2, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB21_AddToEAR_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("crazyEJB", null, null, "starEAR", JavaEEFacetConstants.EJB_21, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("netoEJB", null, null, "myEAR", JavaEEFacetConstants.EJB_3, false);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB11_AddToEAR_NoClient() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("testEJB", null, null, "testEAR", JavaEEFacetConstants.EJB_11, false, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB20_AddToEAR_NoClient() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("coolEJB", null, null, "booEAR", JavaEEFacetConstants.EJB_2, false, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB21_AddToEAR_NoClient() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("crazyEJB", null, null, "starEAR", JavaEEFacetConstants.EJB_21, false, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_NoClient() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("netoEJB", null, null, "myEAR", JavaEEFacetConstants.EJB_3, false, false);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB11_AddToEAR_ChangedEJBClientName() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("fooBarEJB", "testEJBClient", null, "theirEAR", JavaEEFacetConstants.EJB_11, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB20_AddToEAR_ChangedEJBClientName() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("saneEJB", "coolEJBClient", null, "yourEAR", JavaEEFacetConstants.EJB_2, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB21_AddToEAR_ChangedEJBClientName() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("clipEJB", "crazyEJBClient", null, "ourEAR", JavaEEFacetConstants.EJB_21, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_ChangedEJBClientName() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("phoneEJB", "netoEJBClient", null, "waterEAR", JavaEEFacetConstants.EJB_3, false);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB11_AddToEAR_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("cupEJB", null, "src", "openEAR", JavaEEFacetConstants.EJB_11, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB20_AddToEAR_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("mouseEJB", null, "files", "closedEAR", JavaEEFacetConstants.EJB_2, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB21_AddToEAR_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("pcEJB", null, "stuff", "batEAR", JavaEEFacetConstants.EJB_21, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("keyEJB", null, "foo", "keyEAR", JavaEEFacetConstants.EJB_3, false);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB11A_ddToEAR_ChangedEJBClientName_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("cupEJB", "superClient", "src", "openEAR", JavaEEFacetConstants.EJB_11, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB20_AddToEAR_ChangedEJBClientName_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("mouseEJB", "dudeClient", "files", "closedEAR", JavaEEFacetConstants.EJB_2, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB21_AddToEAR_ChangedEJB_ClientNameChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("pcEJB", "fireClient", "stuff", "batEAR", JavaEEFacetConstants.EJB_21, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEARChangedEJB_ClientName_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("keyEJB", "wireClient", "foo", "keyEAR", JavaEEFacetConstants.EJB_3, false);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_Defaults_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("tigerEJB", null, null, null, JavaEEFacetConstants.EJB_3, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_Defaults_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("pandaEJB", null, null, "roundEAR", JavaEEFacetConstants.EJB_3, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_NoClient_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("netoEJB", null, null, "myEAR", JavaEEFacetConstants.EJB_3, false, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_ChangedEJBClientName_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("snakeEJB", "client", null, "groundEAR", JavaEEFacetConstants.EJB_3, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_ChangedClientSourceFolder_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("lionEJB", null, "barSrc", "pinEAR", JavaEEFacetConstants.EJB_3, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public void testEJB30_AddToEAR_ChangedEJBClientName_ChangedClientSourceFolder_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("monkeyEJB", "fooFooClient", "fooSrc", "outsideEAR", JavaEEFacetConstants.EJB_3, true);
        EJBProjectCreationOperationTest.runAndVerify((IDataModel)dm);
    }

    public static IDataModel getEJBDataModel(String projName, String clientName, String clientSourceFolder, String earName, IProjectFacetVersion version, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (earName != null) {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
            if (clientName != null) {
                facetModel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", true);
                facetModel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ", clientName);
                if (clientSourceFolder != null) {
                    facetModel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_SOURCE_FOLDER ", clientSourceFolder);
                }
            }
        } else {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        if (version == JavaEEFacetConstants.EJB_3) {
            facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
            IDataModel javaFacetModel = facetMap.getFacetDataModel("jst.java");
            javaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaEEFacetConstants.JAVA_5);
        }
        return dm;
    }

    public static IDataModel getEJBDataModel(String projName, String clientName, String clientSourceFolder, String earName, IProjectFacetVersion version, boolean createCleint, boolean createDD) {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel(projName, clientName, clientSourceFolder, earName, version, createDD);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        facetModel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", createCleint);
        return dm;
    }
}

