/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.tests.classpath;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibrariesPreferencePage;
import org.eclipse.jst.jsf.ui.tests.util.JSFUITestHelper;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JSFLibrariesPreferencePageTestCases
extends TestCase {
    public JSFLibrariesPreferencePageTestCases(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        JSFCoreUtilHelper.createJSFLibraryRegistry();
    }

    public void testPreferencePage() {
        JSFLibrary lib2;
        PreferenceDialog dialog = JSFUITestHelper.getPreferenceDialog("org.eclipse.jst.jsf.ui.jsfLibraryPage");
        Assert.assertNotNull((Object)dialog);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Assert.assertTrue((boolean)(dialog.getSelectedPage() instanceof JSFLibrariesPreferencePage));
        JSFLibrariesPreferencePage page = (JSFLibrariesPreferencePage)dialog.getSelectedPage();
        Viewer tv = page.getLibraryViewer();
        PrefPageControls controls = new PrefPageControls((Composite)page.getControl());
        tv.setSelection((ISelection)StructuredSelection.EMPTY);
        Assert.assertFalse((boolean)controls.getEditLibraryButton().getEnabled());
        Assert.assertTrue((boolean)controls.getNewLibraryButton().getEnabled());
        Assert.assertFalse((boolean)controls.getRemoveLibraryButton().getEnabled());
        Assert.assertFalse((boolean)controls.getMakeDefaultLibraryButton().getVisible());
        for (JSFLibrary lib2 : JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getAllJSFLibraries()) {
            tv.setSelection((ISelection)new StructuredSelection((Object)lib2));
            Assert.assertTrue((boolean)controls.getNewLibraryButton().getEnabled());
            if (lib2.isImplementation()) {
                Assert.assertTrue((boolean)controls.getMakeDefaultLibraryButton().getVisible());
            } else {
                Assert.assertFalse((boolean)controls.getMakeDefaultLibraryButton().getVisible());
            }
            if (lib2 instanceof PluginProvidedJSFLibrary) {
                Assert.assertTrue((boolean)controls.getEditLibraryButton().getEnabled());
                Assert.assertTrue((boolean)controls.getRemoveLibraryButton().getEnabled());
                continue;
            }
            Assert.assertTrue((boolean)controls.getEditLibraryButton().getEnabled());
            Assert.assertTrue((boolean)controls.getRemoveLibraryButton().getEnabled());
        }
        lib2 = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getDefaultImplementation();
        tv.setSelection((ISelection)new StructuredSelection((Object)lib2));
        ((TreeViewer)tv).expandAll();
        tv.setSelection((ISelection)new StructuredSelection(lib2.getArchiveFiles().get(0)));
        Assert.assertTrue((boolean)controls.getEditLibraryButton().getEnabled());
        Assert.assertTrue((boolean)controls.getNewLibraryButton().getEnabled());
        Assert.assertFalse((boolean)controls.getRemoveLibraryButton().getEnabled());
        Assert.assertFalse((boolean)controls.getMakeDefaultLibraryButton().getVisible());
        dialog.close();
    }

    private class PrefPageControls {
        Button btnAdd;
        Button btnRemove;
        Button btnMakeDefault;
        Button btnEdit;
        TreeViewer tv;

        PrefPageControls(Composite parent) {
            this.findButtons(parent.getChildren());
        }

        public TreeViewer getViewer() {
            return this.tv;
        }

        public Button getNewLibraryButton() {
            return this.btnAdd;
        }

        public Button getRemoveLibraryButton() {
            return this.btnRemove;
        }

        public Button getMakeDefaultLibraryButton() {
            return this.btnMakeDefault;
        }

        public Button getEditLibraryButton() {
            return this.btnEdit;
        }

        private void findButtons(Control[] controls) {
            int i = 0;
            while (i < controls.length) {
                Control c = controls[i];
                if (c instanceof Button) {
                    Button b = (Button)c;
                    if (b.getText().equals(Messages.JSFLibrariesPreferencePage_New)) {
                        this.btnAdd = b;
                    } else if (b.getText().equals(Messages.JSFLibrariesPreferencePage_Remove)) {
                        this.btnRemove = b;
                    } else if (b.getText().equals(Messages.JSFLibrariesPreferencePage_Edit)) {
                        this.btnEdit = b;
                    } else if (b.getText().equals(Messages.JSFLibrariesPreferencePage_MakeDefault)) {
                        this.btnMakeDefault = b;
                    }
                } else if (c instanceof Composite) {
                    this.findButtons(((Composite)c).getChildren());
                }
                ++i;
            }
        }
    }
}

