/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.tests;

import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsf.contentassist.tests.ContentAssistTestsPlugin;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistParser;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistStrategy;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class Test_bug_149743
extends TestCase {
    private WebProjectTestEnvironment _testEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._testEnv = new WebProjectTestEnvironment("Test_bug_149743_" + this.getName());
        this._testEnv.createProject(false);
        Test_bug_149743.assertNotNull((Object)this._testEnv);
        Test_bug_149743.assertNotNull((Object)this._testEnv.getTestProject());
        Test_bug_149743.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
        this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/faces-config_bug149743.xml.data", "/WEB-INF/faces-config.xml");
        this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/bug_149743.jsp.data", "/bug_149743.jsp");
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        TestFileResource resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
    }

    public void testSanity() throws Exception {
        ContextWrapper wrapper = null;
        try {
            wrapper = this.getDocumentContext();
            IStructuredDocumentContext context = wrapper.getContext();
            IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
            Node node = resolver.getNode();
            JSFTestUtil.getIndexedRegion((IStructuredDocument)((IStructuredDocument)context.getStructuredDocument()), (int)context.getDocumentPosition());
            Test_bug_149743.assertTrue((boolean)(node instanceof Attr));
            Test_bug_149743.assertEquals((String)"value", (String)((Attr)node).getNodeName());
            Test_bug_149743.assertEquals((String)"#{myBean.property}", (String)((Attr)node).getNodeValue());
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    public void testCompletionProposalsForId() throws Exception {
        ContextWrapper wrapper = null;
        try {
            wrapper = this.getDocumentContext();
            ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(wrapper.getContext());
            String elText = resolver.getRegionText().trim();
            Test_bug_149743.assertNotNull((Object)elText);
            ContentAssistStrategy strategy = ContentAssistParser.getPrefix((int)(wrapper.getContext().getDocumentPosition() - resolver.getStartOffset() + 1), (String)elText);
            List proposals = strategy.getProposals(wrapper.getContext());
            Test_bug_149743.assertEquals((int)2, (int)proposals.size());
            HashSet<String> names = new HashSet<String>();
            int i = 0;
            while (i < proposals.size()) {
                names.add(((ICompletionProposal)proposals.get(i)).getDisplayString());
                ++i;
            }
            Test_bug_149743.assertTrue((boolean)names.contains("class"));
            Test_bug_149743.assertTrue((boolean)names.contains("property"));
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    private ContextWrapper getDocumentContext() throws Exception {
        IProject project = this._testEnv.getTestProject();
        IFile jspFile = project.getFile((IPath)new Path("/WebContent/bug_149743.jsp"));
        Test_bug_149743.assertTrue((boolean)jspFile.exists());
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        model = modelManager.getModelForRead(jspFile);
        Test_bug_149743.assertTrue((boolean)(model instanceof DOMModelForJSP));
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), 529);
        return new ContextWrapper(context, model);
    }

    private static class ContextWrapper {
        private final IStructuredDocumentContext _context;
        private final IStructuredModel _model;

        ContextWrapper(IStructuredDocumentContext context, IStructuredModel model) {
            this._context = context;
            this._model = model;
        }

        IStructuredDocumentContext getContext() {
            return this._context;
        }

        IStructuredModel getModel() {
            return this._model;
        }

        void dispose() {
            this._model.releaseFromRead();
        }
    }
}

