/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import java.io.FileInputStream;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.WSDL4JDefinitionVisitor;
import org.xml.sax.InputSource;

public class WSDL4JAPITest
extends WSDL4JDefinitionVisitor {
    private static String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();
    private WSDLFactory factory = WSDLPlugin.INSTANCE.createWSDL4JFactory();
    private Definition newDefinition;
    private Message currentMessage;
    private Service currentService;
    private PortType currentPortType;
    private Operation currentOperation;
    private Binding currentBinding;
    private BindingOperation currentBindingOperation;

    public WSDL4JAPITest(String name) {
        super(name);
    }

    public WSDL4JAPITest(Definition definition) {
        super(definition);
    }

    private void println(String s) {
        System.out.println(s);
    }

    protected void visitDefinition(Definition def) {
        this.newDefinition = this.factory.newDefinition();
        this.newDefinition.setDocumentationElement(def.getDocumentationElement());
        this.newDefinition.setQName(def.getQName());
        this.newDefinition.setTargetNamespace(def.getTargetNamespace());
        this.newDefinition.setDocumentBaseURI(def.getDocumentBaseURI());
        Iterator iterator = def.getNamespaces().keySet().iterator();
        String prefix = null;
        String namespace = null;
        while (iterator.hasNext()) {
            prefix = (String)iterator.next();
            namespace = def.getNamespace(prefix);
            this.newDefinition.addNamespace(prefix, namespace);
        }
        super.visitDefinition(def);
    }

    protected void visitImport(Import wsdlImport) {
        Import myImport = this.newDefinition.createImport();
        this.newDefinition.addImport(myImport);
        myImport.setNamespaceURI(wsdlImport.getNamespaceURI());
        myImport.setLocationURI(wsdlImport.getLocationURI());
        myImport.setDocumentationElement(wsdlImport.getDocumentationElement());
        myImport.setDefinition(this.newDefinition);
    }

    protected void visitTypes(Types types) {
        Types myTypes = this.newDefinition.createTypes();
        myTypes.setDocumentationElement(types.getDocumentationElement());
        this.newDefinition.setTypes(myTypes);
    }

    protected void visitPart(Part part) {
        Part myPart = this.newDefinition.createPart();
        myPart.setDocumentationElement(part.getDocumentationElement());
        myPart.setName(part.getName());
        myPart.setElementName(part.getElementName());
        myPart.setTypeName(part.getTypeName());
        Iterator iterator = part.getExtensionAttributes().keySet().iterator();
        QName key = null;
        QName value = null;
        while (iterator.hasNext()) {
            key = (QName)iterator.next();
            value = part.getExtensionAttribute(key);
            myPart.setExtensionAttribute(key, value);
        }
        this.currentMessage.addPart(myPart);
    }

    protected void visitMessage(Message message) {
        this.currentMessage = this.newDefinition.createMessage();
        super.visitMessage(message);
    }

    protected void visitPortType(PortType portType) {
        this.currentPortType = this.newDefinition.createPortType();
        this.currentPortType.setDocumentationElement(portType.getDocumentationElement());
        this.currentPortType.setQName(portType.getQName());
        this.currentPortType.setUndefined(portType.isUndefined());
        this.newDefinition.addPortType(this.currentPortType);
        super.visitPortType(portType);
    }

    protected void visitOperation(Operation operation) {
        this.currentOperation = this.newDefinition.createOperation();
        this.currentOperation.setDocumentationElement(operation.getDocumentationElement());
        this.currentOperation.setName(operation.getName());
        this.currentOperation.setStyle(operation.getStyle());
        this.currentOperation.setUndefined(operation.isUndefined());
        this.currentOperation.setParameterOrdering(operation.getParameterOrdering());
        this.currentPortType.addOperation(this.currentOperation);
        super.visitOperation(operation);
    }

    protected void visitInput(Input input) {
        Input myInput = this.newDefinition.createInput();
        myInput.setDocumentationElement(input.getDocumentationElement());
        myInput.setName(input.getName());
        myInput.setMessage(input.getMessage());
        this.currentOperation.setInput(myInput);
    }

    protected void visitOutput(Output output) {
        Output myOutput = this.newDefinition.createOutput();
        myOutput.setDocumentationElement(output.getDocumentationElement());
        myOutput.setName(output.getName());
        myOutput.setMessage(output.getMessage());
        this.currentOperation.setOutput(myOutput);
    }

    protected void visitFault(Fault fault) {
        Fault myFault = this.newDefinition.createFault();
        myFault.setDocumentationElement(fault.getDocumentationElement());
        myFault.setName(fault.getName());
        myFault.setMessage(fault.getMessage());
        this.currentOperation.addFault(myFault);
    }

    protected void visitBinding(Binding binding) {
        this.currentBinding = this.newDefinition.createBinding();
        this.newDefinition.addBinding(this.currentBinding);
        this.currentBinding.setDocumentationElement(binding.getDocumentationElement());
        this.currentBinding.setQName(binding.getQName());
        this.currentBinding.setPortType(binding.getPortType());
        this.currentBinding.setUndefined(binding.isUndefined());
        super.visitBinding(binding);
    }

    protected void visitBindingOperation(BindingOperation bindingOperation) {
        this.currentBindingOperation = this.newDefinition.createBindingOperation();
        this.currentBindingOperation.setDocumentationElement(bindingOperation.getDocumentationElement());
        this.currentBindingOperation.setOperation(bindingOperation.getOperation());
        this.currentBindingOperation.setName(bindingOperation.getName());
        this.currentBinding.addBindingOperation(this.currentBindingOperation);
        super.visitBindingOperation(bindingOperation);
    }

    protected void visitBindingInput(BindingInput input) {
        BindingInput myInput = this.newDefinition.createBindingInput();
        myInput.setDocumentationElement(input.getDocumentationElement());
        myInput.setName(input.getName());
        this.currentBindingOperation.setBindingInput(myInput);
        super.visitBindingInput(input);
    }

    protected void visitBindingOutput(BindingOutput output) {
        BindingOutput myOutput = this.newDefinition.createBindingOutput();
        myOutput.setDocumentationElement(output.getDocumentationElement());
        myOutput.setName(output.getName());
        this.currentBindingOperation.setBindingOutput(myOutput);
        super.visitBindingOutput(output);
    }

    protected void visitBindingFault(BindingFault fault) {
        BindingFault myFault = this.newDefinition.createBindingFault();
        myFault.setDocumentationElement(fault.getDocumentationElement());
        myFault.setName(fault.getName());
        this.currentBindingOperation.addBindingFault(myFault);
        super.visitBindingFault(fault);
    }

    protected void visitService(Service service) {
        this.currentService = this.newDefinition.createService();
        this.currentService.setDocumentationElement(service.getDocumentationElement());
        this.currentService.setQName(service.getQName());
        this.newDefinition.addService(this.currentService);
        super.visitService(service);
    }

    protected void visitPort(Port port) {
        Port myPort = this.newDefinition.createPort();
        myPort.setDocumentationElement(port.getDocumentationElement());
        myPort.setName(port.getName());
        myPort.setBinding(port.getBinding());
        this.currentService.addPort(myPort);
        super.visitPort(port);
    }

    protected void visitExtensibilityElement(ExtensibilityElement extensibilityElement) {
        if (extensibilityElement instanceof SOAPBody) {
            this.visitSOAPBody((SOAPBody)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPBinding) {
            this.visitSOAPBinding((SOAPBinding)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPAddress) {
            this.visitSOAPAddress((SOAPAddress)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPOperation) {
            this.visitSOAPOperation((SOAPOperation)extensibilityElement);
        }
    }

    private void visitSOAPOperation(SOAPOperation soapOperation) {
        this.println("Visiting SOAPOperation...");
        this.println("soapAction: " + soapOperation.getSoapActionURI());
        this.println("Leaving SOAPOperation...");
    }

    private void visitSOAPBody(SOAPBody soapBody) {
        this.println("Visiting SOAPBody...");
        this.println("use: " + soapBody.getUse());
        this.println("Leaving SOAPBody...");
    }

    private void visitSOAPBinding(SOAPBinding soapBinding) {
        this.println("Visiting SOAPBinding...");
        this.println("style: " + soapBinding.getStyle());
        this.println("transport: " + soapBinding.getTransportURI());
        this.println("Leaving SOAPBinding...");
    }

    private void visitSOAPAddress(SOAPAddress soapAddress) {
        this.println("Visiting SOAPAddress...");
        this.println("location: " + soapAddress.getLocationURI());
        this.println("Leaving SOAPAddress...");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new WSDL4JAPITest("ModelSemanticTest"){

            protected void runTest() {
                this.testModelSemantic();
            }
        });
        return suite;
    }

    public void testModelSemantic() {
        try {
            Definition def = this.loadDefinitionForWSDL4J("./samples/LoadStoreCompare/LoadAndPrintTest.wsdl");
            WSDL4JAPITest test = new WSDL4JAPITest(def);
            test.visit();
            this.serialize(test.newDefinition, "./samples/ClonedLoadAndPrintTest.wsdl");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    private void serialize(Definition definition, String clonedFile) throws Exception {
    }

    private Definition loadDefinitionForWSDL4J(String wsdlFile) throws Exception {
        WSDLReader reader = this.factory.newWSDLReader();
        String s = String.valueOf(PLUGIN_ABSOLUTE_PATH) + wsdlFile;
        Definition definition = reader.readWSDL(s, new InputSource(new FileInputStream(s)));
        return definition;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)WSDL4JAPITest.suite());
    }
}

