/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.tests.AssertWarn;
import org.eclipse.wst.common.tests.JUnitLogListener;

public class BaseTestCase
extends TestCase {
    private static boolean fFailOnLoggedStatus = true;

    public BaseTestCase() {
    }

    public BaseTestCase(String name) {
        super(name);
    }

    public void setUpTest() throws Exception {
        this.setUp();
    }

    public final void tearDownTest() throws Exception {
        this.tearDown();
    }

    public final void runCoreTest() throws Throwable {
        this.runTest();
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected static void failOnLoggedStatus(boolean failOnLoggedStatus) {
        fFailOnLoggedStatus = failOnLoggedStatus;
    }

    /*
     * Unable to fully structure code
     */
    public void run(TestResult result) {
        try {
            AssertWarn.clearWarnings();
            super.run(result);
        }
        finally {
            stackTrace = new ArrayList<StackTraceElement>();
            errorsEnum = result.errors();
            errorOrFailure = null;
            hadError = false;
            i = 0;
            ** while (errorsEnum.hasMoreElements() && !hadError)
        }
lbl-1000:
        // 1 sources

        {
            o = errorsEnum.nextElement();
            errorOrFailure = (TestFailure)o;
            if (errorOrFailure.failedTest() == this) {
                hadError = true;
                thrown = errorOrFailure.thrownException();
                errorTrace = Arrays.asList(thrown.getStackTrace());
                stackTrace.addAll(errorTrace);
            }
            ++i;
            continue;
        }
lbl22:
        // 1 sources

        hadFailure = false;
        if (!hadError) {
            failuresEnum = result.failures();
            i = 0;
            while (failuresEnum.hasMoreElements() && !hadFailure) {
                o = failuresEnum.nextElement();
                errorOrFailure = (TestFailure)o;
                if (errorOrFailure.failedTest() == this) {
                    hadFailure = true;
                    thrown = errorOrFailure.thrownException();
                    failureTrace = Arrays.asList(thrown.getStackTrace());
                    stackTrace.addAll(failureTrace);
                }
                ++i;
            }
        }
        v0 = hadWarnings = (warnings = AssertWarn.getWarnings()).size() != 0;
        if (hadWarnings) {
            warningNum = 1;
            warningTrace = null;
            for (AssertionFailedError e : warnings) {
                stackTrace.add(new StackTraceElement("---------->", "", "WARNING MESSAGE: " + e.getMessage() + ")  (WARNING NUMBER", warningNum++));
                warningTrace = Arrays.asList(e.getStackTrace());
                stackTrace.addAll(warningTrace);
            }
        }
        v1 = hadLoggedStatuses = (loggedStatuses = JUnitLogListener.INSTANCE.getLoggedStatuses()).size() != 0;
        if (hadLoggedStatuses && BaseTestCase.fFailOnLoggedStatus) {
            loggedMessageNum = 1;
            loggedMessageTrace = null;
            loggedStatusesKeys = loggedStatuses.keySet();
            for (IStatus status : loggedStatusesKeys) {
                stackTrace.add(new StackTraceElement("---------->", "", "LOGGED " + this.statusTypeToString(status.getSeverity()) + " STATUS: " + loggedStatuses.get(status) + ": " + status.getMessage() + ")  (LOGGED STATUS NUMBER", loggedMessageNum++));
                if (status.getException() == null) continue;
                loggedMessageTrace = Arrays.asList(status.getException().getStackTrace());
                stackTrace.addAll(loggedMessageTrace);
            }
        }
        message = "";
        warningsMessage = "Test had " + warnings.size() + " warnings occur";
        loggedStatusesMessage = "Test logged " + loggedStatuses.size() + " statuses";
        if (hadError || hadFailure) {
            message = errorOrFailure.exceptionMessage();
            if (hadWarnings) {
                message = String.valueOf(message) + "  (" + (String)warningsMessage + ")";
            }
            if (hadLoggedStatuses && BaseTestCase.fFailOnLoggedStatus) {
                message = String.valueOf(message) + "  (" + loggedStatusesMessage + ")";
            }
        } else if (hadWarnings) {
            message = warningsMessage;
            if (hadLoggedStatuses && BaseTestCase.fFailOnLoggedStatus) {
                message = String.valueOf(message) + "  (" + loggedStatusesMessage + ")";
            }
        } else if (hadLoggedStatuses && BaseTestCase.fFailOnLoggedStatus) {
            message = loggedStatusesMessage;
        }
        if (hadError || hadFailure || hadWarnings || hadLoggedStatuses && BaseTestCase.fFailOnLoggedStatus) {
            error = new AssertionFailedError((String)message);
            stackTraceArray = stackTrace.toArray(new StackTraceElement[stackTrace.size()]);
            error.setStackTrace(stackTraceArray);
            if (hadError) {
                result.addError((Test)this, (Throwable)error);
            } else {
                result.addFailure((Test)this, error);
            }
        }
    }

    private String statusTypeToString(int statusType) {
        String sStatusType = "";
        switch (statusType) {
            case 4: {
                sStatusType = "ERROR";
                break;
            }
            case 8: {
                sStatusType = "CANCEL";
                break;
            }
            case 2: {
                sStatusType = "WARNING";
            }
        }
        return sStatusType;
    }
}

