/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.archive.test.AbstractArchiveTest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveInit;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfiguration;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseLibrary;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseModule;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigFactory;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigPackage;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;

public class LooseArchiveTests
extends AbstractArchiveTest {
    protected String cwd;
    protected URI looseConfigLoc;
    protected URI looseAppLoc;
    protected String looseModuleWorkspace;
    protected String looseEARUri;
    protected static final String EJB_JAR_URI = "LooseEAREjb.jar";
    protected static final String WAR_URI = "LooseEARWeb.war";
    protected static final String UTIL_JAR_URI = "util.jar";
    protected static final String WEBLIB_URI = "WEB-INF/lib/library.jar";
    protected static final String WEBLIB_FULL_URI = "WEB-INF/lib/library.jar";
    protected static final String OUTPUT_EAR_FILE_URI = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/LooseArchiveTests/LooseApp.ear";
    protected static char sep = File.separatorChar;

    public LooseArchiveTests(String name) {
        super(name);
    }

    public void testLooseConfigCreation() throws Exception {
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(this.looseConfigLoc).createResource(this.looseConfigLoc);
        resource.getContents().add((Object)this.createLooseConfig());
        resource.save(new HashMap());
    }

    public void testLooseAppCreation() throws Exception {
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(this.looseAppLoc).createResource(this.looseAppLoc);
        resource.getContents().add((Object)this.createLooseApplication());
        resource.save(new HashMap());
    }

    public void testLooseConfigOpenAndSave() throws Exception {
        System.setProperty("was.loose.config", this.looseConfigLoc.toString());
        EARFile ear = LooseArchiveTests.getArchiveFactory().openEARFile(this.looseEARUri);
        this.verify(ear);
        ear.saveAs(OUTPUT_EAR_FILE_URI);
        ear.close();
        ear = LooseArchiveTests.getArchiveFactory().openEARFile(OUTPUT_EAR_FILE_URI);
        this.verify(ear);
        ear.close();
    }

    public void testLooseConfigUnimodeOpenAndSave() throws Exception {
        System.setProperty("was.loose.config", "");
        LooseConfigRegister.singleton().addLooseMapping(this.looseEARUri, this.looseAppLoc.toString());
        EARFile ear = LooseArchiveTests.getArchiveFactory().openEARFile(this.looseEARUri);
        this.verify(ear);
        ear.saveAs(OUTPUT_EAR_FILE_URI);
        ear.close();
        ear = LooseArchiveTests.getArchiveFactory().openEARFile(OUTPUT_EAR_FILE_URI);
        this.verify(ear);
        ear.close();
    }

    public void testLooseConfigOpenAndReOpen() throws Exception {
        System.setProperty("was.loose.config", this.looseConfigLoc.toString());
        EARFile ear = LooseArchiveTests.getArchiveFactory().openEARFile(this.looseEARUri);
        ear.close();
        ear.reopen();
        List jars = ear.getArchiveFiles();
        int i = 0;
        while (i < jars.size()) {
            Archive archive = (Archive)jars.get(i);
            archive.close();
            archive.reopen((Archive)ear);
            ++i;
        }
        ear.close();
    }

    protected void verify(EARFile ear) throws Exception {
        this.verifyModules(ear);
        this.verifyModuleRefs(ear);
        this.verifyUtilAndLib(ear);
    }

    protected void verifyModuleRefs(EARFile ear) throws Exception {
        EList moduleRefs = ear.getModuleRefs();
        int size = moduleRefs.size();
        LooseArchiveTests.assertEquals((String)"Wrong number of modules", (int)2, (int)size);
        int i = 0;
        while (i < size) {
            ModuleRef ref = (ModuleRef)moduleRefs.get(i);
            LooseArchiveTests.assertNotNull((String)("ModuleRef should have a module file:" + ref.getModule().getUri()), (Object)ref.getModuleFile());
            LooseArchiveTests.assertNotNull((String)"Deployment descriptor should not be null", (Object)ref.getDeploymentDescriptor());
            ++i;
        }
    }

    protected void verifyUtilAndLib(EARFile ear) throws Exception {
        this.verifyJAR((Archive)ear, UTIL_JAR_URI);
        this.verifyJAR((Archive)ear.getFile(WAR_URI), "WEB-INF/lib/library.jar");
    }

    protected void verifyJAR(Archive parent, String uri) throws Exception {
        LooseArchiveTests.assertTrue((String)("Should contain JAR: " + uri), (boolean)parent.containsFile(uri));
        Archive jar = (Archive)parent.getFile(uri);
        LooseArchiveTests.assertTrue((String)("JAR should contain a class file: " + uri), (boolean)this.containsClassFile(jar));
    }

    protected boolean containsClassFile(Archive jar) {
        int i = 0;
        EList files = jar.getFiles();
        if (i < files.size()) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File aFile = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)files.get(i);
            if (aFile.getURI().endsWith(".class")) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public void verifyModules(EARFile ear) throws Exception {
        Module m;
        EList modules = ear.getDeploymentDescriptor().getModules();
        int size = modules.size();
        int i = 0;
        while (i < modules.size()) {
            m = (Module)modules.get(i);
            LooseArchiveTests.assertTrue((String)("EAR file should contain module file: " + m.getUri()), (boolean)ear.containsFile(m.getUri()));
            ++i;
        }
        LooseArchiveTests.assertEquals((String)"Wrong number of modules", (int)2, (int)size);
        i = 0;
        while (i < modules.size()) {
            m = (Module)modules.get(i);
            LooseArchiveTests.assertTrue((String)("EAR file should contain module file: " + m.getUri()), (boolean)ear.containsFile(m.getUri()));
            ++i;
        }
    }

    protected LooseConfiguration createLooseConfig() {
        LooseConfiguration config = this.looseConfigFactory().createLooseConfiguration();
        config.getApplications().add((Object)this.createLooseApplication());
        return config;
    }

    protected LooseApplication createLooseApplication() {
        LooseApplication app = this.looseConfigFactory().createLooseApplication();
        app.setUri(this.looseEARUri);
        app.setResourcesPath(this.looseEARUri);
        app.setBinariesPath(this.looseEARUri);
        EList looseArchives = app.getLooseArchives();
        looseArchives.add(this.createLooseEJB());
        looseArchives.add(this.createLooseWEB());
        looseArchives.add(this.createLooseUtil());
        return app;
    }

    protected LooseModule createLooseEJB() {
        LooseModule mod = this.looseConfigFactory().createLooseModule();
        mod.setUri(EJB_JAR_URI);
        String absPath = String.valueOf(this.looseModuleWorkspace) + sep + "LooseEAREjb" + sep + "bin";
        mod.setBinariesPath(absPath);
        mod.setResourcesPath(absPath);
        return mod;
    }

    protected LooseModule createLooseWEB() {
        LooseWARFile mod = this.looseConfigFactory().createLooseWARFile();
        mod.setUri(WAR_URI);
        String absPath = String.valueOf(this.looseModuleWorkspace) + sep + "LooseEARWeb" + sep + "webApplication";
        mod.setBinariesPath(absPath);
        mod.setResourcesPath(absPath);
        mod.getLooseLibs().add((Object)this.createLooseWebLib());
        return mod;
    }

    protected LooseLibrary createLooseUtil() {
        LooseLibrary lib = this.looseConfigFactory().createLooseLibrary();
        lib.setUri(UTIL_JAR_URI);
        String absPath = String.valueOf(this.looseModuleWorkspace) + sep + "LooseJavaUtil" + sep + "bin";
        lib.setBinariesPath(absPath);
        lib.setResourcesPath(absPath);
        return lib;
    }

    protected LooseLibrary createLooseWebLib() {
        LooseLibrary lib = this.looseConfigFactory().createLooseLibrary();
        lib.setUri("WEB-INF/lib/library.jar");
        String absPath = String.valueOf(this.looseModuleWorkspace) + sep + "LooseJavaWebLib" + sep + "bin";
        lib.setBinariesPath(absPath);
        lib.setResourcesPath(absPath);
        return lib;
    }

    protected LooseconfigFactory looseConfigFactory() {
        return LooseconfigPackage.eINSTANCE.getLooseconfigFactory();
    }

    protected void printClasspaths(EARFile ear) {
        List archives = ear.getArchiveFiles();
        int i = 0;
        while (i < archives.size()) {
            Archive archive = (Archive)archives.get(i);
            System.out.println("Local runtime classpath for: " + archive.getURI());
            RuntimeClasspathEntry[] entries = archive.getLocalRuntimeClassPath();
            int j = 0;
            while (j < entries.length) {
                System.out.println(entries[j]);
                ++j;
            }
            System.out.println("Full runtime classpath for: " + archive.getURI());
            entries = archive.getFullRuntimeClassPath();
            j = 0;
            while (j < entries.length) {
                System.out.println(entries[j]);
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.LooseArchiveTests", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("LooseArchiveTests");
        suite.addTest((Test)new LooseArchiveTests("testLooseConfigCreation"));
        suite.addTest((Test)new LooseArchiveTests("testLooseAppCreation"));
        suite.addTest((Test)new LooseArchiveTests("testLooseConfigOpenAndSave"));
        suite.addTest((Test)new LooseArchiveTests("testLooseConfigOpenAndReOpen"));
        suite.addTest((Test)new LooseArchiveTests("testLooseConfigUnimodeOpenAndSave"));
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ArchiveInit.init();
        LooseConfigRegister.singleton().flush();
        this.cwd = AutomatedBVT.baseDirectory;
        this.looseModuleWorkspace = String.valueOf(this.cwd) + "loose_module_workspace";
        this.looseConfigLoc = URI.createFileURI((String)(String.valueOf(this.looseModuleWorkspace) + sep + ".metadata" + sep + ".plugins" + sep + "com.ibm.etools.j2ee" + sep + "looseConfig.xmi"));
        this.looseAppLoc = URI.createFileURI((String)(String.valueOf(this.looseModuleWorkspace) + sep + ".metadata" + sep + ".plugins" + sep + "com.ibm.etools.j2ee" + sep + "looseApp.xmi"));
        this.looseEARUri = ArchiveUtil.getOSUri((String)(String.valueOf(this.looseModuleWorkspace) + sep + "LooseEAR"));
    }
}

