/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSFCoreUtilHelper {
    private static final String JSFRUNTIMEJARSDIR = "jsfRuntimeJarsDirectoryV";
    private static String JSF11Path = "";
    private static String JSF12Path = "";

    public static JSFLibrary constructJSFLib(String id, String name, String[] archivefiles, boolean bImpl) {
        String pathTestFiles = String.valueOf(TestsPlugin.getInstallLocation().getPath()) + "testfiles/";
        return JSFCoreUtilHelper.constructJSFLib(id, name, pathTestFiles, archivefiles, bImpl);
    }

    public static JSFLibrary constructJSFLib(String id, String name, String basePathToArchiveFiles, String[] archivefiles, boolean bImpl) {
        ArchiveFile archiveFile = null;
        JSFLibrary jsfLib = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        jsfLib.setName(name);
        jsfLib.setImplementation(bImpl);
        int i = 0;
        while (i < archivefiles.length) {
            String testData = String.valueOf(basePathToArchiveFiles) + archivefiles[i];
            archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
            archiveFile.setRelativeToWorkspace(false);
            archiveFile.setSourceLocation(testData);
            archiveFile.setJSFLibrary(jsfLib);
            ++i;
        }
        return jsfLib;
    }

    public static IProject createWebProject(String aProjectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!project.exists()) {
            IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProjectName);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
    }

    public static void createJSFLibraryRegistry() {
        if (JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getAllJSFLibraries().size() < 2) {
            JSFLibrary lib = JSFCoreUtilHelper.constructJSFLib("AN-IMPL-LIB", "/testfiles/JSFLib/", true, false);
            JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().addJSFLibrary(lib);
            lib = JSFCoreUtilHelper.constructJSFLib("A-NON-IMPL-LIB", "/testfiles/JSFLib/", false, false);
            JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().addJSFLibrary(lib);
            lib = JSFCoreUtilHelper.constructJSFLib("AN-IMPL-LIB-PP", "/testfiles/JSFLib/", true, true);
            JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().addJSFLibrary(lib);
        }
    }

    public static JSFLibraryRegistry getNewJSFLibraryRegistry() {
        return JSFLibraryRegistryFactory.eINSTANCE.createJSFLibraryRegistry();
    }

    public static JSFLibraryRegistry getJSFLibraryRegistryFromJSFLibraryHelper() {
        return JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry();
    }

    public static JSFLibrary constructJSFLib(String name, String relPathToArchives, boolean isImpl, boolean isFakedPlugginLib) {
        Object jsfLib = null;
        jsfLib = isFakedPlugginLib ? JSFLibraryRegistryFactory.eINSTANCE.createPluginProvidedJSFLibrary() : JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        jsfLib.setName(name);
        jsfLib.setImplementation(isImpl);
        File pathTestFiles = new File(String.valueOf(TestsPlugin.getInstallLocation().getPath()) + File.separator + relPathToArchives);
        FilenameFilter jars = new FilenameFilter(){

            public boolean accept(File dir, String name_) {
                String lastChars;
                return name_.length() >= 5 && ((lastChars = name_.toLowerCase().substring(name_.length() - 4)).equals(".jar") || lastChars.equals(".zip"));
            }
        };
        String[] fileNames = pathTestFiles.list(jars);
        int i = 0;
        while (i < fileNames.length) {
            String fileName = pathTestFiles.getAbsolutePath().concat(File.separator).concat(fileNames[i]);
            ArchiveFile archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
            archiveFile.setRelativeToWorkspace(false);
            archiveFile.setSourceLocation(fileName);
            archiveFile.setJSFLibrary((JSFLibrary)jsfLib);
            ++i;
        }
        return jsfLib;
    }

    public static String getJSFRuntimeJarsDirectory(JSFVersion jsfVersion) {
        String propertyName = JSFRUNTIMEJARSDIR + jsfVersion.toString();
        String res = System.getProperty(propertyName);
        if (res == null) {
            res = System.getenv(propertyName);
        }
        if (jsfVersion == JSFVersion.V1_1 && JSF11Path != res) {
            System.out.printf("Using jsf runtime path %s for propertyName %s\n", res, propertyName);
            JSF11Path = res;
        } else if (jsfVersion == JSFVersion.V1_2 && JSF12Path != res) {
            System.out.printf("Using jsf runtime path %s for propertyName %s\n", res, propertyName);
            JSF12Path = res;
        }
        return res;
    }

    public static boolean isJSFRuntimeJarsDirectoryPropertySet(JSFVersion jsfVersion) {
        String dirName = JSFCoreUtilHelper.getJSFRuntimeJarsDirectory(jsfVersion);
        if (dirName != null && dirName.trim().length() != 0) {
            File dir = new File(dirName);
            if (dir.exists() && dir.isDirectory()) {
                return true;
            }
            System.err.printf("Dir: %s either doesn't exists or is not a directory\n", dirName);
        } else {
            System.err.println("dirName is null");
        }
        return false;
    }

    public static boolean createRegistryAndAddReferences(JSFFacetedTestEnvironment jsfFacedEnv, String[] archiveFiles, JSFVersion jsfVersion) throws CoreException {
        JSFLibraryRegistry jsfLibRegistry = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry();
        if (archiveFiles != null) {
            String libIDandName = "_internalJSFRuntimeLibraryV" + jsfVersion + "_";
            JSFLibrary jsfImpl = JSFCoreUtilHelper.constructJSFLib(libIDandName, libIDandName, "", archiveFiles, true);
            jsfLibRegistry.addJSFLibrary(jsfImpl);
            jsfFacedEnv.addJSFLibraryReference(jsfImpl, true);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getJSFRuntimeJarNames(JSFVersion version) throws IOException {
        String[] jarNames = null;
        String dirName = JSFCoreUtilHelper.getJSFRuntimeJarsDirectory(version);
        System.out.printf("Using dirName: %s\n", dirName);
        if (dirName == null) throw new FileNotFoundException("dirName is null");
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) throw new FileNotFoundException(String.valueOf(dirName) + " is either does not exist or is not a directory");
        File[] jars = dir.listFiles();
        if (jars == null || jars.length <= 0) return jarNames;
        jarNames = new String[jars.length];
        int i = 0;
        while (i < jars.length) {
            jarNames[i] = jars[i].getAbsolutePath();
            ++i;
        }
        return jarNames;
    }

    public static boolean isJSFRuntimeJarsDirectoryValid(JSFVersion jsfVersion) {
        try {
            return JSFCoreUtilHelper.getJSFRuntimeJarNames(jsfVersion) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean addJSFRuntimeJarsToClasspath(JSFVersion jsfVersion, JSFFacetedTestEnvironment jsfFacetedTestEnv) throws Exception {
        String[] jarNames = JSFCoreUtilHelper.getJSFRuntimeJarNames(jsfVersion);
        return JSFCoreUtilHelper.createRegistryAndAddReferences(jsfFacetedTestEnv, jarNames, jsfVersion);
    }

    public static String getTestRequiresJSFRuntimeMessage(Class<?> testClass, JSFVersion jsfVersion) {
        StringBuffer sb = new StringBuffer();
        sb.append("Unable to run test suite \"");
        sb.append(testClass.getName());
        sb.append("\"; JSF runtime (v");
        sb.append(jsfVersion.toString());
        sb.append(") is required but not present.\nSystem property or environment variable \"jsfRuntimeJarsDirectoryV");
        sb.append(jsfVersion.toString());
        sb.append("\" must be set to point to a directory containing JSF runtime (v");
        sb.append(jsfVersion.toString());
        sb.append(") JARs.");
        return sb.toString();
    }
}

