/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.tests.module;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.osgi.framework.Bundle;

public class ModuleHelper {
    private static final int BUFFER = 10240;
    private static byte[] buf = new byte[10240];
    static /* synthetic */ Class class$0;

    public static void createModule(String name) throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)name);
        dataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", false);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel webModel = map.getFacetDataModel("jst.web");
        webModel.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", "2.2");
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        dataModel.dispose();
    }

    public static void createWebContent(String name, int i) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IFile file = project.getFile(new Path("WebContent").append("test" + i + ".html"));
        String content = "Hello!";
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)in, true, null);
    }

    public static void createXMLContent(String name, int i) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IFile file = project.getFile(new Path("WebContent").append("test" + i + ".xml"));
        String content = "<book name='test'><isbn>299827698</isbn></book>";
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)in, true, null);
    }

    public static void createJavaContent(String name, int i) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IFile file = project.getFile(new Path("src").append("Test" + i + ".java"));
        String content = "public class Test" + i + " { }";
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)in, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createJarContent(String name, int num, IPath path) throws Exception {
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        int i = 0;
        while (i < num) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
            URL url = bundle.getEntry("/");
            url = FileLocator.resolve((URL)url);
            String s = url.toString();
            url = new URL(s.substring(4, s.length() - 2));
            InputStream in = url.openStream();
            IPath path2 = path.append("external_jar" + i + ".jar");
            ModuleHelper.copyFile(in, path2.toOSString());
            ++i;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IFile file = project.getFile(new Path(".settings").append("org.eclipse.wst.common.component"));
        InputStream in = null;
        XMLMemento memento = null;
        try {
            in = file.getContents();
            memento = (XMLMemento)XMLMemento.loadMemento((InputStream)in);
            IMemento child = memento.getChild("project-modules");
            child = memento.getChild("wb-module");
            int i2 = 0;
            while (i2 < num) {
                IMemento newChild = child.createChild("dependent-module");
                newChild.putString("deploy-path", "/WEB-INF/lib");
                IPath path2 = path.append("external_jar" + i2 + ".jar");
                newChild.putString("handle", "module:/classpath/lib/" + path2.toOSString());
                XMLMemento child2 = (XMLMemento)newChild.createChild("dependency-type");
                child2.putTextData("uses");
                ++i2;
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        in.close();
        in = memento.getInputStream();
        file.setContents(in, true, true, null);
    }

    public static void deleteModule(String name) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        project.delete(true, null);
    }

    public static void buildIncremental() throws CoreException {
        ResourcesPlugin.getWorkspace().build(10, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void buildFull() throws CoreException {
        ResourcesPlugin.getWorkspace().build(6, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void buildClean() throws CoreException {
        ResourcesPlugin.getWorkspace().build(15, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static IModule getModule(String name) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IModule module = ServerUtil.getModule((IProject)project);
        if (module == null) {
            throw new Exception("No module in Web project");
        }
        return module;
    }

    public static int countFilesInModule(IModule module) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, null);
        IModuleResource[] mr = pm.members();
        int count = 0;
        int size = mr.length;
        int i = 0;
        while (i < size) {
            count = mr[i] instanceof IModuleFolder ? (count += ModuleHelper.countFilesInFolder((IModuleFolder)mr[i])) : ++count;
            ++i;
        }
        return count;
    }

    protected static int countFilesInFolder(IModuleFolder mf) {
        int count = 0;
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return 0;
        }
        int size = mr.length;
        int i = 0;
        while (i < size) {
            count = mr[i] instanceof IModuleFolder ? (count += ModuleHelper.countFilesInFolder((IModuleFolder)mr[i])) : ++count;
            ++i;
        }
        return count;
    }

    public static int countFilesInDelta(IModuleResourceDelta delta) throws CoreException {
        int count = 0;
        if (delta.getModuleResource() instanceof IModuleFile) {
            ++count;
        }
        IModuleResourceDelta[] children = delta.getAffectedChildren();
        int size = children.length;
        int i = 0;
        while (i < size) {
            count += ModuleHelper.countFilesInDelta(children[i]);
            ++i;
        }
        return count;
    }

    public static IModuleFile getModuleFile(IModule module, IPath path) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, null);
        IModuleResource[] mr = pm.members();
        int size = mr.length;
        int i = 0;
        while (i < size) {
            if (mr[i].getModuleRelativePath().equals((Object)path)) {
                if (mr[i] instanceof IModuleFile) {
                    return (IModuleFile)mr[i];
                }
                return null;
            }
            if (mr[i].getModuleRelativePath().isPrefixOf(path)) {
                return ModuleHelper.getModuleFile((IModuleFolder)mr[i], path);
            }
            ++i;
        }
        return null;
    }

    protected static IModuleFile getModuleFile(IModuleFolder mf, IPath path) {
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return null;
        }
        int size = mr.length;
        int i = 0;
        while (i < size) {
            if (mr[i].getModuleRelativePath().equals((Object)path)) {
                if (mr[i] instanceof IModuleFile) {
                    return (IModuleFile)mr[i];
                }
                return null;
            }
            if (mr[i].getModuleRelativePath().isPrefixOf(path)) {
                return ModuleHelper.getModuleFile((IModuleFolder)mr[i], path);
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyFile(InputStream in, String to) throws IOException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(to);
                int avail = in.read(buf);
                while (avail > 0) {
                    ((OutputStream)out).write(buf, 0, avail);
                    avail = in.read(buf);
                }
            }
            catch (Exception exception) {
                throw new IOException("Error copying file");
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (out == null) return;
        ((OutputStream)out).close();
    }
}

