/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.fwk;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationException;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.IOperationRunnable;
import org.eclipse.jst.validation.test.fwk.TestOpConstrInputOperation;
import org.eclipse.jst.validation.test.fwk.validator.JDTUtility;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.jst.validation.test.internal.util.BVTRunner;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.AllValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.EnabledIncrementalValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.OneValidatorOperation;
import org.eclipse.wst.validation.internal.operations.ValidationOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorSubsetOperation;

public class TestOpConstrOperation
implements IOperationRunnable {
    private IProject _project = null;
    private IBuffer _buffer = null;
    private String _testCaseName = null;

    public TestOpConstrOperation() {
    }

    public TestOpConstrOperation(IBuffer buffer, IProject project, String testCaseName) {
        this.setBuffer(buffer);
        this.setProject(project);
        this.setName(testCaseName);
    }

    public IBuffer getBuffer() {
        return this._buffer;
    }

    public void setBuffer(IBuffer b) {
        this._buffer = b;
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject p) {
        this._project = p;
    }

    public String getName() {
        return this._testCaseName;
    }

    public void setName(String name) {
        this._testCaseName = name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) {
        try {
            boolean autoBuildEnabled;
            GlobalConfiguration origGconf;
            GlobalConfiguration gconf;
            block17: {
                block14: {
                    gconf = ConfigurationManager.getManager().getGlobalConfiguration();
                    origGconf = new GlobalConfiguration(gconf);
                    autoBuildEnabled = ResourcesPlugin.getWorkspace().isAutoBuilding();
                    try {
                        gconf.setCanProjectsOverride(false);
                        gconf.passivate();
                        JDTUtility.setAutoBuild(false);
                        monitor.subTask("Loading operations; please wait...");
                        TestWrapper[] testCaseAndOperations = this.getOperations(monitor, (ValidationConfiguration)gconf);
                        if (testCaseAndOperations == null) {
                            String message = "Test case failed; cannot test null operations.";
                            this.getBuffer().write(message);
                            monitor.subTask(message);
                            Object var16_10 = null;
                            gconf = origGconf;
                            break block14;
                        }
                        int numPassed = 0;
                        int i = 0;
                        while (i < testCaseAndOperations.length) {
                            String message;
                            Object var13_20;
                            boolean tpassed;
                            TestWrapper testWrapper;
                            block16: {
                                block15: {
                                    testWrapper = testCaseAndOperations[i];
                                    ValidationOperation operation = testWrapper.getOperation();
                                    tpassed = false;
                                    try {
                                        try {
                                            if (monitor.isCanceled()) {
                                                var13_20 = null;
                                                message = "Test #" + (i + 1) + " of " + testCaseAndOperations.length + (tpassed ? " passed." : " failed.");
                                                break block15;
                                            }
                                            monitor.subTask("Testing " + (i + 1) + " of " + testCaseAndOperations.length + " constructors.");
                                            this.preTest(testWrapper);
                                            if (this.test(monitor, testWrapper)) {
                                                ++numPassed;
                                                tpassed = true;
                                            }
                                            break block16;
                                        }
                                        catch (Throwable exc) {
                                            this.getBuffer().write("Throwable caught while testing #" + (i + 1) + " " + operation.getClass().getName());
                                            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                                            if (!logger.isLoggingLevel(Level.SEVERE)) break block16;
                                            logger.write(Level.SEVERE, exc);
                                        }
                                        break block16;
                                    }
                                    catch (Throwable throwable) {
                                        var13_20 = null;
                                        message = "Test #" + (i + 1) + " of " + testCaseAndOperations.length + (tpassed ? " passed." : " failed.");
                                        monitor.subTask(message);
                                        this.getBuffer().write(message);
                                        this.getBuffer().addExecutionStatus(this.getName(), testWrapper.getName(), tpassed);
                                        throw throwable;
                                    }
                                }
                                monitor.subTask(message);
                                this.getBuffer().write(message);
                                this.getBuffer().addExecutionStatus(this.getName(), testWrapper.getName(), tpassed);
                                break;
                            }
                            var13_20 = null;
                            message = "Test #" + (i + 1) + " of " + testCaseAndOperations.length + (tpassed ? " passed." : " failed.");
                            monitor.subTask(message);
                            this.getBuffer().write(message);
                            this.getBuffer().addExecutionStatus(this.getName(), testWrapper.getName(), tpassed);
                            ++i;
                        }
                        String status = String.valueOf(numPassed) + " of " + testCaseAndOperations.length + " tests passed.";
                        monitor.subTask(status);
                        this.getBuffer().write(status);
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var16_11 = null;
                        gconf = origGconf;
                        gconf.passivate();
                        JDTUtility.setAutoBuild(autoBuildEnabled);
                        throw throwable;
                    }
                }
                gconf.passivate();
                JDTUtility.setAutoBuild(autoBuildEnabled);
                return;
            }
            Object var16_12 = null;
            gconf = origGconf;
            gconf.passivate();
            JDTUtility.setAutoBuild(autoBuildEnabled);
            return;
        }
        catch (InvocationTargetException exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (!logger.isLoggingLevel(Level.SEVERE)) return;
            logger.write(Level.SEVERE, (Exception)exc);
            if (exc.getTargetException() == null) return;
            logger.write(Level.SEVERE, exc.getTargetException());
        }
    }

    private void preTest(TestWrapper wrapper) throws CoreException {
        TaskListUtility.removeAllTasks((IResource)this.getProject(), (String[])wrapper.getValidatorNames());
    }

    private boolean test(IProgressMonitor monitor, TestWrapper testWrapper) throws InvocationTargetException {
        boolean result;
        block2: {
            result = true;
            try {
                result = BVTRunner.singleton().test(this.getBuffer(), this.getName(), testWrapper.getName(), testWrapper.getExpectedMessages(), testWrapper.getOperation(), testWrapper.getValidatorNames()) && result;
            }
            catch (BVTValidationException exc) {
                result = false;
                if (exc.getTargetException() == null) break block2;
                throw new InvocationTargetException(exc.getTargetException(), exc.getMessage());
            }
        }
        return result;
    }

    private TestWrapper[] getOperations(IProgressMonitor monitor, ValidationConfiguration vconf) throws InvocationTargetException {
        ValidatorTestcase[] allTmds = JDTUtility.getVFTests(monitor, this.getProject());
        if (allTmds == null || allTmds.length == 0) {
            return null;
        }
        String fileExtension = ".java";
        String defaultExtension = null;
        IFile javaFile = this.getProject().getFile("foo.java");
        ArrayList tmdEmpty = new ArrayList();
        ArrayList tmdInc = new ArrayList();
        ArrayList tmdEnabled = new ArrayList();
        ArrayList tmdJava = new ArrayList();
        ArrayList tmdFull = new ArrayList();
        HashSet<ValidatorMetaData> enabledValidators = new HashSet<ValidatorMetaData>();
        HashSet<ValidatorMetaData> enabledIncrementalValidators = new HashSet<ValidatorMetaData>();
        HashSet<ValidatorMetaData> javaValidators = new HashSet<ValidatorMetaData>();
        HashSet<ValidatorMetaData> fullValidators = new HashSet<ValidatorMetaData>();
        ValidatorMetaData[] enabledVmd = new ValidatorMetaData[allTmds.length];
        int i = 0;
        while (i < allTmds.length) {
            ValidatorTestcase vt = allTmds[i];
            ValidatorMetaData vmd = vt.getValidatorMetaData();
            enabledValidators.add(vmd);
            enabledVmd[i] = vmd;
            if (vmd.isIncremental()) {
                enabledIncrementalValidators.add(vmd);
            } else {
                fullValidators.add(vmd);
                tmdFull.addAll(vt.getMessages(0));
            }
            if (vmd.isApplicableTo((IResource)javaFile) && vmd.isIncremental()) {
                javaValidators.add(vmd);
                tmdJava.addAll(vt.getMessages(10));
            }
            tmdEnabled.addAll(vt.getMessages(0));
            tmdInc.addAll(vt.getMessages(10));
            ++i;
        }
        String[] allValidatorNames = InternalValidatorManager.getManager().getValidatorNames(enabledValidators);
        String[] incValidatorNames = InternalValidatorManager.getManager().getValidatorNames(enabledIncrementalValidators);
        String[] javaValidatorNames = InternalValidatorManager.getManager().getValidatorNames(javaValidators);
        String[] fullValidatorNames = InternalValidatorManager.getManager().getValidatorNames(fullValidators);
        vconf.setEnabledValidators(enabledVmd);
        vconf.passivate();
        AllValidatorsOperation op1 = new AllValidatorsOperation(this.getProject());
        TestWrapper test1 = new TestWrapper((ValidationOperation)op1, tmdEnabled, "op1", allValidatorNames);
        AllValidatorsOperation op2 = new AllValidatorsOperation(this.getProject(), false);
        TestWrapper test2 = new TestWrapper((ValidationOperation)op2, tmdEnabled, "op2", allValidatorNames);
        TestOpConstrInputOperation inputOp = new TestOpConstrInputOperation(this.getBuffer(), this.getProject());
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)inputOp, monitor);
        }
        catch (Throwable exc) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, exc);
            }
            return new TestWrapper[0];
        }
        Object[] changedResources = TestOpConstrInputOperation.getChangedResources(this.getProject(), allTmds);
        Object[] emptyResources = TestOpConstrInputOperation.getEmptyResources(this.getProject());
        Object[] changedClasses = inputOp.getChangedClasses((IResource[])changedResources);
        IResourceDelta emptyDelta = inputOp.getEmptyDelta();
        IResourceDelta changedDelta = inputOp.getChangedDelta();
        EnabledIncrementalValidatorsOperation op3 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, true);
        TestWrapper test3 = new TestWrapper((ValidationOperation)op3, tmdInc, "op3", incValidatorNames);
        EnabledIncrementalValidatorsOperation op4 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, false);
        TestWrapper test4 = new TestWrapper((ValidationOperation)op4, tmdInc, "op4", incValidatorNames);
        EnabledIncrementalValidatorsOperation op5 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, false);
        TestWrapper test5 = new TestWrapper((ValidationOperation)op5, tmdEmpty, "op5", incValidatorNames);
        EnabledIncrementalValidatorsOperation op6 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, 1, false);
        TestWrapper test6 = new TestWrapper((ValidationOperation)op6, tmdInc, "op6", incValidatorNames);
        EnabledIncrementalValidatorsOperation op7 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, 1, false);
        TestWrapper test7 = new TestWrapper((ValidationOperation)op7, tmdInc, "op7", incValidatorNames);
        EnabledIncrementalValidatorsOperation op8 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, 1, false);
        TestWrapper test8 = new TestWrapper((ValidationOperation)op8, tmdEmpty, "op8", incValidatorNames);
        EnabledIncrementalValidatorsOperation op9 = new EnabledIncrementalValidatorsOperation(this.getProject(), enabledIncrementalValidators, null, 1);
        TestWrapper test9 = new TestWrapper((ValidationOperation)op9, tmdInc, "op9", incValidatorNames);
        EnabledIncrementalValidatorsOperation op10 = new EnabledIncrementalValidatorsOperation(this.getProject(), enabledIncrementalValidators, changedDelta, 1);
        TestWrapper test10 = new TestWrapper((ValidationOperation)op10, tmdInc, "op10", incValidatorNames);
        EnabledIncrementalValidatorsOperation op11 = new EnabledIncrementalValidatorsOperation(this.getProject(), enabledIncrementalValidators, emptyDelta, 1);
        TestWrapper test11 = new TestWrapper((ValidationOperation)op11, tmdEmpty, "op11", incValidatorNames);
        EnabledIncrementalValidatorsOperation op12 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, false);
        TestWrapper test12 = new TestWrapper((ValidationOperation)op12, tmdInc, "op12", incValidatorNames);
        EnabledIncrementalValidatorsOperation op13 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, false);
        TestWrapper test13 = new TestWrapper((ValidationOperation)op13, tmdInc, "op13", incValidatorNames);
        EnabledIncrementalValidatorsOperation op14 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, false);
        TestWrapper test14 = new TestWrapper((ValidationOperation)op14, tmdEmpty, "op14", incValidatorNames);
        EnabledIncrementalValidatorsOperation op15 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, 1, false);
        TestWrapper test15 = new TestWrapper((ValidationOperation)op15, tmdInc, "op15", incValidatorNames);
        EnabledIncrementalValidatorsOperation op16 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, 1, false);
        TestWrapper test16 = new TestWrapper((ValidationOperation)op16, tmdInc, "op16", incValidatorNames);
        EnabledIncrementalValidatorsOperation op17 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, 1, false);
        TestWrapper test17 = new TestWrapper((ValidationOperation)op17, tmdEmpty, "op17", incValidatorNames);
        EnabledValidatorsOperation op18 = new EnabledValidatorsOperation(this.getProject());
        TestWrapper test18 = new TestWrapper((ValidationOperation)op18, tmdEnabled, "op18", allValidatorNames);
        EnabledValidatorsOperation op19 = new EnabledValidatorsOperation(this.getProject(), false);
        TestWrapper test19 = new TestWrapper((ValidationOperation)op19, tmdEnabled, "op19", allValidatorNames);
        EnabledValidatorsOperation op20 = new EnabledValidatorsOperation(this.getProject(), 1);
        TestWrapper test20 = new TestWrapper((ValidationOperation)op20, tmdEnabled, "op20", allValidatorNames);
        EnabledValidatorsOperation op21 = new EnabledValidatorsOperation(this.getProject(), 1, true, false);
        TestWrapper test21 = new TestWrapper((ValidationOperation)op21, tmdEnabled, "op21", allValidatorNames);
        EnabledValidatorsOperation op22 = new EnabledValidatorsOperation(this.getProject(), 1, false, false);
        TestWrapper test22 = new TestWrapper((ValidationOperation)op22, tmdEnabled, "op22", allValidatorNames);
        EnabledValidatorsOperation op23 = new EnabledValidatorsOperation(this.getProject(), 1, true, false);
        TestWrapper test23 = new TestWrapper((ValidationOperation)op23, tmdEnabled, "op23", allValidatorNames);
        EnabledValidatorsOperation op24 = new EnabledValidatorsOperation(this.getProject(), 1, false, false);
        TestWrapper test24 = new TestWrapper((ValidationOperation)op24, tmdEnabled, "op24", allValidatorNames);
        EnabledIncrementalValidatorsOperation op25 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, true);
        TestWrapper test25 = new TestWrapper((ValidationOperation)op25, tmdEnabled, "op25", allValidatorNames);
        EnabledIncrementalValidatorsOperation op26 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, true);
        TestWrapper test26 = new TestWrapper((ValidationOperation)op26, tmdInc, "op26", incValidatorNames);
        EnabledIncrementalValidatorsOperation op27 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, true);
        TestWrapper test27 = new TestWrapper((ValidationOperation)op27, tmdEmpty, "op27", incValidatorNames);
        EnabledIncrementalValidatorsOperation op28 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, 1, true);
        TestWrapper test28 = new TestWrapper((ValidationOperation)op28, tmdEnabled, "op28", allValidatorNames);
        EnabledIncrementalValidatorsOperation op29 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, 1, true);
        TestWrapper test29 = new TestWrapper((ValidationOperation)op29, tmdInc, "op29", incValidatorNames);
        EnabledIncrementalValidatorsOperation op30 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, 1, true);
        TestWrapper test30 = new TestWrapper((ValidationOperation)op30, tmdEmpty, "op30", incValidatorNames);
        ValidatorMetaData vmd = allTmds[0].getValidatorMetaData();
        String validatorName = vmd.getValidatorUniqueName();
        String[] vmdNames = InternalValidatorManager.getManager().getValidatorNames(new ValidatorMetaData[]{vmd});
        List expectedMessages = allTmds[0].getMessages(0);
        OneValidatorOperation op31 = new OneValidatorOperation(this.getProject(), validatorName);
        TestWrapper test31 = new TestWrapper((ValidationOperation)op31, expectedMessages, "op31", vmdNames);
        OneValidatorOperation op32 = new OneValidatorOperation(this.getProject(), validatorName, true);
        TestWrapper test32 = new TestWrapper((ValidationOperation)op32, expectedMessages, "op32", vmdNames);
        OneValidatorOperation op33 = new OneValidatorOperation(this.getProject(), validatorName, false);
        TestWrapper test33 = new TestWrapper((ValidationOperation)op33, expectedMessages, "op33", vmdNames);
        OneValidatorOperation op34 = new OneValidatorOperation(this.getProject(), validatorName, true, false);
        TestWrapper test34 = new TestWrapper((ValidationOperation)op34, expectedMessages, "op34", vmdNames);
        OneValidatorOperation op35 = new OneValidatorOperation(this.getProject(), validatorName, false, false);
        TestWrapper test35 = new TestWrapper((ValidationOperation)op35, expectedMessages, "op35", vmdNames);
        OneValidatorOperation op36 = new OneValidatorOperation(this.getProject(), validatorName, true, 1);
        TestWrapper test36 = new TestWrapper((ValidationOperation)op36, expectedMessages, "op36", vmdNames);
        OneValidatorOperation op37 = new OneValidatorOperation(this.getProject(), validatorName, false, 1);
        TestWrapper test37 = new TestWrapper((ValidationOperation)op37, expectedMessages, "op37", vmdNames);
        OneValidatorOperation op38 = new OneValidatorOperation(this.getProject(), validatorName, true, 1, false);
        TestWrapper test38 = new TestWrapper((ValidationOperation)op38, expectedMessages, "op38", vmdNames);
        OneValidatorOperation op39 = new OneValidatorOperation(this.getProject(), validatorName, false, 1, false);
        TestWrapper test39 = new TestWrapper((ValidationOperation)op39, expectedMessages, "op39", vmdNames);
        ValidatorSubsetOperation op40 = new ValidatorSubsetOperation(this.getProject(), true, false);
        op40.setValidators(allValidatorNames);
        TestWrapper test40 = new TestWrapper((ValidationOperation)op40, tmdEnabled, "op40", allValidatorNames);
        ValidatorSubsetOperation op41 = new ValidatorSubsetOperation(this.getProject(), true, false);
        op41.setValidators(allValidatorNames);
        TestWrapper test41 = new TestWrapper((ValidationOperation)op41, tmdEnabled, "op41", allValidatorNames);
        ValidatorSubsetOperation op42 = new ValidatorSubsetOperation(this.getProject(), false, false);
        op42.setValidators(allValidatorNames);
        TestWrapper test42 = new TestWrapper((ValidationOperation)op42, tmdEnabled, "op42", allValidatorNames);
        ValidatorSubsetOperation op43 = new ValidatorSubsetOperation(this.getProject(), true, false);
        op43.setValidators(allValidatorNames);
        TestWrapper test43 = new TestWrapper((ValidationOperation)op43, tmdEnabled, "op43", allValidatorNames);
        ValidatorSubsetOperation op44 = new ValidatorSubsetOperation(this.getProject(), false, false);
        op44.setValidators(allValidatorNames);
        TestWrapper test44 = new TestWrapper((ValidationOperation)op44, tmdEnabled, "op44", allValidatorNames);
        ValidatorSubsetOperation op45 = new ValidatorSubsetOperation(this.getProject(), true, 1, false);
        op45.setValidators(allValidatorNames);
        TestWrapper test45 = new TestWrapper((ValidationOperation)op45, tmdEnabled, "op45", allValidatorNames);
        ValidatorSubsetOperation op46 = new ValidatorSubsetOperation(this.getProject(), false, 1, false);
        op46.setValidators(allValidatorNames);
        TestWrapper test46 = new TestWrapper((ValidationOperation)op46, tmdEnabled, "op46", allValidatorNames);
        ValidatorSubsetOperation op47 = new ValidatorSubsetOperation(this.getProject(), true, 1, false);
        op47.setValidators(allValidatorNames);
        TestWrapper test47 = new TestWrapper((ValidationOperation)op47, tmdEnabled, "op47", allValidatorNames);
        ValidatorSubsetOperation op48 = new ValidatorSubsetOperation(this.getProject(), false, 1, false);
        op48.setValidators(allValidatorNames);
        TestWrapper test48 = new TestWrapper((ValidationOperation)op48, tmdEnabled, "op48", allValidatorNames);
        EnabledIncrementalValidatorsOperation op49 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, false);
        op49.setValidators(allValidatorNames);
        TestWrapper test49 = new TestWrapper((ValidationOperation)op49, tmdEnabled, "op49", allValidatorNames);
        EnabledIncrementalValidatorsOperation op50 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, false);
        op50.setValidators(incValidatorNames);
        TestWrapper test50 = new TestWrapper((ValidationOperation)op50, tmdInc, "op50", incValidatorNames);
        EnabledIncrementalValidatorsOperation op51 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, false);
        op51.setValidators(incValidatorNames);
        TestWrapper test51 = new TestWrapper((ValidationOperation)op51, tmdEmpty, "op51", incValidatorNames);
        EnabledIncrementalValidatorsOperation op52 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, false);
        op52.setValidators(allValidatorNames);
        TestWrapper test52 = new TestWrapper((ValidationOperation)op52, tmdEnabled, "op52", allValidatorNames);
        EnabledIncrementalValidatorsOperation op53 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, true);
        op53.setValidators(fullValidatorNames);
        TestWrapper test53 = new TestWrapper((ValidationOperation)op53, tmdFull, "op53", fullValidatorNames);
        EnabledIncrementalValidatorsOperation op54 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, false);
        op54.setValidators(incValidatorNames);
        TestWrapper test54 = new TestWrapper((ValidationOperation)op54, tmdInc, "op54", incValidatorNames);
        EnabledIncrementalValidatorsOperation op55 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, true);
        op55.setValidators(incValidatorNames);
        TestWrapper test55 = new TestWrapper((ValidationOperation)op55, tmdEmpty, "op55", incValidatorNames);
        EnabledIncrementalValidatorsOperation op56 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, false);
        op56.setValidators(incValidatorNames);
        TestWrapper test56 = new TestWrapper((ValidationOperation)op56, tmdEmpty, "op56", incValidatorNames);
        EnabledIncrementalValidatorsOperation op57 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, true);
        op57.setValidators(incValidatorNames);
        TestWrapper test57 = new TestWrapper((ValidationOperation)op57, tmdEmpty, "op57", incValidatorNames);
        EnabledIncrementalValidatorsOperation op58 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, 1, false);
        op58.setValidators(allValidatorNames);
        TestWrapper test58 = new TestWrapper((ValidationOperation)op58, tmdEnabled, "op58", allValidatorNames);
        EnabledIncrementalValidatorsOperation op59 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, 1, false);
        op59.setValidators(allValidatorNames);
        TestWrapper test59 = new TestWrapper((ValidationOperation)op59, tmdFull, "op59", allValidatorNames);
        EnabledIncrementalValidatorsOperation op60 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, 1, false);
        op60.setValidators(incValidatorNames);
        TestWrapper test60 = new TestWrapper((ValidationOperation)op60, tmdInc, "op60", incValidatorNames);
        EnabledIncrementalValidatorsOperation op61 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, 1, false);
        op61.setValidators(incValidatorNames);
        TestWrapper test61 = new TestWrapper((ValidationOperation)op61, tmdEmpty, "op61", incValidatorNames);
        EnabledIncrementalValidatorsOperation op62 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, 1, false);
        op62.setValidators(incValidatorNames);
        TestWrapper test62 = new TestWrapper((ValidationOperation)op62, tmdEmpty, "op62", incValidatorNames);
        EnabledIncrementalValidatorsOperation op63 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, 1, true);
        op63.setValidators(incValidatorNames);
        TestWrapper test63 = new TestWrapper((ValidationOperation)op63, tmdEmpty, "op63", incValidatorNames);
        EnabledIncrementalValidatorsOperation op64 = new EnabledIncrementalValidatorsOperation(this.getProject(), null, 1, true);
        op64.setValidators(allValidatorNames);
        TestWrapper test64 = new TestWrapper((ValidationOperation)op64, tmdEnabled, "op64", allValidatorNames);
        EnabledIncrementalValidatorsOperation op65 = new EnabledIncrementalValidatorsOperation(this.getProject(), changedDelta, 1, true);
        op65.setValidators(incValidatorNames);
        TestWrapper test65 = new TestWrapper((ValidationOperation)op65, tmdInc, "op65", incValidatorNames);
        EnabledIncrementalValidatorsOperation op66 = new EnabledIncrementalValidatorsOperation(this.getProject(), emptyDelta, 1, true);
        op66.setValidators(incValidatorNames);
        TestWrapper test66 = new TestWrapper((ValidationOperation)op66, tmdEmpty, "op66", incValidatorNames);
        if (changedClasses != null) {
            ValidatorSubsetOperation op67 = new ValidatorSubsetOperation(this.getProject(), fileExtension, changedResources, false);
            op67.setValidators(javaValidatorNames);
            TestWrapper test67 = new TestWrapper((ValidationOperation)op67, tmdJava, "op67", javaValidatorNames);
            ValidatorSubsetOperation op68 = new ValidatorSubsetOperation(this.getProject(), fileExtension, changedResources, false);
            op68.setValidators(javaValidatorNames);
            TestWrapper test68 = new TestWrapper((ValidationOperation)op68, tmdJava, "op68", javaValidatorNames);
            ValidatorSubsetOperation op69 = new ValidatorSubsetOperation(this.getProject(), fileExtension, defaultExtension, changedResources, false);
            op69.setValidators(javaValidatorNames);
            TestWrapper test69 = new TestWrapper((ValidationOperation)op69, tmdJava, "op69", javaValidatorNames);
            ValidatorSubsetOperation op70 = new ValidatorSubsetOperation(this.getProject(), fileExtension, defaultExtension, changedResources, false);
            op70.setValidators(javaValidatorNames);
            TestWrapper test70 = new TestWrapper((ValidationOperation)op70, tmdJava, "op70", javaValidatorNames);
            ValidatorSubsetOperation op71 = new ValidatorSubsetOperation(this.getProject(), fileExtension, emptyResources, false);
            op71.setValidators(javaValidatorNames);
            TestWrapper test71 = new TestWrapper((ValidationOperation)op71, tmdEmpty, "op71", javaValidatorNames);
            ValidatorSubsetOperation op72 = new ValidatorSubsetOperation(this.getProject(), fileExtension, emptyResources, false);
            op72.setValidators(javaValidatorNames);
            TestWrapper test72 = new TestWrapper((ValidationOperation)op72, tmdEmpty, "op72", javaValidatorNames);
            ValidatorSubsetOperation op73 = new ValidatorSubsetOperation(this.getProject(), fileExtension, defaultExtension, emptyResources, false);
            op73.setValidators(javaValidatorNames);
            TestWrapper test73 = new TestWrapper((ValidationOperation)op73, tmdEmpty, "op73", javaValidatorNames);
            ValidatorSubsetOperation op74 = new ValidatorSubsetOperation(this.getProject(), fileExtension, defaultExtension, emptyResources, false);
            op74.setValidators(javaValidatorNames);
            TestWrapper test74 = new TestWrapper((ValidationOperation)op74, tmdEmpty, "op74", javaValidatorNames);
            ValidatorSubsetOperation op75 = new ValidatorSubsetOperation(this.getProject(), fileExtension, changedClasses, false);
            op75.setValidators(javaValidatorNames);
            TestWrapper test75 = new TestWrapper((ValidationOperation)op75, tmdJava, "op75", javaValidatorNames);
            ValidatorSubsetOperation op76 = new ValidatorSubsetOperation(this.getProject(), fileExtension, changedClasses, false);
            op76.setValidators(javaValidatorNames);
            TestWrapper test76 = new TestWrapper((ValidationOperation)op76, tmdJava, "op76", javaValidatorNames);
            ValidatorSubsetOperation op77 = new ValidatorSubsetOperation(this.getProject(), fileExtension, defaultExtension, changedClasses, false);
            op77.setValidators(javaValidatorNames);
            TestWrapper test77 = new TestWrapper((ValidationOperation)op77, tmdJava, "op77", javaValidatorNames);
            ValidatorSubsetOperation op78 = new ValidatorSubsetOperation(this.getProject(), fileExtension, defaultExtension, changedClasses, false);
            op78.setValidators(javaValidatorNames);
            TestWrapper test78 = new TestWrapper((ValidationOperation)op78, tmdJava, "op78", javaValidatorNames);
            TestWrapper[] result = new TestWrapper[]{test1, test2, test3, test4, test5, test6, test7, test8, test9, test10, test11, test12, test13, test14, test15, test16, test17, test18, test19, test20, test21, test22, test23, test24, test25, test26, test27, test28, test29, test30, test31, test32, test33, test34, test35, test36, test37, test38, test39, test40, test41, test42, test43, test44, test45, test46, test47, test48, test49, test50, test51, test52, test53, test54, test55, test56, test57, test58, test59, test60, test61, test62, test63, test64, test65, test66, test67, test68, test69, test70, test71, test72, test73, test74, test75, test76, test77, test78};
            return result;
        }
        TestWrapper[] result = new TestWrapper[]{test1, test2, test3, test4, test5, test6, test7, test8, test9, test10, test11, test12, test13, test14, test15, test16, test17, test18, test19, test20, test21, test22, test23, test24, test25, test26, test27, test28, test29, test30, test31, test32, test33, test34, test35, test36, test37, test38, test39, test40, test41, test42, test43, test44, test45, test46, test47, test48, test49, test50, test51, test52, test53, test54, test55, test56, test57, test58, test59, test60, test61, test62, test63, test64, test65, test66};
        return result;
    }

    private class TestWrapper {
        private List _messages = null;
        private ValidationOperation _operation = null;
        private String _testName = null;
        private String[] _validatorNames = null;

        TestWrapper(ValidationOperation op, List expectedMessages, String testName, String[] validatorNames) {
            this._messages = expectedMessages;
            this._operation = op;
            this._testName = testName;
            this._validatorNames = validatorNames;
        }

        public List getExpectedMessages() {
            return this._messages;
        }

        public ValidationOperation getOperation() {
            return this._operation;
        }

        public String getName() {
            return this._testName;
        }

        public String[] getValidatorNames() {
            return this._validatorNames;
        }
    }
}

