/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.junit;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.validation.test.internal.registry.TestcaseUtility;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.jst.validation.test.internal.util.BVTRunner;
import org.eclipse.jst.validation.test.junit.JUnitBuffer;
import org.eclipse.jst.validation.test.junit.ValidatorSuite;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;

public class ValidatorTest
extends TestCase {
    private ValidatorTestcase _tmd = null;
    private ValidatorSuite _suite = null;

    public ValidatorTest(ValidatorTestcase tmd, ValidatorSuite suite) {
        super(tmd.getName());
        this._tmd = tmd;
        this._suite = suite;
    }

    public JUnitBuffer getBuffer() {
        return this._suite.getBuffer();
    }

    public String toString() {
        return this._tmd.getProjectName();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runTest() throws Throwable {
        try {
            IProject project = TestcaseUtility.findProject(this._tmd);
            if (!(project != null && project.exists() || BVTRunner.singleton().setupTests(this.getBuffer(), this._tmd, false))) {
                ValidatorTest.fail((String)("Could not import input from directory " + TestcaseUtility.getInputDir(this._tmd)));
            }
            if (!project.isAccessible()) {
                ValidatorTest.fail((String)("Project " + project.getName() + " is not accessible."));
            }
            this._tmd.run(this.getBuffer(), project);
            if (!this.getBuffer().isSuccessful(this._tmd.getName())) {
                ValidatorTest.fail((String)(String.valueOf(this._tmd.getName()) + " failed. Read the log for details. " + this.getBuffer().getLogFileName()));
            }
            ValidatorManager vm = ValidatorManager.getManager();
            ValidatorManager.addProjectBuildValidationSupport((IProject)project);
            vm.enableValidator("ClasspathDependencyValidator");
            vm.disableValidator("EarValidator");
            vm.enableValidator("WarValidator", project, true, false);
            vm.disableValidator("EJBValidator", project, true, true);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.getBuffer().delineate(this._tmd.getName());
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.getBuffer().delineate(this._tmd.getName());
            return;
        }
    }
}

