/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOneToOne;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.INonOwningMapping;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaSingleRelationshipMappingContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaOneToOneContext
extends JavaSingleRelationshipMappingContext {
    public JavaOneToOneContext(IContext parentContext, JavaOneToOne javaOneToOne) {
        super(parentContext, javaOneToOne);
    }

    @Override
    protected JavaOneToOne getMapping() {
        return (JavaOneToOne)super.getMapping();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.getMapping().getMappedBy() != null) {
            this.addMappedByMessages(messages);
        }
    }

    protected void addMappedByMessages(List<IMessage> messages) {
        INonOwningMapping mappedByMapping;
        JavaOneToOne mapping = this.getMapping();
        String mappedBy = mapping.getMappedBy();
        IEntity targetEntity = mapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        IPersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        if (!mapping.mappedByIsValid(attribute.getMapping())) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        try {
            mappedByMapping = (INonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", mapping, mapping.mappedByTextRange()));
        }
    }

    @Override
    protected boolean isOwningSide() {
        return this.getMapping().getMappedBy() == null;
    }
}

