/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.pagedesigner.commands.single.AddSubNodeCommand;
import org.eclipse.jst.pagedesigner.commands.single.InsertSubNodeCommand;
import org.eclipse.jst.pagedesigner.commands.single.RemoveSubNodeCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.properties.BaseCustomSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSFHtmlDataTableColumnsSection
extends BaseCustomSection {
    private Table _columnsTable;
    private TableViewer _columnsViewer;
    private Button _addButton;
    private Button _removeButton;
    private Button _moveUpButton;
    private Button _moveDownButton;
    private final String DEFAULT_COLUMN_NAME = "column";
    private final String DEFAULT_FACET_NAME = "header";
    private final String DEFAULT_TEXT_NAME = "text";

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite top = factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        this.createColumnPart(factory, top);
    }

    private void createColumnPart(TabbedPropertySheetWidgetFactory factory, Composite other) {
        this._columnsTable = factory.createTable(other, 65538);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 4;
        data.widthHint = 10;
        data.heightHint = 50;
        this._columnsTable.setHeaderVisible(true);
        this._columnsTable.setLayoutData((Object)data);
        this._columnsTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this._columnsTable, 0);
        column.setText(SectionResources.getString("JSFHtmlDataTableSection.Columns"));
        column.setWidth(200);
        this._columnsViewer = new TableViewer(this._columnsTable);
        this._columnsViewer.setContentProvider((IContentProvider)new ColumnCotentLabelProvider());
        this._columnsViewer.setLabelProvider((IBaseLabelProvider)new ColumnCotentLabelProvider());
        this._columnsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    IDOMElement node = (IDOMElement)selection.getFirstElement();
                    JSFHtmlDataTableColumnsSection.this.gotoNode((Node)node);
                }
            }
        });
        this._columnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFHtmlDataTableColumnsSection.this.updateButtonStatus();
            }
        });
        this._addButton = factory.createButton(other, SectionResources.getString("JSFHtmlDataTableSection.Add"), 0);
        data = new GridData(256);
        this._addButton.setLayoutData((Object)data);
        this._addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int count = JSFHtmlDataTableColumnsSection.this._columnsTable.getItemCount();
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("id", "column" + (count + 1));
                AddSubNodeCommand c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlDataTableSection.CommandLabel.AddSubTag"), JSFHtmlDataTableColumnsSection.this._element, "column", "http://java.sun.com/jsf/html", attributes);
                c.execute();
                IDOMElement child = c.getChildNode();
                attributes = new HashMap();
                attributes.put("name", "header");
                c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlDataTableSection.CommandLabel.AddSubTag"), child, "facet", "http://java.sun.com/jsf/core", attributes);
                c.execute();
                child = c.getChildNode();
                attributes = new HashMap();
                attributes.put("id", "text" + (count + 1));
                attributes.put("value", "column" + (count + 1));
                c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlDataTableSection.CommandLabel.AddSubTag"), child, "outputText", "http://java.sun.com/jsf/html", attributes);
                c.execute();
                JSFHtmlDataTableColumnsSection.this._columnsViewer.refresh();
                JSFHtmlDataTableColumnsSection.this.updateButtonStatus();
            }
        });
        this._removeButton = factory.createButton(other, SectionResources.getString("JSFHtmlDataTableSection.Remove"), 0);
        data = new GridData(256);
        this._removeButton.setLayoutData((Object)data);
        this._removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JSFHtmlDataTableColumnsSection.this._columnsViewer.getSelection();
                if (selection != null) {
                    for (IDOMElement node : selection) {
                        RemoveSubNodeCommand c = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlDataTableSection.CommandLabel.RemoveSubTag"), JSFHtmlDataTableColumnsSection.this._element, node);
                        c.execute();
                    }
                    JSFHtmlDataTableColumnsSection.this._columnsViewer.refresh();
                    JSFHtmlDataTableColumnsSection.this.updateButtonStatus();
                }
            }
        });
        this._moveUpButton = factory.createButton(other, SectionResources.getString("JSFHtmlDataTableSection.MoveUp"), 0);
        data = new GridData(256);
        this._moveUpButton.setLayoutData((Object)data);
        this._moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = JSFHtmlDataTableColumnsSection.this._columnsTable.getSelectionIndex();
                IDOMElement child = (IDOMElement)JSFHtmlDataTableColumnsSection.this._columnsTable.getItem(index).getData();
                IDOMElement refchild = (IDOMElement)JSFHtmlDataTableColumnsSection.this._columnsTable.getItem(index - 1).getData();
                RemoveSubNodeCommand remove = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlDataTableSection.CommandLabel.RemoveSubTag"), JSFHtmlDataTableColumnsSection.this._element, child);
                remove.execute();
                InsertSubNodeCommand insert = new InsertSubNodeCommand(SectionResources.getString("JSFHtmlDataTableSection.CommandLabel.InsertSubTag"), JSFHtmlDataTableColumnsSection.this._element, child, refchild);
                insert.execute();
                JSFHtmlDataTableColumnsSection.this._columnsViewer.refresh();
                JSFHtmlDataTableColumnsSection.this.updateButtonStatus();
            }
        });
        this._moveDownButton = factory.createButton(other, SectionResources.getString("JSFHtmlDataTableSection.MoveDown"), 0);
        data = new GridData(256);
        this._moveDownButton.setLayoutData((Object)data);
        this._moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = JSFHtmlDataTableColumnsSection.this._columnsTable.getSelectionIndex();
                IDOMElement child = (IDOMElement)JSFHtmlDataTableColumnsSection.this._columnsTable.getItem(index).getData();
                IDOMElement refchild = (IDOMElement)JSFHtmlDataTableColumnsSection.this._columnsTable.getItem(index + 1).getData();
                RemoveSubNodeCommand remove = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlDataTableSection.CommandLabel.RemoveSubTag"), JSFHtmlDataTableColumnsSection.this._element, refchild);
                remove.execute();
                InsertSubNodeCommand insert = new InsertSubNodeCommand(SectionResources.getString("JSFHtmlDataTableSection.CommandLabel.InsertSubTag"), JSFHtmlDataTableColumnsSection.this._element, refchild, child);
                insert.execute();
                JSFHtmlDataTableColumnsSection.this._columnsViewer.refresh();
                JSFHtmlDataTableColumnsSection.this.updateButtonStatus();
            }
        });
    }

    public void updateButtonStatus() {
        this._removeButton.setEnabled(true);
        this._moveUpButton.setEnabled(true);
        this._moveDownButton.setEnabled(true);
        ISelection selection = this._columnsViewer.getSelection();
        if (selection.isEmpty()) {
            this._removeButton.setEnabled(false);
            this._moveUpButton.setEnabled(false);
            this._moveDownButton.setEnabled(false);
        }
        if (this._columnsTable.getItemCount() == 0) {
            this._removeButton.setEnabled(false);
            this._moveUpButton.setEnabled(false);
            this._moveDownButton.setEnabled(false);
        }
        if (this._columnsTable.getSelectionCount() > 1) {
            this._moveUpButton.setEnabled(false);
            this._moveDownButton.setEnabled(false);
        }
        if (this._columnsTable.getSelectionIndex() == 0) {
            this._moveUpButton.setEnabled(false);
        }
        if (this._columnsTable.getSelectionIndex() == this._columnsTable.getItemCount() - 1) {
            this._moveDownButton.setEnabled(false);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this._columnsViewer.setInput((Object)this._element);
        this.updateButtonStatus();
    }

    protected void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this._columnsViewer != null && !this._columnsViewer.getControl().isDisposed()) {
            this._columnsViewer.refresh();
        }
    }

    class ColumnCotentLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        ColumnCotentLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDOMElement root = JSFHtmlDataTableColumnsSection.this._element;
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList children = root.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                IDOMElement element;
                String nodeName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (nodeName = (element = (IDOMElement)child).getNodeName()).indexOf("column") != -1) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return new Object[0];
            }
            return result.toArray(new IDOMElement[result.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IDOMElement) {
                IDOMElement node = (IDOMElement)element;
                switch (columnIndex) {
                    case 0: {
                        result = node.getAttribute("id");
                        break;
                    }
                }
            }
            return result != null ? result : "";
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

