/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jpt.core.internal.mappings.IMultiRelationshipMapping;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class OrderingComposite
extends BaseJpaComposite {
    private IMultiRelationshipMapping mapping;
    private Adapter mappingListener = this.buildMappingListener();
    private Button noOrderingRadioButton;
    private Button primaryKeyOrderingRadioButton;
    private Button customOrderingRadioButton;
    private ITextViewer orderingTextViewer;
    private boolean updatingCustomOrderBy = false;

    public OrderingComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, commandStack, widgetFactory);
    }

    private Adapter buildMappingListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                OrderingComposite.this.mappingChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group orderByGroup = this.getWidgetFactory().createGroup(composite, JptUiMappingsMessages.OrderByComposite_orderByGroup);
        orderByGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        orderByGroup.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)orderByGroup, "org.eclipse.jpt.ui.mapping_orderBy");
        this.noOrderingRadioButton = this.buildNoOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.noOrderingRadioButton.setLayoutData((Object)gridData);
        this.primaryKeyOrderingRadioButton = this.buildPrimaryKeyOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.primaryKeyOrderingRadioButton.setLayoutData((Object)gridData);
        this.customOrderingRadioButton = this.buildCustomOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.customOrderingRadioButton.setLayoutData((Object)gridData);
        this.orderingTextViewer = this.buildOrderByTestViewer((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 15;
        this.orderingTextViewer.getTextWidget().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.orderingTextViewer.getTextWidget(), "org.eclipse.jpt.ui.mapping_orderBy");
    }

    private Button buildNoOrderingRadioButton(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.OrderByComposite_noOrdering, 16);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderingComposite.this.noOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    void noOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        if (this.mapping.isNoOrdering()) {
            return;
        }
        this.mapping.setNoOrdering();
    }

    private Button buildPrimaryKeyOrderingRadioButton(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.OrderByComposite_primaryKeyOrdering, 16);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderingComposite.this.primaryKeyOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    void primaryKeyOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        if (!this.mapping.isOrderByPk()) {
            this.mapping.setOrderByPk();
        }
        this.setTextViewerEnabled(false);
    }

    private Button buildCustomOrderingRadioButton(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.OrderByComposite_customOrdering, 16);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderingComposite.this.customOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    void customOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        this.setTextViewerEnabled(true);
    }

    private ITextViewer buildOrderByTestViewer(Composite parent) {
        TextViewer textViewer = new TextViewer(parent, 2052);
        textViewer.setDocument((IDocument)new Document());
        textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                OrderingComposite.this.orderingTextViewerChanged();
            }
        });
        return textViewer;
    }

    private void orderingTextViewerChanged() {
        if (this.isPopulating()) {
            return;
        }
        String orderByValue = this.orderingTextViewer.getDocument().get();
        if (orderByValue.equals(this.mapping.getOrderBy())) {
            return;
        }
        this.updatingCustomOrderBy = true;
        this.mapping.setOrderBy(orderByValue);
    }

    private void setTextViewerEnabled(boolean enabled) {
        this.orderingTextViewer.setEditable(enabled);
        this.orderingTextViewer.getTextWidget().setEnabled(enabled);
    }

    private void mappingChanged(Notification notification) {
        if (notification.getFeatureID(IMultiRelationshipMapping.class) == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    OrderingComposite.this.populate();
                }
            });
        }
    }

    protected void doPopulate(EObject obj) {
        this.mapping = (IMultiRelationshipMapping)obj;
        if (this.mapping == null) {
            return;
        }
        this.populateOrderingRadioButtons();
    }

    protected void doPopulate() {
        this.populateOrderingRadioButtons();
    }

    protected void engageListeners() {
        if (this.mapping != null) {
            this.mapping.eAdapters().add((Object)this.mappingListener);
        }
    }

    protected void disengageListeners() {
        if (this.mapping != null) {
            this.mapping.eAdapters().remove((Object)this.mappingListener);
        }
    }

    private void populateOrderingRadioButtons() {
        if (this.updatingCustomOrderBy) {
            this.updatingCustomOrderBy = false;
            return;
        }
        if (this.mapping.isNoOrdering()) {
            this.primaryKeyOrderingRadioButton.setSelection(false);
            this.customOrderingRadioButton.setSelection(false);
            this.noOrderingRadioButton.setSelection(true);
            if (!"".equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set("");
            }
        } else if (this.mapping.isOrderByPk()) {
            this.customOrderingRadioButton.setSelection(false);
            this.noOrderingRadioButton.setSelection(false);
            this.primaryKeyOrderingRadioButton.setSelection(true);
            if (!"".equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set("");
            }
        } else if (this.mapping.isCustomOrdering()) {
            this.noOrderingRadioButton.setSelection(false);
            this.primaryKeyOrderingRadioButton.setSelection(false);
            this.customOrderingRadioButton.setSelection(true);
            String value = this.mapping.getOrderBy();
            if (value != null && !value.equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set(value);
            }
        }
        this.setTextViewerEnabled(this.mapping.isCustomOrdering());
    }
}

