/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsp.core.internal.validation.LocalizedMessage;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

class HTMLValidationReporter
implements ValidationReporter {
    private IValidator owner = null;
    private IReporter reporter = null;
    private IFile file = null;
    private IStructuredModel model = null;

    public HTMLValidationReporter(IValidator owner, IReporter reporter, IFile file, IStructuredModel model) {
        this.owner = owner;
        this.reporter = reporter;
        this.file = file;
        this.model = model;
    }

    void clear() {
        if (this.file == null) {
            return;
        }
        if (this.reporter != null) {
            this.reporter.removeAllMessages(this.owner, (Object)this.file);
        }
    }

    public void report(ValidationMessage message) {
        if (message == null) {
            return;
        }
        if (this.file == null) {
            return;
        }
        IMessage mes = this.translateMessage(message);
        if (this.reporter != null) {
            this.reporter.addMessage(this.owner, mes);
        }
    }

    private IMessage translateMessage(ValidationMessage message) {
        IStructuredDocument flatModel;
        int severity = 4;
        switch (message.getSeverity()) {
            case 1: {
                severity = 1;
                break;
            }
            case 2: {
                severity = 2;
                break;
            }
        }
        LocalizedMessage mes = new LocalizedMessage(severity, message.getMessage(), (IResource)this.file);
        mes.setOffset(message.getOffset());
        mes.setLength(message.getLength());
        if (this.model != null && (flatModel = this.model.getStructuredDocument()) != null) {
            int line = flatModel.getLineOfOffset(message.getOffset());
            mes.setLineNo(line + 1);
        }
        return mes;
    }
}

