/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.performance.internal.scalability;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.test.performance.Dimension;
import org.eclipse.wst.common.tests.performance.internal.scalability.ScalabilityTestCase;
import org.eclipse.wst.common.tests.performance.internal.util.EditorTestHelper;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.OneValidatorOperation;

public abstract class RunValidatorTestCase
extends ScalabilityTestCase {
    protected IFile file;

    protected abstract String getValidatorId();

    protected abstract String getBundleId();

    protected abstract String getFilePath();

    protected void setUp() throws Exception {
        super.setUp();
        IProject project = this.createProject("sp");
        String bundleId = this.getBundleId();
        this.file = this.copyFile(bundleId, this.getFilePath(), (IContainer)project);
        this.joinBackgroundJobs(3000);
    }

    public void execute() throws Exception {
        this.tagAsSummary(this.getClassName(), new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.USED_JAVA_HEAP});
        this.startMeasuring();
        this.runValidator(this.file);
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected void runValidator(IFile file) throws CoreException, ValidationException {
        OneValidatorOperation operation = new OneValidatorOperation(file.getProject(), this.getValidatorId(), true, false);
        operation.run((IProgressMonitor)new NullProgressMonitor());
        try {
            EditorTestHelper.joinBackgroundActivities();
        }
        catch (CoreException e) {
            RunValidatorTestCase.fail((String)e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.deleteProject("sp");
    }
}

