/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.internet.cache.internal.Cache;

public class CacheTest
extends TestCase {
    private Cache cache;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.internet.cache.internal.CacheTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = Cache.getInstance();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetNonExistantResource() {
        String resource = "http://www.eclipse.org/webtools/nonexistantfile";
        String result = this.cache.getResource(resource);
        this.cache.clear();
        CacheTest.assertNull((String)("The result returned for resource " + resource + " is not null."), (Object)result);
    }

    public void testGetNullResource() {
        String resource = null;
        String result = this.cache.getResource(resource);
        this.cache.clear();
        CacheTest.assertNull((String)("The result returned for resource " + resource + " is not null."), (Object)result);
    }

    public void testGetResourceThatExists() {
        String resource = "http://www.eclipse.org/webtools";
        String result = this.cache.getResource(resource);
        this.cache.clear();
        CacheTest.assertNotNull((String)("The result returned for resource " + resource + " was null."), (Object)result);
        CacheTest.assertTrue((String)"The result and resource are the same.", (!resource.equals(result) ? 1 : 0) != 0);
    }

    public void testResultStartsWithFile() {
        String resource = "http://www.eclipse.org/webtools";
        String result = this.cache.getResource(resource);
        this.cache.clear();
        CacheTest.assertTrue((String)"The result does not start with file:///.", (boolean)result.startsWith("file:///"));
    }

    public void testDeleteCacheEntry() {
        String resource = "http://www.eclipse.org/webtools";
        String result = this.cache.getResource(resource);
        CacheTest.assertNotNull((String)"The local cache file is null.", (Object)result);
        result = result.substring(8);
        CacheTest.assertTrue((String)("The cache file " + result + " does not exist."), (boolean)new File(result).exists());
        this.cache.deleteEntry(resource);
        CacheTest.assertFalse((String)"The cache file was not deleted.", (boolean)new File(result).exists());
        CacheTest.assertTrue((String)"The cache still contains the deleted entry.", (this.cache.getCachedURIs().length == 0 ? 1 : 0) != 0);
        this.cache.clear();
    }

    public void testDeleteNullCacheEntry() {
        String resource = "http://www.eclipse.org/webtools";
        this.cache.getResource(resource);
        this.cache.deleteEntry(null);
        CacheTest.assertFalse((String)"The cache no longer contains the entry after deleting null.", (this.cache.getCachedURIs().length == 0 ? 1 : 0) != 0);
        this.cache.clear();
    }

    public void testClearCacheWithSingleEntry() {
        String resource1 = "http://www.eclipse.org/webtools";
        String result1 = this.cache.getResource(resource1);
        CacheTest.assertNotNull((String)"The local cache file is null for resource1.", (Object)result1);
        result1 = result1.substring(8);
        CacheTest.assertTrue((String)("The cache file " + result1 + " does not exist."), (boolean)new File(result1).exists());
        this.cache.clear();
        CacheTest.assertFalse((String)"The cache file for resource1 was not deleted.", (boolean)new File(result1).exists());
        CacheTest.assertTrue((String)"The cache still contains the deleted entries.", (this.cache.getCachedURIs().length == 0 ? 1 : 0) != 0);
    }

    public void testClearCacheWithMultipleEntries() {
        String resource1 = "http://www.eclipse.org/webtools";
        String resource2 = "http://www.eclipse.org";
        String result1 = this.cache.getResource(resource1);
        String result2 = this.cache.getResource(resource2);
        CacheTest.assertNotNull((String)"The local cache file is null for resource1.", (Object)result1);
        CacheTest.assertNotNull((String)"The local cache file is null for resource2.", (Object)result2);
        result1 = result1.substring(8);
        result2 = result2.substring(8);
        CacheTest.assertTrue((String)("The cache file " + result1 + " does not exist."), (boolean)new File(result1).exists());
        CacheTest.assertTrue((String)("The cache file " + result2 + " does not exist."), (boolean)new File(result2).exists());
        this.cache.clear();
        CacheTest.assertFalse((String)"The cache file for resource1 was not deleted.", (boolean)new File(result1).exists());
        CacheTest.assertFalse((String)"The cache file for resource2 was not deleted.", (boolean)new File(result2).exists());
        CacheTest.assertTrue((String)"The cache still contains the deleted entries.", (this.cache.getCachedURIs().length == 0 ? 1 : 0) != 0);
    }

    public void testGetInstance() {
        CacheTest.assertNotNull((String)"The cache object is null.", (Object)this.cache);
    }

    public void testGetCacheEntries() {
        String resource1 = "http://www.eclipse.org/webtools";
        String resource2 = "http://www.eclipse.org";
        String resource3 = "http://www.eclipse.org/webtools/nonexistantfile";
        this.cache.getResource(resource1);
        this.cache.getResource(resource2);
        this.cache.getResource(resource3);
        String[] uris = this.cache.getCachedURIs();
        CacheTest.assertTrue((String)"There are not 2 entries in the cache.", (uris.length == 2 ? 1 : 0) != 0);
        int i = 0;
        while (i < uris.length - 1) {
            String uri = uris[i];
            if (!(uri.equals(resource1) || uri.equals(resource2) || uri.equals(resource3))) {
                CacheTest.fail((String)("The URI " + uri + " is not equal to any of the resources put in the cache."));
            }
            ++i;
        }
        this.cache.clear();
    }
}

