/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jdtutility;

import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.FieldAttribute;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.tests.internal.jdtutility.AnnotationTestCase;

public class JDTToolsTests
extends AnnotationTestCase {
    public JDTToolsTests(String name) {
        super(name);
    }

    private void createEnumAndMembers(String enumName, String enumBody) throws Exception {
        this.javaProject.createType("enums", String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    private void createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        this.javaProject.createType("annot", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    public void testResolveEnum1() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        this.createTestType("@annot.TestAnnotation(foo=enums.TestEnum.BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        FieldAttribute field = this.idField();
        String actual = JDTTools.resolveEnum((Name)((Name)field.annotationElementExpression((DeclarationAnnotationElementAdapter)daea)));
        JDTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum2() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        this.createTestType("static enums.TestEnum.BAZ", "@annot.TestAnnotation(foo=BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        FieldAttribute field = this.idField();
        String actual = JDTTools.resolveEnum((Name)((Name)field.annotationElementExpression((DeclarationAnnotationElementAdapter)daea)));
        JDTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum3() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        this.createTestType("static enums.TestEnum.*", "@annot.TestAnnotation(foo=BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        FieldAttribute field = this.idField();
        String actual = JDTTools.resolveEnum((Name)((Name)field.annotationElementExpression((DeclarationAnnotationElementAdapter)daea)));
        JDTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum4() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        this.createTestType("enums.TestEnum", "@annot.TestAnnotation(foo=TestEnum.BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        FieldAttribute field = this.idField();
        String actual = JDTTools.resolveEnum((Name)((Name)field.annotationElementExpression((DeclarationAnnotationElementAdapter)daea)));
        JDTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }
}

