/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jdtutility;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.tests.internal.jdtutility.AnnotationTestCase;

public class SimpleDeclarationAnnotationAdapterTests
extends AnnotationTestCase {
    public SimpleDeclarationAnnotationAdapterTests(String name) {
        super(name);
    }

    private void createAnnotation(String annotationName) throws Exception {
        this.javaProject.createType("annot", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " {}");
    }

    public void testGetAnnotation1() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        SimpleDeclarationAnnotationAdapterTests.assertEquals((String)"annot.Foo", (String)annotation.getTypeName().getFullyQualifiedName());
        SimpleDeclarationAnnotationAdapterTests.assertTrue((boolean)annotation.isMarkerAnnotation());
    }

    public void testGetAnnotation2() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType("@annot.Foo(1) @annot.Foo(2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        SimpleDeclarationAnnotationAdapterTests.assertEquals((String)"annot.Foo", (String)annotation.getTypeName().getFullyQualifiedName());
        SimpleDeclarationAnnotationAdapterTests.assertTrue((boolean)annotation.isSingleMemberAnnotation());
        Expression value = ((SingleMemberAnnotation)annotation).getValue();
        SimpleDeclarationAnnotationAdapterTests.assertEquals((int)34, (int)value.getNodeType());
        SimpleDeclarationAnnotationAdapterTests.assertEquals((String)"1", (String)((NumberLiteral)value).getToken());
    }

    public void testGetAnnotation3() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType("annot.Foo", "@Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        SimpleDeclarationAnnotationAdapterTests.assertEquals((String)"Foo", (String)annotation.getTypeName().getFullyQualifiedName());
        SimpleDeclarationAnnotationAdapterTests.assertTrue((boolean)annotation.isMarkerAnnotation());
    }

    public void testGetAnnotationNull1() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
    }

    public void testGetAnnotationNull2() throws Exception {
        this.createAnnotation("Foo");
        this.createAnnotation("Fop");
        this.createTestType("@annot.Fop");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        this.assertSourceContains("@annot.Fop");
    }

    public void testGetAnnotationNull3() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        this.assertSourceContains("@annot.Foo");
    }

    public void testRemoveAnnotation1() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType("@annot.Foo");
        this.assertSourceContains("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        aa.removeAnnotation();
        this.assertSourceDoesNotContain("@annot.Foo");
    }

    public void testRemoveAnnotation2() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType("@annot.Foo(1) @annot.Foo(2)");
        this.assertSourceContains("@annot.Foo(1) @annot.Foo(2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        aa.removeAnnotation();
        this.assertSourceDoesNotContain("@annot.Foo(1)");
        this.assertSourceContains("@annot.Foo(2)");
    }

    public void testNewMarkerAnnotation1() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType();
        this.assertSourceDoesNotContain("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        aa.newMarkerAnnotation();
        this.assertSourceContains("import annot.Foo;");
        this.assertSourceContains("@Foo");
    }

    public void testNewMarkerAnnotation2() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType("@annot.Foo(88)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        MemberAnnotationAdapter aa = new MemberAnnotationAdapter((Member)this.idField(), (DeclarationAnnotationAdapter)daa);
        Annotation annotation = aa.getAnnotation();
        SimpleDeclarationAnnotationAdapterTests.assertNotNull((Object)annotation);
        aa.newMarkerAnnotation();
        this.assertSourceContains("import annot.Foo;");
        this.assertSourceContains("@Foo");
        this.assertSourceDoesNotContain("@annot.Foo(88)");
    }

    public void testNewSingleMemberAnnotation() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType();
        this.assertSourceDoesNotContain("@Foo");
        this.idField().edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SimpleDeclarationAnnotationAdapterTests.this.editNewSingleMemberAnnotation(declaration);
            }
        });
        this.assertSourceContains("import annot.Foo;");
        this.assertSourceContains("@Foo(\"test string literal\")");
    }

    void editNewSingleMemberAnnotation(ModifiedDeclaration declaration) {
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        SingleMemberAnnotation annotation = (SingleMemberAnnotation)daa.getAnnotation(declaration);
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        annotation = daa.newSingleMemberAnnotation(declaration);
        StringLiteral stringLiteral = annotation.getAST().newStringLiteral();
        stringLiteral.setLiteralValue("test string literal");
        annotation.setValue((Expression)stringLiteral);
    }

    public void testNewNormalAnnotation() throws Exception {
        this.createAnnotation("Foo");
        this.createTestType();
        this.assertSourceDoesNotContain("@Foo");
        this.idField().edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SimpleDeclarationAnnotationAdapterTests.this.editNewNormalAnnotation(declaration);
            }
        });
        this.assertSourceContains("import annot.Foo;");
        this.assertSourceContains("@Foo(bar=\"test string literal\")");
    }

    void editNewNormalAnnotation(ModifiedDeclaration declaration) {
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NormalAnnotation annotation = (NormalAnnotation)daa.getAnnotation(declaration);
        SimpleDeclarationAnnotationAdapterTests.assertNull((Object)annotation);
        annotation = daa.newNormalAnnotation(declaration);
        MemberValuePair mvp = this.newMemberValuePair(annotation.getAST(), "bar", "test string literal");
        this.values(annotation).add(mvp);
    }
}

