/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.projects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jpt.core.tests.internal.projects.TestFacetedProject;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class TestJavaProject
extends TestFacetedProject {
    private IJavaProject javaProject;
    private IPackageFragmentRoot sourceFolder;

    public TestJavaProject() throws CoreException {
        this("TestJavaProject");
    }

    public TestJavaProject(String projectName) throws CoreException {
        this(projectName, false);
    }

    public TestJavaProject(String projectName, boolean autoBuild) throws CoreException {
        super(projectName, autoBuild);
        this.installFacet("jst.java", "5.0");
        this.javaProject = JavaCore.create((IProject)this.getProject());
        this.sourceFolder = this.javaProject.getPackageFragmentRoot((IResource)this.getProject().getFolder("src"));
    }

    protected void addJar(String jarPath) throws JavaModelException {
        this.addClasspathEntry(JavaCore.newLibraryEntry((IPath)new Path(jarPath), null, null));
    }

    private void addClasspathEntry(IClasspathEntry entry) throws JavaModelException {
        this.javaProject.setRawClasspath((IClasspathEntry[])CollectionTools.add((Object[])this.javaProject.getRawClasspath(), (Object)entry), null);
    }

    public IPackageFragment createPackage(String packageName) throws CoreException {
        return this.sourceFolder.createPackageFragment(packageName, false, null);
    }

    public IType createType(String packageName, String compilationUnitName, String source) throws CoreException {
        return this.createType(this.createPackage(packageName), compilationUnitName, (SourceWriter)new SimpleSourceWriter(source));
    }

    public IType createType(String packageName, String compilationUnitName, SourceWriter sourceWriter) throws CoreException {
        return this.createType(this.createPackage(packageName), compilationUnitName, sourceWriter);
    }

    public IType createType(IPackageFragment packageFragment, String compilationUnitName, SourceWriter sourceWriter) throws CoreException {
        StringBuffer sb = new StringBuffer(2000);
        sb.append("package ").append(packageFragment.getElementName()).append(";").append(CR);
        sb.append(CR);
        sourceWriter.appendSourceTo(sb);
        String source = sb.toString();
        ICompilationUnit cu = packageFragment.createCompilationUnit(compilationUnitName, source, false, null);
        return cu.findPrimaryType();
    }

    public IType findType(String fullyQualifiedName) throws JavaModelException {
        return this.javaProject.findType(fullyQualifiedName);
    }

    public void dispose() throws CoreException {
        this.waitForIndexer();
        this.sourceFolder = null;
        this.javaProject = null;
        super.dispose();
    }

    private void waitForIndexer() throws JavaModelException {
        new SearchEngine().searchAllTypeNames(null, 8, null, 8, 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]), new TypeNameRequestor(){}, 3, null);
    }

    public class SimpleSourceWriter
    implements SourceWriter {
        private final String source;

        public SimpleSourceWriter(String source) {
            this.source = source;
        }

        public void appendSourceTo(StringBuffer sb) {
            sb.append(this.source);
        }
    }

    public static interface SourceWriter {
        public void appendSourceTo(StringBuffer var1);
    }
}

