/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.collector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.tests.collector.SuiteHelper;
import org.eclipse.wst.common.tests.collector.TestCollectorInnerPanes;

public class TestCollectorGUI
extends Composite
implements ModifyListener {
    private static final String PLUGIN_ID = "org.eclipse.wst.common.tests.collector";
    private static final String SUITES_EXT_PT = "suites";
    private Composite innerPanes = null;
    private Combo combo = null;
    private Hashtable testSuites = new Hashtable();

    public TestCollectorGUI(Composite parent, int style) {
        super(parent, style);
        this.loadConfiguration();
        this.createPartControl();
    }

    private void loadConfiguration() {
        IExtensionPoint suiteExtPt = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SUITES_EXT_PT);
        IExtension[] suitesExtensions = suiteExtPt.getExtensions();
        int i = 0;
        while (i < suitesExtensions.length) {
            IExtension extension = suitesExtensions[i];
            IConfigurationElement[] tests = extension.getConfigurationElements();
            int j = 0;
            while (j < tests.length) {
                try {
                    IConfigurationElement element = tests[j];
                    String suiteName = element.getAttribute("name");
                    this.testSuites.put(suiteName, element);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
    }

    public void createPartControl() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.combo = new Combo((Composite)this, 8);
        Enumeration keys = this.testSuites.keys();
        ArrayList arrayList = new ArrayList();
        while (keys.hasMoreElements()) {
            arrayList.add(keys.nextElement());
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        int i = 0;
        while (i < arrayList.size()) {
            this.combo.add((String)arrayList.get(i));
            ++i;
        }
        this.combo.setLayoutData((Object)gridData);
        this.combo.addModifyListener((ModifyListener)this);
        if (this.combo.getItemCount() > 0) {
            this.combo.select(0);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.combo) {
            this.updateCombo(e);
        }
    }

    private void updateCombo(ModifyEvent e) {
        if (this.innerPanes != null) {
            this.innerPanes.dispose();
        }
        try {
            String testName = this.combo.getText();
            IConfigurationElement element = (IConfigurationElement)this.testSuites.get(testName);
            TestSuite suite = (TestSuite)element.createExecutableExtension("class");
            this.innerPanes = new TestCollectorInnerPanes(this, 0, new SuiteHelper(suite));
        }
        catch (Exception ex) {
            this.innerPanes = new Composite((Composite)this, 0);
            this.innerPanes.setLayout((Layout)new GridLayout());
            this.innerPanes.setBackground(this.getBackground());
            Label errorLabel = new Label(this.innerPanes, 0);
            errorLabel.setText(ex.getMessage());
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            errorLabel.setLayoutData((Object)gridData);
        }
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.innerPanes.setLayoutData((Object)gridData);
        this.layout();
    }
}

