/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.translation;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapterFactory;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.tests.JSPCoreTestsPlugin;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.osgi.framework.Bundle;

public class JSPJavaTranslatorCoreTest
extends TestCase {
    static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
    String wtp_autotest_noninteractive = null;
    static /* synthetic */ Class class$0;

    public JSPJavaTranslatorCoreTest() {
    }

    public JSPJavaTranslatorCoreTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, this.wtp_autotest_noninteractive);
        }
    }

    public void test_107338() throws Exception {
        JSPTranslationAdapter translationAdapter;
        JSPTranslationExtension translation;
        String projectName = "bug_107338";
        IProject project = BundleResourceUtil.createSimpleProject(projectName, null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + projectName, "/" + projectName);
        IFile file = project.getFile("WebContent/test107338.jsp");
        JSPJavaTranslatorCoreTest.assertTrue((boolean)file.exists());
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(file);
        IDOMModel jspModel = (IDOMModel)model;
        String jspSource = model.getStructuredDocument().get();
        JSPJavaTranslatorCoreTest.assertTrue((String)"line delimiters have been converted to Windows [CRLF]", (jspSource.indexOf("\r\n") < 0 ? 1 : 0) != 0);
        JSPJavaTranslatorCoreTest.assertTrue((String)"line delimiters have been converted to Mac [CR]", (jspSource.indexOf("\r") < 0 ? 1 : 0) != 0);
        FactoryRegistry factoryRegistry = model.getFactoryRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.java.IJSPTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (factoryRegistry.getFactoryFor((Object)clazz) == null) {
            JSPTranslationAdapterFactory factory = new JSPTranslationAdapterFactory();
            model.getFactoryRegistry().addFactory((INodeAdapterFactory)factory);
        }
        IDOMDocument xmlDoc = jspModel.getDocument();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.java.IJSPTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JSPJavaTranslatorCoreTest.assertTrue((String)"new-line beginning scriptlet missing from translation", ((translation = (translationAdapter = (JSPTranslationAdapter)xmlDoc.getAdapterFor((Object)clazz2)).getJSPTranslation()).getJavaText().indexOf("int i = 0;") >= 0 ? 1 : 0) != 0);
        model.releaseFromRead();
    }

    public void test_174042() throws Exception {
        boolean doValidateSegments = JSPCorePlugin.getDefault().getPluginPreferences().getBoolean("validateFragments");
        String testName = "bug_174042";
        IProject project = BundleResourceUtil.createSimpleProject(testName, null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", true);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/struts.jar", "/" + testName + "/struts.jar");
        this.waitForBuildAndValidation(project);
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", doValidateSegments);
        IFile main = project.getFile("main.jsp");
        IMarker[] markers = main.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < markers.length) {
            s.append("\nproblem marker on line " + markers[i].getAttribute("lineNumber") + ": \"" + markers[i].getAttribute("message") + "\" ");
            ++i;
        }
        JSPJavaTranslatorCoreTest.assertEquals((String)("problem markers found, " + s.toString()), (int)0, (int)markers.length);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForBuildAndValidation(IProject project) throws CoreException {
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, "org.eclipse.wst.validation.validationbuilder", null, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
        try {
            try {
                ResourcesPlugin.getWorkspace().checkpoint(true);
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, (IProgressMonitor)new NullProgressMonitor());
                Job.getJobManager().join((Object)"validators", (IProgressMonitor)new NullProgressMonitor());
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                Job.getJobManager().beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public void test_178443() throws Exception {
        boolean doValidateSegments = JSPCorePlugin.getDefault().getPluginPreferences().getBoolean("validateFragments");
        String testName = "bug_178443";
        IProject project = BundleResourceUtil.createSimpleProject(testName, Platform.getStateLocation((Bundle)JSPCoreTestsPlugin.getDefault().getBundle()).append(testName), null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", false);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/struts.jar", "/" + testName + "/struts.jar");
        this.waitForBuildAndValidation(project);
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", doValidateSegments);
        IFile main = project.getFile("main.jsp");
        IMarker[] markers = main.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < markers.length) {
            s.append("\nproblem on line " + markers[i].getAttribute("lineNumber") + ": " + markers[i].getAttribute("message"));
            ++i;
        }
        JSPJavaTranslatorCoreTest.assertEquals((String)("problem markers found" + s.toString()), (int)0, (int)markers.length);
    }

    public void test_109721() throws Exception {
        boolean doValidateSegments = JSPCorePlugin.getDefault().getPluginPreferences().getBoolean("validateFragments");
        String testName = "bug_109721";
        IProject project = BundleResourceUtil.createSimpleProject(testName, Platform.getStateLocation((Bundle)JSPCoreTestsPlugin.getDefault().getBundle()).append(testName), null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", false);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/struts.jar", "/" + testName + "/WebContent/WEB-INF/lib/struts.jar");
        this.waitForBuildAndValidation(project);
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", doValidateSegments);
        IFile main = project.getFile("WebContent/main.jsp");
        IMarker[] markers = main.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < markers.length) {
            s.append("\nproblem on line " + markers[i].getAttribute("lineNumber") + ": " + markers[i].getAttribute("message"));
            ++i;
        }
        JSPJavaTranslatorCoreTest.assertEquals((String)("problem markers found" + s.toString()), (int)0, (int)markers.length);
    }

    public void test_181057a() throws Exception {
        boolean doValidateSegments = JSPCorePlugin.getDefault().getPluginPreferences().getBoolean("validateFragments");
        String testName = "bug_181057";
        IProject j = BundleResourceUtil.createSimpleProject("j", null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)j.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/j", "/j");
        IProject k = BundleResourceUtil.createSimpleProject("k", null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)k.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/k", "/k");
        IProject project = BundleResourceUtil.createSimpleProject(testName, Platform.getStateLocation((Bundle)JSPCoreTestsPlugin.getDefault().getBundle()).append(testName), null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", true);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/struts.jar", "/" + testName + "/struts.jar");
        this.waitForBuildAndValidation(project);
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", doValidateSegments);
        IFile main = project.getFile("main.jsp");
        IMarker[] markers = main.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < markers.length) {
            s.append("\n" + markers[i].getAttribute("lineNumber") + ":" + markers[i].getAttribute("message"));
            ++i;
        }
        JSPJavaTranslatorCoreTest.assertEquals((String)("problem markers found" + s.toString()), (int)0, (int)markers.length);
    }
}

