/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.emfload;

import java.io.File;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.J2EEInit;

public class LoadWebServicesOutsideWorkspace
extends TestCase {
    public static String baseDirectory = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "testData" + File.separatorChar + "webservices" + File.separatorChar + "META-INF" + File.separatorChar;

    public void testLoadFile() throws Exception {
        J2EEInit.init();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
        URIConverterImpl conv = new URIConverterImpl();
        resourceSet.setURIConverter((URIConverter)conv);
        URI uri = URI.createFileURI((String)(String.valueOf(baseDirectory) + "webservices.xml"));
        try {
            Resource resource = resourceSet.getResource(uri, true);
            System.out.println("Loaded " + uri);
            Iterator j = resource.getContents().iterator();
            while (j.hasNext()) {
                EObject eObject = (EObject)j.next();
                Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                if (diagnostic.getSeverity() == 0) continue;
                LoadWebServicesOutsideWorkspace.printDiagnostic(diagnostic, "");
            }
        }
        catch (RuntimeException exception) {
            System.out.println("Problem loading " + uri);
            exception.printStackTrace();
        }
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        Iterator i = diagnostic.getChildren().iterator();
        while (i.hasNext()) {
            LoadWebServicesOutsideWorkspace.printDiagnostic((Diagnostic)i.next(), String.valueOf(indent) + "  ");
        }
    }
}

