/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpath.tests.util;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class ClasspathDependencyTestUtil
extends DependencyUtil {
    public static final IPath CUSTOM_CLASSPATH_CONTAINER = new Path("TEST_CP_CONTAINER");
    public static final String TEST_DATA = "TestData/ClasspathDependencyTests";
    public static final String TEST1_JAR = "Test1.jar";
    public static final String TEST2_JAR = "Test2.jar";
    public static final String TEST3_JAR = "Test3.jar";
    public static final String TEST3_JAR_OTHER_LOCATION = "other/Test3.jar";
    public static final String TEST3_BIN = "Test3_bin";
    public static final IPath TEST1_JAR_PATH = ClasspathDependencyTestUtil.getFullTestDataPath("Test1.jar");
    public static final IPath TEST2_JAR_PATH = ClasspathDependencyTestUtil.getFullTestDataPath("Test2.jar");
    public static final IPath TEST3_JAR_PATH = ClasspathDependencyTestUtil.getFullTestDataPath("Test3.jar");
    public static final IPath TEST3_JAR_OTHER_LOCATION_PATH = ClasspathDependencyTestUtil.getFullTestDataPath("other/Test3.jar");
    public static final IPath TEST3_BIN_PATH = ClasspathDependencyTestUtil.getFullTestDataPath("Test3_bin");
    public static final String CLASSPATH_DEPENDENCY_MARKER_TYPE = "org.eclipse.jst.j2ee.ClasspathDependencyValidatorMarker";
    public static final String VALIDATION_MARKER_TYPE = "org.eclipse.wst.validation.problemmarker";

    public static IPath getFullTestDataPath(String dataPath) {
        try {
            URL url;
            String testDataPath = "TestData/ClasspathDependencyTests/" + dataPath;
            HeadlessTestsPlugin plugin = HeadlessTestsPlugin.getDefault();
            if (plugin != null && (url = plugin.getBundle().getEntry(testDataPath)) != null) {
                url = Platform.asLocalURL((URL)url);
                return new Path(url.getPath());
            }
            return new Path(String.valueOf(System.getProperty("user.dir")) + '/' + testDataPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Path("");
        }
    }

    public static IClasspathEntry addLibraryEntry(IJavaProject javaProject, IPath path, boolean isExported) throws CoreException {
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)isExported);
        ClasspathDependencyTestUtil.addEntryToCP(javaProject, entry);
        return entry;
    }

    public static void addEntryToCP(IJavaProject javaProject, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] rawCP = javaProject.getRawClasspath();
        IClasspathEntry[] newCP = new IClasspathEntry[rawCP.length + 1];
        System.arraycopy(rawCP, 0, newCP, 0, rawCP.length);
        newCP[rawCP.length] = entry;
        javaProject.setRawClasspath(newCP, true, null);
    }

    public static IClasspathEntry addCustomClasspathContainer(IJavaProject javaProject) throws CoreException {
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)CUSTOM_CLASSPATH_CONTAINER, (boolean)true);
        ClasspathDependencyTestUtil.addEntryToCP(javaProject, entry);
        JavaCore.setClasspathContainer((IPath)CUSTOM_CLASSPATH_CONTAINER, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{new IClasspathContainer(){

            public IClasspathEntry[] getClasspathEntries() {
                return new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)TEST1_JAR_PATH, null, null, (boolean)false), JavaCore.newLibraryEntry((IPath)TEST2_JAR_PATH, null, null, (boolean)false)};
            }

            public String getDescription() {
                return "Test classpath container";
            }

            public int getKind() {
                return 1;
            }

            public IPath getPath() {
                return CUSTOM_CLASSPATH_CONTAINER;
            }
        }}, null);
        return entry;
    }

    public static void verifyNoClasspathAttributes(IJavaProject javaProject) throws Exception {
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, new HashSet());
    }

    public static Map verifyClasspathAttributes(IJavaProject javaProject, Set rawEntryPaths) throws Exception {
        Map entriesToAttrib = ClasspathDependencyUtil.getRawComponentClasspathDependencies((IJavaProject)javaProject);
        Assert.assertTrue((String)("Project " + javaProject + " should have " + rawEntryPaths.size() + " raw classpath dependencies, only has: " + entriesToAttrib.size()), (entriesToAttrib.size() == rawEntryPaths.size() ? 1 : 0) != 0);
        for (IClasspathEntry entry : entriesToAttrib.keySet()) {
            Assert.assertTrue((String)("Project " + javaProject + " missing expected classpath dependency " + entry.getPath()), (boolean)rawEntryPaths.contains(entry.getPath()));
        }
        return entriesToAttrib;
    }

    public static void verifyNoClasspathDependencies(IVirtualComponent component) throws Exception {
        ClasspathDependencyTestUtil.verifyClasspathDependencies(component, new HashSet());
    }

    public static IVirtualReference[] verifyClasspathDependencies(IVirtualComponent component, Set archiveNames) throws Exception {
        Assert.assertTrue((String)("Component " + component.getName() + " not a J2EEModuleVirtualComponent"), (boolean)(component instanceof J2EEModuleVirtualComponent));
        J2EEModuleVirtualComponent j2eeComp = (J2EEModuleVirtualComponent)component;
        IVirtualReference[] refs = j2eeComp.getJavaClasspathReferences();
        Assert.assertTrue((String)("Component " + component.getName() + " should have " + archiveNames.size() + " component classpath dependencies, only has: " + refs.length), (refs.length == archiveNames.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < refs.length) {
            Assert.assertTrue((String)("Component " + component.getName() + " has unexpected component classpath dependency " + refs[i].getArchiveName()), (boolean)archiveNames.contains(refs[i].getArchiveName()));
            ++i;
        }
        return refs;
    }

    public static void verifyNoPotentialClasspathEntries(IJavaProject javaProject) throws Exception {
        ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(javaProject, new HashSet());
    }

    public static List verifyPotentialClasspathEntries(IJavaProject javaProject, Set potentialEntryPaths) throws Exception {
        List entries = ClasspathDependencyUtil.getPotentialComponentClasspathDependencies((IJavaProject)javaProject);
        Assert.assertTrue((String)("Project " + javaProject + " should have " + potentialEntryPaths.size() + " potential classpath dependencies, only has: " + entries.size()), (entries.size() == potentialEntryPaths.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < entries.size()) {
            IClasspathEntry entry = (IClasspathEntry)entries.get(i);
            Assert.assertTrue((String)("Project " + javaProject + " missing expected potential classpath entry " + entry.getPath()), (boolean)potentialEntryPaths.contains(entry.getPath()));
            ++i;
        }
        return entries;
    }

    public static void verifyValidationError(IProject project) throws CoreException {
        ClasspathDependencyTestUtil.verifyError(project, VALIDATION_MARKER_TYPE, true);
    }

    public static void verifyNoValidationError(IProject project) throws CoreException {
        ClasspathDependencyTestUtil.verifyError(project, VALIDATION_MARKER_TYPE, false);
    }

    public static void verifyClasspathDependencyError(IProject project) throws CoreException {
        ClasspathDependencyTestUtil.verifyError(project, CLASSPATH_DEPENDENCY_MARKER_TYPE, true);
    }

    public static void verifyNoClasspathDependencyError(IProject project) throws CoreException {
        ClasspathDependencyTestUtil.verifyError(project, CLASSPATH_DEPENDENCY_MARKER_TYPE, false);
    }

    private static void verifyError(IProject project, String markerType, boolean shouldHaveErrorMarker) throws CoreException {
        IMarker[] markers = project.findMarkers(markerType, true, 0);
        boolean hasError = false;
        int i = 0;
        while (i < markers.length) {
            if (markers[i].getAttribute("severity", 0) == 2) {
                hasError = true;
                break;
            }
            ++i;
        }
        if (shouldHaveErrorMarker) {
            Assert.assertTrue((String)("Project " + project + " missing expected validation error problem marker"), (boolean)hasError);
        } else {
            Assert.assertFalse((String)("Project " + project + " has unexpected validation error problem marker"), (boolean)hasError);
        }
    }

    public static void verifyClasspathDependencyMarker(IProject project) throws CoreException {
        ClasspathDependencyTestUtil.verifyMarker(project, CLASSPATH_DEPENDENCY_MARKER_TYPE, true);
    }

    public static void verifyNoClasspathDependencyMarker(IProject project) throws CoreException {
        ClasspathDependencyTestUtil.verifyMarker(project, CLASSPATH_DEPENDENCY_MARKER_TYPE, false);
    }

    private static void verifyMarker(IProject project, String markerType, boolean shouldHaveMarker) throws CoreException {
        IMarker[] markers = project.findMarkers(markerType, true, 0);
        if (shouldHaveMarker) {
            Assert.assertTrue((String)("Project " + project + " missing expected " + markerType + " problem marker"), (markers.length > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertFalse((String)("Project " + project + " has unexpected " + markerType + " problem marker"), (markers.length > 0 ? 1 : 0) != 0);
        }
    }
}

