/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers;

import java.io.File;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.AssertWarn;
import org.eclipse.wst.common.tests.DataModelVerifier;

public abstract class JEEExportDataModelVerifier
extends DataModelVerifier {
    protected IDataModel model = null;

    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.model = model;
        this.verifyArchiveExists();
        this.verifyArchiveTypeAndVersion();
    }

    protected abstract int getExportType();

    private void verifyArchiveExists() {
        String archivePath = this.model.getStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
        File archive = new File(archivePath);
        Assert.assertTrue((String)"The exported archive must exist.", (boolean)archive.exists());
    }

    public static boolean isEE5WithoutDD(IProject project) throws Exception {
        String sProjVersion = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project);
        J2EEVersionUtil.convertVersionStringToInt((String)sProjVersion);
        IArchive projectArchive = null;
        try {
            projectArchive = JavaEEArchiveUtilities.INSTANCE.openArchive(ComponentCore.createComponent((IProject)project));
            JavaEEQuickPeek archiveQuickPeek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(projectArchive);
            if (archiveQuickPeek.getJavaEEVersion() == 50) {
                boolean hasDD = false;
                switch (archiveQuickPeek.getType()) {
                    case 3: {
                        hasDD = projectArchive.containsArchiveResource((IPath)new Path("META-INF/application-client.xml"));
                        break;
                    }
                    case 1: {
                        hasDD = projectArchive.containsArchiveResource((IPath)new Path("META-INF/application.xml"));
                        break;
                    }
                    case 0: {
                        hasDD = projectArchive.containsArchiveResource((IPath)new Path("META-INF/ejb-jar.xml"));
                        break;
                    }
                    case 4: {
                        hasDD = projectArchive.containsArchiveResource((IPath)new Path("WEB-INF/web.xml"));
                    }
                }
                if (!hasDD) {
                    System.err.println("TODO -- NO DD import support needs to be implemented.");
                    System.err.println("     -- see https://bugs.eclipse.org/bugs/show_bug.cgi?id=194679");
                    return true;
                }
            }
        }
        finally {
            if (projectArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(projectArchive);
            }
        }
        return false;
    }

    private void verifyArchiveTypeAndVersion() throws Exception {
        String projName = this.model.getStringProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
        IProject exportedProj = ProjectUtilities.getProject((String)projName);
        IArchive projectArchive = null;
        try {
            projectArchive = JavaEEArchiveUtilities.INSTANCE.openArchive(ComponentCore.createComponent((IProject)exportedProj));
            JavaEEQuickPeek archiveQuickPeek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(projectArchive);
            int type = archiveQuickPeek.getType();
            AssertWarn.warnEquals((String)"Archive type did not match exported type", (int)this.getExportType(), (int)type);
        }
        finally {
            if (projectArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(projectArchive);
            }
        }
        boolean isEE5_withoutDD = JEEExportDataModelVerifier.isEE5WithoutDD(exportedProj);
        if (!isEE5_withoutDD) {
            String archivePath = this.model.getStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
            IArchive zipArchive = null;
            try {
                zipArchive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(archivePath));
                JavaEEQuickPeek archiveQuickPeek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(zipArchive);
                int type = archiveQuickPeek.getType();
                AssertWarn.warnEquals((String)"Archive type did not match exported type", (int)this.getExportType(), (int)type);
                int iVersionConstant = archiveQuickPeek.getVersion();
                String sProjVersion = J2EEProjectUtilities.getJ2EEDDProjectVersion((IProject)exportedProj);
                int iProjVersion = J2EEVersionUtil.convertVersionStringToInt((String)sProjVersion);
                AssertWarn.warnEquals((String)"Archive version did not match exported project version", (int)iProjVersion, (int)iVersionConstant);
            }
            finally {
                if (zipArchive != null) {
                    JavaEEArchiveUtilities.INSTANCE.closeArchive(zipArchive);
                }
            }
        }
    }
}

