/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryregistry;

import java.io.File;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;

public class ArchiveFileTestCases
extends TestCase {
    private String path4TestFiles;
    private String[] archivefiles = new String[]{"faces-all-bogus.jar", "faces-api-bogus.jar", "faces-impl-bogus.jar", "tomahawk-bogus.jar"};

    public ArchiveFileTestCases(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.path4TestFiles = String.valueOf(TestsPlugin.getInstallLocation().getPath()) + "testfiles/";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testArchiveFile() {
        JSFLibrary jsfLib = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        jsfLib.setName("Myfaces");
        ArchiveFile archiveFile = null;
        int subStrEnd = this.path4TestFiles.length() - 1;
        int i = 0;
        while (i < this.archivefiles.length) {
            String testData = String.valueOf(this.path4TestFiles) + this.archivefiles[i];
            archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
            archiveFile.setRelativeToWorkspace(false);
            archiveFile.setSourceLocation(testData);
            Assert.assertEquals((String)testData, (String)archiveFile.getSourceLocation());
            Assert.assertEquals((String)this.path4TestFiles.substring(0, subStrEnd), (String)archiveFile.getPath());
            Assert.assertEquals((String)this.archivefiles[i], (String)archiveFile.getName());
            Assert.assertTrue((boolean)archiveFile.exists());
            archiveFile.setJSFLibrary(jsfLib);
            Assert.assertEquals((Object)jsfLib, (Object)archiveFile.getJSFLibrary());
            ++i;
        }
        Assert.assertEquals((int)this.archivefiles.length, (int)jsfLib.getArchiveFiles().size());
    }

    public void testsetSourceLocation() {
        ArchiveFile archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        Assert.assertNotNull((Object)archiveFile);
        archiveFile.setRelativeToWorkspace(false);
        String testData = "c:\\test\\archivefiles";
        archiveFile.setSourceLocation(testData);
        Assert.assertEquals((String)testData, (String)archiveFile.getSourceLocation());
        archiveFile.setRelativeToWorkspace(true);
        IWorkspaceRoot wsRoot = this.getWorkspaceRoot();
        IPath wsRootPath = wsRoot.getLocation();
        testData = "archivefiles";
        archiveFile.setSourceLocation(String.valueOf(wsRootPath.toOSString()) + File.separator + testData);
        Assert.assertEquals((String)testData, (String)archiveFile.getSourceLocation());
    }

    public void testgetPath() {
        ArchiveFile archiveFile = null;
        String testData = String.valueOf(this.path4TestFiles) + this.archivefiles[this.archivefiles.length - 1];
        archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        archiveFile.setRelativeToWorkspace(false);
        archiveFile.setSourceLocation(testData);
        archiveFile.setRelativeToWorkspace(true);
        IWorkspaceRoot wsRoot = this.getWorkspaceRoot();
        IPath wsRootPath = wsRoot.getLocation();
        testData = "test.jar";
        archiveFile.setSourceLocation(String.valueOf(wsRootPath.toOSString()) + File.separator + testData);
        Path arPath = new Path(archiveFile.getPath());
        Assert.assertEquals((Object)wsRootPath, (Object)arPath);
    }

    public void testgetName() {
        ArchiveFile archiveFile = null;
        String testData = String.valueOf(this.path4TestFiles) + this.archivefiles[this.archivefiles.length - 1];
        archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        archiveFile.setRelativeToWorkspace(false);
        archiveFile.setSourceLocation(testData);
        Assert.assertEquals((String)this.archivefiles[this.archivefiles.length - 1], (String)archiveFile.getName());
        archiveFile.setRelativeToWorkspace(true);
        IWorkspaceRoot wsRoot = this.getWorkspaceRoot();
        IPath wsRootPath = wsRoot.getLocation();
        testData = "test.jar";
        archiveFile.setSourceLocation(String.valueOf(wsRootPath.toOSString()) + File.separator + testData);
        Assert.assertEquals((String)testData, (String)archiveFile.getName());
    }

    public void testexists() {
        ArchiveFile archiveFile = null;
        String testData = String.valueOf(this.path4TestFiles) + this.archivefiles[this.archivefiles.length - 1];
        archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        archiveFile.setRelativeToWorkspace(false);
        archiveFile.setSourceLocation(testData);
        Assert.assertTrue((boolean)archiveFile.exists());
        archiveFile.setRelativeToWorkspace(true);
        IWorkspaceRoot wsRoot = this.getWorkspaceRoot();
        IPath wsRootPath = wsRoot.getLocation();
        testData = "test.jar";
        archiveFile.setSourceLocation(String.valueOf(wsRootPath.toOSString()) + File.separator + testData);
        Assert.assertFalse((boolean)archiveFile.exists());
    }

    public void testequals() {
        ArchiveFile archiveFile_01 = null;
        ArchiveFile archiveFile_02 = null;
        String testData = String.valueOf(this.path4TestFiles) + this.archivefiles[this.archivefiles.length - 1];
        archiveFile_01 = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        archiveFile_01.setRelativeToWorkspace(false);
        archiveFile_01.setSourceLocation(testData);
        archiveFile_02 = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        archiveFile_02.setRelativeToWorkspace(false);
        archiveFile_02.setSourceLocation(testData);
        Assert.assertEquals((Object)archiveFile_01, (Object)archiveFile_02);
        archiveFile_01.setRelativeToWorkspace(true);
        IWorkspaceRoot wsRoot = this.getWorkspaceRoot();
        IPath wsRootPath = wsRoot.getLocation();
        testData = "test.jar";
        archiveFile_01.setSourceLocation(String.valueOf(wsRootPath.toOSString()) + File.separator + testData);
        Assert.assertFalse((boolean)archiveFile_01.equals((Object)archiveFile_02));
    }

    public void testcopyTo() {
        ArchiveFile archiveFile = null;
        String testData = String.valueOf(this.path4TestFiles) + this.archivefiles[0];
        archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        archiveFile.setRelativeToWorkspace(false);
        archiveFile.setSourceLocation(testData);
        IWorkspaceRoot wsRoot = this.getWorkspaceRoot();
        IPath wsRootPath = wsRoot.getLocation();
        boolean copied = archiveFile.copyTo(wsRootPath.toOSString());
        Assert.assertTrue((boolean)copied);
        File fileCopied = new File(String.valueOf(wsRootPath.toOSString()) + File.separator + this.archivefiles[0]);
        Assert.assertTrue((boolean)fileCopied.exists());
        Assert.assertFalse((boolean)archiveFile.copyTo(wsRootPath.toOSString()));
        fileCopied.deleteOnExit();
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace != null ? workspace.getRoot() : null;
    }
}

