/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.progress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.IClazzVisitor;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ClassUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPIEmitter;
import org.eclipse.wtp.releng.tools.component.api.ComponentUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentUseEmitter;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodUse;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.api.TestCoverage;
import org.eclipse.wtp.releng.tools.component.api.progress.APITestCoverageSummary;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentEntry;
import org.eclipse.wtp.releng.tools.component.internal.ComponentSummary;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class APITestCoverageEmitter
extends AbstractEmitter {
    public static final String OPTION_ECLIPSE_DIR = "eclipseDir";
    public static final String OPTION_TEST_DIR = "testDir";
    public static final String OPTION_COMPONENT_XML_DIR = "compXMLDir";
    public static final String OPTION_COMPONENT_API_DIR = "compAPIDir";
    public static final String OPTION_API_AGENT_OUTPUT = "apiAgentOutput";
    public static final String OPTION_TIMESTAMP = "timestamp";
    public static final String OPTION_GEN_HTML = "genHTML";
    private String compAPIDir;
    private Map id2Plugin;
    private Map id2Fragment;
    private Map id2TestPlugin;
    private Map id2TestFragment;
    private Map compLoc2CompXML;
    private String apiAgentOutput;
    private List apiAgentMethodrefs;
    private String timestamp;
    private boolean genHTML;
    private ComponentAPIEmitter compAPIEmitter;

    public APITestCoverageEmitter(String compAPIDir) {
        this.compAPIDir = this.addTrailingSeperator(compAPIDir);
        this.genHTML = false;
    }

    public void init(List eclipseDirs, List testDirs, List compXMLDirs) {
        this.id2Plugin = new HashMap();
        this.id2Fragment = new HashMap();
        Iterator it = eclipseDirs.iterator();
        while (it.hasNext()) {
            File eclipseFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!eclipseFile.exists()) continue;
            this.harvestPlugins(eclipseFile, this.id2Plugin, this.id2Fragment);
        }
        this.linkPluginsAndFragments(this.id2Plugin, this.id2Fragment);
        this.id2TestPlugin = new HashMap();
        this.id2TestFragment = new HashMap();
        it = testDirs.iterator();
        while (it.hasNext()) {
            File testFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!testFile.exists()) continue;
            this.harvestPlugins(testFile, this.id2TestPlugin, this.id2TestFragment);
        }
        this.linkPluginsAndFragments(this.id2TestPlugin, this.id2TestFragment);
        this.compLoc2CompXML = new HashMap();
        it = compXMLDirs.iterator();
        while (it.hasNext()) {
            File compXMLFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!compXMLFile.exists()) continue;
            this.harvestComponents(compXMLFile, this.compLoc2CompXML);
        }
        this.init();
    }

    public void init(Map compLoc2CompXML, Map id2Plugin, Map id2Fragment, Map id2TestPlugin, Map id2TestFragment) {
        this.compLoc2CompXML = compLoc2CompXML;
        this.id2Plugin = id2Plugin;
        this.id2Fragment = id2Fragment;
        this.id2TestPlugin = id2TestPlugin;
        this.id2TestFragment = id2TestFragment;
        this.init();
    }

    private void init() {
        this.compAPIEmitter = new ComponentAPIEmitter(null);
        if (this.timestamp != null) {
            this.compAPIEmitter.setTimestamp(this.timestamp);
        } else {
            this.timestamp = this.compAPIEmitter.getTimestamp();
        }
        this.compAPIEmitter.init(this.compLoc2CompXML, this.id2Plugin, this.id2Fragment);
    }

    public String getAPIAgentOutput() {
        return this.apiAgentOutput;
    }

    public void setAPIAgentOutput(String apiAgentOutput) {
        this.apiAgentOutput = apiAgentOutput;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isGenHTML() {
        return this.genHTML;
    }

    public void setGenHTML(boolean genHTML) {
        this.genHTML = genHTML;
    }

    protected String getComponentSummaryXML() {
        return "index-comp-summary.xml";
    }

    protected String getSummaryXML() {
        return "index-api-tc.xml";
    }

    protected String getSummaryHTML() {
        return "index-api-tc.html";
    }

    protected String getSummaryXSL() {
        return "org/eclipse/wtp/releng/tools/component/xsl/component-api-tc-summary.xsl";
    }

    protected String getCoverageXML() {
        return "component-api.xml";
    }

    protected String getCoverageHTML() {
        return "component-api-tc.html";
    }

    protected String getCoverageXSL() {
        return "org/eclipse/wtp/releng/tools/component/xsl/component-api-tc.xsl";
    }

    public void genAPITestCoverageXML() throws IOException {
        ComponentSummary compSummary = new ComponentSummary();
        APITestCoverageSummary summary = new APITestCoverageSummary(this.getCoverageHTML());
        compSummary.setTimestamp(this.timestamp);
        summary.setTimestamp(this.timestamp);
        ArrayList includes = new ArrayList();
        Iterator it = this.compLoc2CompXML.values().iterator();
        while (it.hasNext()) {
            this.harvestPackages((ComponentXML)it.next(), includes);
        }
        ComponentUseEmitter compUseEmitter = this.newComponentUseEmitter(this.id2TestPlugin, this.id2TestFragment, includes);
        ComponentUse compUse = compUseEmitter.genAll();
        Iterator it2 = this.compLoc2CompXML.keySet().iterator();
        while (it2.hasNext()) {
            String compLoc = (String)it2.next();
            ComponentAPI compAPI = this.compAPIEmitter.genComponentApiXml(compLoc);
            summary.add(this.genAPITestCoverageXML(compLoc, compUse, compAPI));
            ComponentEntry entry = new ComponentEntry();
            entry.setCompName(compAPI.getName());
            entry.setRef(compAPI.getLocation().getAbsolutePath());
            compSummary.add(entry);
        }
        if (this.compAPIDir != null) {
            compSummary.save(new FileLocation(new File(String.valueOf(this.compAPIDir) + this.getComponentSummaryXML())));
            summary.save(new FileLocation(new File(String.valueOf(this.compAPIDir) + this.getSummaryXML())));
            if (this.genHTML) {
                try {
                    summary.saveAsHTML(this.getSummaryXSL(), new FileLocation(new File(String.valueOf(this.compAPIDir) + this.getSummaryHTML())));
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ComponentAPI genAPITestCoverageXML(String compLoc) throws IOException {
        ArrayList includes = new ArrayList();
        ComponentXML componentXML = (ComponentXML)this.compLoc2CompXML.get(compLoc);
        if (componentXML != null) {
            this.harvestPackages(componentXML, includes);
        }
        ComponentUseEmitter compUseEmitter = this.newComponentUseEmitter(this.id2TestPlugin, this.id2TestFragment, includes);
        ComponentUse compUse = compUseEmitter.genAll();
        ComponentAPI compAPI = this.compAPIEmitter.genComponentApiXml(compLoc);
        compAPI.save();
        return this.genAPITestCoverageXML(compLoc, compUse, compAPI);
    }

    private ComponentAPI genAPITestCoverageXML(String compLoc, ComponentUse compUse, ComponentAPI compAPI) throws IOException {
        ComponentXML componentXML = (ComponentXML)this.compLoc2CompXML.get(compLoc);
        if (componentXML != null) {
            Iterator it;
            componentXML.load();
            final Hashtable interface2implClasses = new Hashtable();
            if (this.apiAgentOutput != null) {
                it = componentXML.getPlugins().iterator();
                while (it.hasNext()) {
                    String pluginId = ((Plugin)it.next()).getId();
                    IPluginXML plugin = (IPluginXML)this.id2Plugin.get(pluginId);
                    if (plugin == null) continue;
                    plugin.accept(new IClazzVisitor(){

                        public boolean visit(IClazz clazz) {
                            String[] interfaces = clazz.getInterfaces();
                            int i = 0;
                            while (i < interfaces.length) {
                                StringBuffer sb = new StringBuffer();
                                String implClasses = (String)interface2implClasses.get(interfaces[i]);
                                if (implClasses != null) {
                                    sb.append(implClasses);
                                }
                                sb.append(clazz.getName());
                                sb.append('#');
                                interface2implClasses.put(interfaces[i], sb.toString());
                                ++i;
                            }
                            return true;
                        }
                    });
                }
            }
            it = compAPI.getPackageAPIs().iterator();
            while (it.hasNext()) {
                PackageAPI pkgAPI = (PackageAPI)it.next();
                Iterator it2 = pkgAPI.getClassAPIs().iterator();
                while (it2.hasNext()) {
                    ClassAPI classAPI = (ClassAPI)it2.next();
                    int classAccess = classAPI.getAccess();
                    if (!this.isBit(classAccess, 1) && !this.isBit(classAccess, 4) || !classAPI.isReference()) continue;
                    Iterator it3 = classAPI.getMethodAPIs().iterator();
                    while (it3.hasNext()) {
                        MethodAPI methodAPI = (MethodAPI)it3.next();
                        methodAPI.setTestCoverage(this.getTestCoverage(compUse, classAPI.getName(), methodAPI, interface2implClasses));
                    }
                }
            }
            if (this.compAPIDir != null) {
                String compName = componentXML.getName();
                StringBuffer sb = new StringBuffer(this.compAPIDir);
                sb.append(compName);
                sb.append('/');
                FileLocation location = new FileLocation(new File(String.valueOf(sb.toString()) + this.getCoverageXML()));
                compAPI.setLocation(location);
                System.out.println("Writing " + this.getCoverageXML() + " for " + compName);
                compAPI.save();
                if (this.genHTML) {
                    try {
                        FileLocation html = new FileLocation(new File(String.valueOf(sb.toString()) + this.getCoverageHTML()));
                        compAPI.saveAsHTML(html, this.getCoverageXSL());
                        this.copyImages();
                    }
                    catch (TransformerConfigurationException e) {
                        e.printStackTrace();
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return compAPI;
    }

    private void harvestPackages(ComponentXML compXML, List includes) throws IOException {
        compXML.load();
        Collection pkgs = compXML.getPackages();
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            String pkgName = ((Package)it.next()).getName();
            if (includes.contains(pkgName)) continue;
            includes.add(pkgName);
        }
    }

    private ComponentUseEmitter newComponentUseEmitter(Map plugins, Map fragments, List includes) {
        ComponentUseEmitter compUseEmitter = new ComponentUseEmitter(null);
        compUseEmitter.setDebug(false);
        compUseEmitter.setClassUseIncludes(includes);
        compUseEmitter.init(new HashMap(0), plugins, fragments);
        return compUseEmitter;
    }

    private boolean isBit(int flag, int bit) {
        return (flag & bit) == bit;
    }

    private TestCoverage getTestCoverage(ComponentUse compUse, String className, MethodAPI methodAPI, Hashtable interface2implClasses) {
        ArrayList<String> testcases = new ArrayList<String>();
        Iterator sourcesIt = compUse.getSources().iterator();
        while (sourcesIt.hasNext()) {
            Source source = (Source)sourcesIt.next();
            Iterator classUsesIt = source.getClassUses().iterator();
            while (classUsesIt.hasNext()) {
                ClassUse classUse = (ClassUse)classUsesIt.next();
                if (!classUse.getName().equals(className)) continue;
                Iterator methodUsesIt = classUse.getMethodUses().iterator();
                while (methodUsesIt.hasNext()) {
                    MethodUse methodUse = (MethodUse)methodUsesIt.next();
                    if (!methodUse.getName().equals(methodAPI.getName()) || !methodUse.getDescriptor().equals(methodAPI.getDescriptor())) continue;
                    testcases.add(source.getName());
                }
            }
        }
        if (this.apiAgentOutput != null) {
            String implClasses;
            if (this.apiAgentMethodrefs == null) {
                this.apiAgentMethodrefs = new ArrayList();
                this.getAPIAgentMethodRefs(new File(this.apiAgentOutput), this.apiAgentMethodrefs);
            }
            StringBuffer methodref = new StringBuffer();
            methodref.append('#');
            methodref.append(methodAPI.getName());
            methodref.append('#');
            methodref.append(methodAPI.getDescriptor());
            if (this.apiAgentMethodrefs.contains(String.valueOf(className) + methodref.toString())) {
                testcases.add("apiagent");
            }
            if ((implClasses = (String)interface2implClasses.get(className)) != null) {
                StringTokenizer st = new StringTokenizer(implClasses, "#");
                while (st.hasMoreTokens()) {
                    if (!this.apiAgentMethodrefs.contains(String.valueOf(st.nextToken()) + methodref.toString())) continue;
                    testcases.add("apiagent");
                }
            }
        }
        if (testcases.size() > 0) {
            TestCoverage testCoverage = new TestCoverage();
            testCoverage.addTests(testcases);
            return testCoverage;
        }
        return null;
    }

    private void getAPIAgentMethodRefs(File file, List apiAgentMethodRefs) {
        block5: {
            block6: {
                if (!file.exists()) break block5;
                if (!file.isDirectory()) break block6;
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.getAPIAgentMethodRefs(files[i], apiAgentMethodRefs);
                    ++i;
                }
                break block5;
            }
            if (!file.getName().endsWith(".trcxml")) break block5;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(false);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(new InputSource(new BufferedInputStream(new FileInputStream(file))), (DefaultHandler)new TRCXMLHandler(apiAgentMethodRefs));
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void copyImages() {
        File fail;
        StringBuffer outputDir = new StringBuffer(this.compAPIDir).append('/');
        File ok = new File(String.valueOf(outputDir.toString()) + "OK.gif");
        if (!ok.exists()) {
            try {
                this.copyImage("org/eclipse/wtp/releng/tools/component/images/OK.gif", ok);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(fail = new File(String.valueOf(outputDir.toString()) + "FAIL.gif")).exists()) {
            try {
                this.copyImage("org/eclipse/wtp/releng/tools/component/images/FAIL.gif", fail);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List eclipseDir = (List)options.get(OPTION_ECLIPSE_DIR);
        List testDir = (List)options.get(OPTION_TEST_DIR);
        List compXMLDir = (List)options.get(OPTION_COMPONENT_XML_DIR);
        List compAPIDir = (List)options.get(OPTION_COMPONENT_API_DIR);
        List apiAgentOutput = (List)options.get(OPTION_API_AGENT_OUTPUT);
        List timestamp = (List)options.get(OPTION_TIMESTAMP);
        List genHTML = (List)options.get(OPTION_GEN_HTML);
        if (eclipseDir == null || testDir == null || compXMLDir == null || compAPIDir == null || eclipseDir.size() < 1 || testDir.size() < 1 || compXMLDir.size() < 1 || compAPIDir.size() < 1) {
            APITestCoverageEmitter.printUsage();
            System.exit(-1);
        }
        APITestCoverageEmitter apiTestCoverageEmitter = new APITestCoverageEmitter((String)compAPIDir.get(0));
        if (apiAgentOutput != null && apiAgentOutput.size() > 0) {
            apiTestCoverageEmitter.setAPIAgentOutput((String)apiAgentOutput.get(0));
        }
        if (timestamp != null && timestamp.size() > 0) {
            apiTestCoverageEmitter.setTimestamp((String)timestamp.get(0));
        }
        apiTestCoverageEmitter.setGenHTML(genHTML != null);
        apiTestCoverageEmitter.init(eclipseDir, testDir, compXMLDir);
        try {
            apiTestCoverageEmitter.genAPITestCoverageXML();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.api.testcoverage.APITestCoverageEmitter -eclipseDir <eclipseDir> -testDir <testDir> -compXMLDir <compXMLDir> -compAPIDir <compAPIDir> [-options]");
        System.out.println("");
        System.out.println("\t-eclipseDir\t<eclipseDir>\tspace seperated list of directories containing Eclipse plugins");
        System.out.println("\t-testDir\t<testDir>\tspace separated list of directories containing test plugins");
        System.out.println("\t-compXMLDir\t<compXMLDir>\tdirectories containing component.xml that will be checked for API test coverage");
        System.out.println("\t-compAPIDir\t<compVioDir>\toutput directory of component-api-tc.xml");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-apiAgentOutput\tdirectory containing output from the PI Agent");
        System.out.println("\t-timestamp\ttimestamp");
        System.out.println("\t-genHTML\tgenerate test coverage report in HTML");
    }

    private class TRCXMLHandler
    extends DefaultHandler {
        private Map classRefs = new HashMap();
        private List methodRefs;

        public TRCXMLHandler(List methodRefs) {
            this.methodRefs = methodRefs;
        }

        public void startElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
            String signature;
            String methodName;
            String className;
            String classId;
            if (elementName.equals("classDef") || qName.equals("classDef")) {
                String id = attributes.getValue("classId");
                String name = attributes.getValue("name");
                if (id != null && name != null) {
                    this.classRefs.put(id, name);
                }
            } else if ((elementName.equals("methodDef") || qName.equals("methodDef")) && (classId = attributes.getValue("classIdRef")) != null && (className = (String)this.classRefs.get(classId)) != null && (methodName = attributes.getValue("name")) != null & (signature = attributes.getValue("signature")) != null) {
                if (methodName.equals("-init-")) {
                    methodName = "&lt;init>";
                } else if (methodName.equals("-clinit-")) {
                    methodName = "&lt;clinit>";
                }
                StringBuffer sb = new StringBuffer();
                sb.append(className);
                sb.append("#");
                sb.append(methodName);
                sb.append("#");
                sb.append(signature);
                this.methodRefs.add(sb.toString());
            }
        }
    }
}

