/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.tasks.IFileTaskScanner;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.internal.tasks.FileTaskScannerRegistryReader;
import org.eclipse.wst.sse.core.utils.StringUtils;

class WorkspaceTaskScanner {
    private static WorkspaceTaskScanner _instance = null;
    final String DEFAULT_MARKER_TYPE = "org.eclipse.wst.sse.core.task";
    private List fActiveScanners = null;
    private IContentType[] fCurrentIgnoreContentTypes = null;
    private TaskTag[] fCurrentTaskTags = null;
    private FileTaskScannerRegistryReader registry = FileTaskScannerRegistryReader.getInstance();
    private long time0;

    static synchronized WorkspaceTaskScanner getInstance() {
        if (_instance == null) {
            _instance = new WorkspaceTaskScanner();
        }
        return _instance;
    }

    private WorkspaceTaskScanner() {
        this.fActiveScanners = new ArrayList();
        this.fCurrentTaskTags = new TaskTag[0];
        this.fCurrentIgnoreContentTypes = new IContentType[0];
    }

    private IContentType[] detectContentTypes(IResource resource) {
        IContentType[] types = null;
        if (resource.getType() == 1 && resource.isAccessible()) {
            types = Platform.getContentTypeManager().findContentTypesFor(resource.getName());
            if (types.length == 0) {
                IContentDescription d = null;
                try {
                    d = ((IFile)resource).getContentDescription();
                    if (d != null) {
                        types = new IContentType[]{d.getContentType()};
                    }
                }
                catch (CoreException coreException) {}
            }
            if (types == null) {
                types = Platform.getContentTypeManager().findContentTypesFor(resource.getName());
            }
            if (Logger.DEBUG_TASKSCONTENTTYPE && types.length > 0) {
                if (types.length > 1) {
                    System.out.println(resource.getFullPath() + ": " + "multiple based on name (probably hierarchical)");
                }
                int i = 0;
                while (i < types.length) {
                    System.out.println(resource.getFullPath() + " matched: " + types[i].getId());
                    ++i;
                }
            }
        }
        return types;
    }

    private IProject getProject(IResource resource) {
        IProject project = null;
        project = resource.getType() == 4 ? (IProject)resource : resource.getProject();
        return project;
    }

    private boolean init(IResource resource) {
        IProject project = this.getProject(resource);
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IScopeContext[] lookupOrder = new IScopeContext[]{new ProjectScope(project), new InstanceScope(), new DefaultScope()};
        boolean proceed = preferencesService.getBoolean("org.eclipse.wst.sse.core/task-tags", "enabled", false, lookupOrder);
        if (Logger.DEBUG_TASKSPREFS) {
            System.out.println(String.valueOf(this.getClass().getName()) + " scan of " + resource.getFullPath() + ":" + proceed);
        }
        if (proceed) {
            String[] tags = StringUtils.unpack(preferencesService.getString("org.eclipse.wst.sse.core/task-tags", "taskTags", null, lookupOrder));
            String[] priorities = StringUtils.unpack(preferencesService.getString("org.eclipse.wst.sse.core/task-tags", "taskPriorities", null, lookupOrder));
            String[] currentIgnoreContentTypeIDs = StringUtils.unpack(preferencesService.getString("org.eclipse.wst.sse.core/task-tags", "ignored-contentTypes", null, lookupOrder));
            if (Logger.DEBUG_TASKSPREFS) {
                System.out.print(String.valueOf(this.getClass().getName()) + " tags: ");
                int i = 0;
                while (i < tags.length) {
                    if (i > 0) {
                        System.out.print(",");
                    }
                    System.out.print(tags[i]);
                    ++i;
                }
                System.out.println();
                System.out.print(String.valueOf(this.getClass().getName()) + " priorities: ");
                i = 0;
                while (i < priorities.length) {
                    if (i > 0) {
                        System.out.print(",");
                    }
                    System.out.print(priorities[i]);
                    ++i;
                }
                System.out.println();
                System.out.print(String.valueOf(this.getClass().getName()) + " ignored content types: ");
                i = 0;
                while (i < currentIgnoreContentTypeIDs.length) {
                    if (i > 0) {
                        System.out.print(",");
                    }
                    System.out.print(currentIgnoreContentTypeIDs[i]);
                    ++i;
                }
                System.out.println();
            }
            this.fCurrentIgnoreContentTypes = new IContentType[currentIgnoreContentTypeIDs.length];
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            int i = 0;
            while (i < currentIgnoreContentTypeIDs.length) {
                this.fCurrentIgnoreContentTypes[i] = contentTypeManager.getContentType(currentIgnoreContentTypeIDs[i]);
                ++i;
            }
            int max = Math.min(tags.length, priorities.length);
            this.fCurrentTaskTags = new TaskTag[max];
            int i2 = 0;
            while (i2 < max) {
                int priority = 1;
                try {
                    priority = Integer.parseInt(priorities[i2]);
                }
                catch (NumberFormatException numberFormatException) {}
                this.fCurrentTaskTags[i2] = new TaskTag(tags[i2], priority);
                ++i2;
            }
        }
        return proceed;
    }

    void internalScan(IProject project, IResource resource, IProgressMonitor scanMonitor) {
        if (scanMonitor.isCanceled()) {
            return;
        }
        try {
            String name = resource.getName();
            if (resource.isAccessible() && !resource.isDerived() && !resource.isPhantom() && !resource.isTeamPrivateMember() && name.length() != 0 && name.charAt(0) != '.') {
                if ((resource.getType() & 2) > 0 || (resource.getType() & 4) > 0) {
                    IResource[] children = ((IContainer)resource).members();
                    scanMonitor.beginTask("", children.length);
                    int i = 0;
                    while (i < children.length) {
                        this.internalScan(project, children[i], (IProgressMonitor)new SubProgressMonitor(scanMonitor, 1, 4));
                        ++i;
                    }
                    scanMonitor.done();
                } else if ((resource.getType() & 1) > 0) {
                    this.scanFile(project, this.fCurrentTaskTags, (IFile)resource, scanMonitor);
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    void internalScan(IResourceDelta delta, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String name = delta.getFullPath().lastSegment();
            IResource resource = delta.getResource();
            if (!(resource.isDerived() || resource.isPhantom() || resource.isTeamPrivateMember() || name.length() == 0 || name.charAt(0) == '.')) {
                if ((resource.getType() & 2) > 0 || (resource.getType() & 4) > 0) {
                    IResourceDelta[] children = delta.getAffectedChildren();
                    monitor.beginTask("", children.length);
                    if (name.length() != 0 && name.charAt(0) != '.' && children.length > 0) {
                        int i = children.length - 1;
                        while (i >= 0) {
                            this.internalScan(children[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                            --i;
                        }
                    }
                    monitor.done();
                } else if ((resource.getType() & 1) > 0 && ((delta.getKind() & 1) > 0 || (delta.getKind() & 4) > 0 && (delta.getFlags() & 0x100) > 0)) {
                    IFile file = (IFile)resource;
                    this.scanFile(file.getProject(), this.fCurrentTaskTags, file, monitor);
                }
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private void replaceTaskMarkers(final IFile file, final Map[] markerAttributes, IProgressMonitor monitor) {
        final IFile finalFile = file;
        if (file.isAccessible()) {
            try {
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        try {
                            file.deleteMarkers("org.eclipse.wst.sse.core.task", true, 0);
                        }
                        catch (CoreException e) {
                            Logger.logException("exception deleting old tasks", e);
                        }
                        if (markerAttributes != null && markerAttributes.length > 0) {
                            if (Logger.DEBUG_TASKS) {
                                System.out.println(markerAttributes.length + " tasks for " + file.getFullPath());
                            }
                            int i = 0;
                            while (i < markerAttributes.length) {
                                String specifiedMarkerType = (String)markerAttributes[i].get("org.eclipse.core.resources.taskmarker");
                                IMarker marker = finalFile.createMarker(specifiedMarkerType != null ? specifiedMarkerType : "org.eclipse.wst.sse.core.task");
                                marker.setAttributes(markerAttributes[i]);
                                ++i;
                            }
                        }
                    }
                };
                if (file.isAccessible()) {
                    finalFile.getWorkspace().run(r, (ISchedulingRule)file, 1, monitor);
                }
            }
            catch (CoreException e1) {
                Logger.logException(e1);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    void scan(IProject project, IProgressMonitor scanMonitor) {
        if (scanMonitor.isCanceled()) {
            return;
        }
        if (Logger.DEBUG_TASKS) {
            System.out.println(String.valueOf(this.getClass().getName()) + " scanning project " + project.getName());
        }
        if (!project.isAccessible()) {
            if (Logger.DEBUG_TASKS) {
                System.out.println(String.valueOf(this.getClass().getName()) + " skipping inaccessible project " + project.getName());
            }
            return;
        }
        if (Logger.DEBUG_TASKSOVERALLPERF) {
            this.time0 = System.currentTimeMillis();
        }
        if (this.init((IResource)project)) {
            this.internalScan(project, (IResource)project, scanMonitor);
            this.shutdownDelegates(project);
        } else {
            scanMonitor.done();
        }
        if (Logger.DEBUG_TASKSOVERALLPERF) {
            System.out.println(System.currentTimeMillis() - this.time0 + "ms for " + project.getFullPath());
        }
    }

    void scan(IResourceDelta delta, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (Logger.DEBUG_TASKSOVERALLPERF) {
            this.time0 = System.currentTimeMillis();
        }
        if (this.init(delta.getResource())) {
            this.internalScan(delta, monitor);
            this.shutdownDelegates(delta.getResource().getProject());
        }
        if (Logger.DEBUG_TASKSOVERALLPERF) {
            System.out.println(System.currentTimeMillis() - this.time0 + "ms for " + delta.getFullPath());
        }
    }

    void scanFile(IProject project, TaskTag[] taskTags, IFile file, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask("", 3);
        monitor.subTask(file.getFullPath().toString());
        ArrayList<Map> markerAttributes = null;
        IContentType[] types = this.detectContentTypes((IResource)file);
        monitor.worked(1);
        IFileTaskScanner[] fileScanners = null;
        if (types != null) {
            if (this.fCurrentIgnoreContentTypes.length == 0) {
                fileScanners = this.registry.getFileTaskScanners(types);
            } else {
                ArrayList<IContentType> validTypes = new ArrayList<IContentType>();
                int i = 0;
                while (i < types.length) {
                    boolean ignoreContentType = false;
                    int j = 0;
                    while (j < this.fCurrentIgnoreContentTypes.length) {
                        ignoreContentType = ignoreContentType || types[i].isKindOf(this.fCurrentIgnoreContentTypes[j]);
                        ++j;
                    }
                    if (!ignoreContentType) {
                        validTypes.add(types[i]);
                    }
                    ++i;
                }
                fileScanners = this.registry.getFileTaskScanners(validTypes.toArray(new IContentType[validTypes.size()]));
            }
            if (fileScanners.length > 0) {
                SubProgressMonitor scannerMonitor = new SubProgressMonitor(monitor, 1, 2);
                scannerMonitor.beginTask("", fileScanners.length);
                int j = 0;
                while (fileScanners != null && j < fileScanners.length) {
                    if (!monitor.isCanceled()) {
                        try {
                            if (!this.fActiveScanners.contains(fileScanners[j]) && !monitor.isCanceled()) {
                                fileScanners[j].startup(file.getProject());
                                this.fActiveScanners.add(fileScanners[j]);
                            }
                            Map[] taskMarkerAttributes = fileScanners[j].scan(file, taskTags, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)scannerMonitor, 1, 4));
                            int i = 0;
                            while (i < taskMarkerAttributes.length) {
                                if (markerAttributes == null) {
                                    markerAttributes = new ArrayList<Map>();
                                }
                                markerAttributes.add(taskMarkerAttributes[i]);
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            Logger.logException(file.getFullPath().toString(), e);
                        }
                    }
                    ++j;
                }
                scannerMonitor.done();
            }
        } else {
            monitor.worked(1);
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (fileScanners != null && fileScanners.length > 0) {
            SubProgressMonitor markerUpdateMonitor = new SubProgressMonitor(monitor, 1, 4);
            if (markerAttributes != null) {
                this.replaceTaskMarkers(file, markerAttributes.toArray(new Map[markerAttributes.size()]), (IProgressMonitor)markerUpdateMonitor);
            } else {
                this.replaceTaskMarkers(file, null, (IProgressMonitor)markerUpdateMonitor);
            }
        } else {
            monitor.worked(1);
        }
        monitor.done();
    }

    private void shutdownDelegates(IProject project) {
        int j = 0;
        while (j < this.fActiveScanners.size()) {
            try {
                ((IFileTaskScanner)this.fActiveScanners.get(j)).shutdown(project);
            }
            catch (Exception e) {
                Logger.logException(project.getFullPath().toString(), e);
            }
            ++j;
        }
        this.fActiveScanners = new ArrayList(1);
    }
}

