/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarImpl;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EJBClientJarCreationHelper;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EJBClientJarFileMoveDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.IEjbClientJarCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.InvertClientJARDependencyCompoundOperation;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.UtilityProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EjbClientJarCreationOperation
extends AbstractDataModelOperation
implements IEjbClientJarCreationDataModelProperties {
    private IProgressMonitor monitor = null;

    public EjbClientJarCreationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor aMonitor, IAdaptable info) throws ExecutionException {
        this.monitor = aMonitor;
        IStatus stat = OK_STATUS;
        IProject ejbproject = ProjectUtilities.getProject((String)this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME"));
        if (ejbproject.exists() && ejbproject.isAccessible()) {
            IFacetedProject facetedProject = null;
            IRuntime runtime = null;
            String javaSourceFolder = "";
            boolean canContinue = true;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)ejbproject);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
                canContinue = false;
            }
            if (canContinue) {
                runtime = facetedProject.getRuntime();
                IContainer container = J2EEProjectUtilities.getSourceFolderOrFirst((IProject)ejbproject, null);
                if (container.getType() == 2) {
                    javaSourceFolder = container.getName();
                }
            }
            IProject[] earprojects = J2EEProjectUtilities.getReferencingEARProjects((IProject)ejbproject);
            String projectName = this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new UtilityProjectCreationDataModelProvider());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel javadm = map.getFacetDataModel("jst.java");
            IDataModel utildm = map.getFacetDataModel("jst.utility");
            utildm.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
            javadm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
            javadm.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", (Object)javaSourceFolder);
            utildm.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earprojects[0].getName());
            utildm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
            dm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
            FacetProjectCreationOperation op = new FacetProjectCreationOperation(dm);
            try {
                stat = op.execute(this.monitor, null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            IVirtualComponent c = ComponentCore.createComponent((IProject)ejbproject);
            c.setMetaProperty("ClientProject", projectName);
            String clientURI = this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ");
            c.setMetaProperty("ClientJARURI", clientURI);
            try {
                int i = 0;
                while (i < earprojects.length) {
                    this.runAddClientToEAROperation(earprojects[i].getName(), this.model, this.monitor);
                    ++i;
                }
                this.runAddClientToEJBOperation(this.model, this.monitor);
                this.updateEJBDD(this.model, this.monitor);
                this.moveOutgoingJARDependencies();
                EJBClientJarCreationHelper.copyOutgoingClasspathEntries(ejbproject, ProjectUtilities.getProject((String)projectName), true);
                this.modifyEJBModuleJarDependency(this.model, earprojects[0], this.monitor);
                IProject clientProject = ProjectUtilities.getProject((String)this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME"));
                this.moveIncomingJARDependencies(ejbproject, clientProject);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            EJBClientJarCreationHelper helper = new EJBClientJarCreationHelper(ejbproject);
            IDataModel moveModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBClientJarFileMoveDataModelProvider());
            moveModel.setProperty("IEJBClientJarFileMoveDataModelProperties.EJB_PROJECT_NAME", (Object)ejbproject.getName());
            moveModel.setProperty("IEJBClientJarFileMoveDataModelProperties.CLIENT_PROJECT_NAME", (Object)this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME"));
            moveModel.setProperty("IEJBClientJarFileMoveDataModelProperties.FILES_TO_MOVE_MAP", (Object)helper.getFilesToMove());
            moveModel.getDefaultOperation().execute(this.monitor, null);
        }
        return stat;
    }

    protected void runAddClientToEAROperation(String earProjectName, IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IProject earproject = ProjectUtilities.getProject((String)earProjectName);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earproject);
        String clientProjectName = model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
        IVirtualComponent component = ComponentCore.createComponent((IProject)clientProject);
        if (earComp.exists() && component.exists()) {
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
            List modList = (List)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
            modList.add(component);
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
            String clientURI = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ");
            ((Map)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP")).put(component, clientURI);
            try {
                dm.getDefaultOperation().execute(monitor, null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
    }

    protected void runAddClientToEJBOperation(IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String ejbprojectName = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        IVirtualComponent ejbcomponent = ComponentCore.createComponent((IProject)ejbProj);
        String clientProjectName = model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
        IVirtualComponent ejbclientcomponent = ComponentCore.createComponent((IProject)clientProject);
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)ejbcomponent);
        List modList = (List)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modList.add(ejbclientcomponent);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
        try {
            dm.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    private void modifyEJBModuleJarDependency(IDataModel model, IProject earProject, IProgressMonitor aMonitor) throws InvocationTargetException, InterruptedException {
        String ejbprojectName = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        IVirtualComponent ejbComponent = ComponentCore.createComponent((IProject)ejbProj);
        IVirtualFile vf = ejbComponent.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = vf.getUnderlyingFile();
        String clientURI = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ");
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel(UpdateManifestDataModelProvider.class);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)ejbprojectName);
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)UpdateManifestDataModelProvider.convertClasspathStringToList((String)clientURI));
        try {
            updateManifestDataModel.getDefaultOperation().execute(aMonitor, null);
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private void updateEJBDD(IDataModel model, IProgressMonitor monitor) {
        String ejbprojectName = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        String clientProjectName = model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        IVirtualComponent c = ComponentCore.createComponent((IProject)ejbProj);
        Properties props = c.getMetaProperties();
        String clienturi = props.getProperty("ClientJARURI");
        EJBArtifactEdit ejbEdit = null;
        try {
            try {
                ejbEdit = new EJBArtifactEdit(ejbProj, false, true);
                if (ejbEdit != null) {
                    EJBJarImpl ejbres = (EJBJarImpl)ejbEdit.getDeploymentDescriptorRoot();
                    if (clienturi != null && !clienturi.equals("")) {
                        ejbres.setEjbClientJar(clienturi);
                    } else {
                        ejbres.setEjbClientJar(String.valueOf(clientProjectName) + ".jar");
                    }
                    ejbres.setEjbClientJar(clienturi);
                    ejbEdit.saveIfNecessary(monitor);
                }
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
                if (ejbEdit != null) {
                    ejbEdit.dispose();
                }
            }
        }
        finally {
            if (ejbEdit != null) {
                ejbEdit.dispose();
            }
        }
    }

    private void moveIncomingJARDependencies(IProject ejbProject, IProject clientProject) throws InvocationTargetException, InterruptedException {
        InvertClientJARDependencyCompoundOperation op = new InvertClientJARDependencyCompoundOperation(J2EEProjectUtilities.getReferencingEARProjects((IProject)ejbProject), ejbProject, clientProject);
        try {
            op.execute(this.createSubProgressMonitor(1), null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected IProgressMonitor createSubProgressMonitor(int ticks) {
        return new SubProgressMonitor(this.monitor, ticks);
    }

    private void moveOutgoingJARDependencies() throws InvocationTargetException, InterruptedException {
        IProject ejbproject = ProjectUtilities.getProject((String)this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME"));
        String clientProjectName = this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        ArchiveManifest ejbMf = J2EEProjectUtilities.readManifest((IProject)ejbproject);
        if (ejbMf == null) {
            return;
        }
        String[] mfEntries = ejbMf.getClassPathTokenized();
        if (mfEntries.length == 0) {
            return;
        }
        IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)ejbproject);
        IProgressMonitor sub = this.createSubProgressMonitor(earProjects.length * 2);
        int i = 0;
        while (i < earProjects.length) {
            List normalized = EJBClientJarCreationHelper.normalize(mfEntries, earProjects[i], ejbproject, true);
            IDataModel addDataModel = DataModelFactory.createDataModel((IDataModelProvider)new JARDependencyDataModelProvider());
            addDataModel.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 0);
            addDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)clientProjectName);
            addDataModel.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)earProjects[i].getName());
            addDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)normalized);
            IDataModel removeDataModel = DataModelFactory.createDataModel((IDataModelProvider)new JARDependencyDataModelProvider());
            removeDataModel.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 1);
            removeDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)ejbproject.getName());
            removeDataModel.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)earProjects[i].getName());
            removeDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)normalized);
            try {
                addDataModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(sub, 1), null);
                removeDataModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(sub, 1), null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            ++i;
        }
    }
}

