/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.cleanupformat;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;

public class CleanupTester
extends TestCase {
    private static final boolean PRINT_FAILED_FORMAT_TESTS = false;
    protected IModelManager fModelManager = StructuredModelManager.getModelManager();
    protected CleanupProcessorXML fCleanupProcessor = new CleanupProcessorXML();
    protected HTMLCleanupProcessorImpl fHTMLCleanupProcessor = new HTMLCleanupProcessorImpl();

    public CleanupTester(String name) {
        super(name);
    }

    public void testCleanupInsertTagsQuoteAttrs() throws UnsupportedEncodingException, IOException {
        IStructuredModel structuredModel = this.getModel("invoice.xml");
        IStructuredCleanupPreferences cleanupPreferences = this.fCleanupProcessor.getCleanupPreferences();
        cleanupPreferences.setCompressEmptyElementTags(false);
        cleanupPreferences.setInsertRequiredAttrs(false);
        cleanupPreferences.setInsertMissingTags(true);
        cleanupPreferences.setQuoteAttrValues(true);
        cleanupPreferences.setFormatSource(false);
        cleanupPreferences.setConvertEOLCodes(false);
        this.fCleanupProcessor.refreshCleanupPreferences = false;
        this.fCleanupProcessor.cleanupModel(structuredModel);
        this.fCleanupProcessor.refreshCleanupPreferences = true;
        String cleaned = structuredModel.getStructuredDocument().get();
        String expectedFileName = "invoice.afterCleanupInsertTagsQuoteAttrs.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, cleaned);
        structuredModel.releaseFromRead();
    }

    public void testCleanupInsertTags() throws IOException, IOException {
        IStructuredModel structuredModel = this.getModel("invoice.xml");
        IStructuredCleanupPreferences cleanupPreferences = this.fCleanupProcessor.getCleanupPreferences();
        cleanupPreferences.setCompressEmptyElementTags(false);
        cleanupPreferences.setInsertRequiredAttrs(false);
        cleanupPreferences.setInsertMissingTags(true);
        cleanupPreferences.setQuoteAttrValues(false);
        cleanupPreferences.setFormatSource(false);
        cleanupPreferences.setConvertEOLCodes(false);
        this.fCleanupProcessor.refreshCleanupPreferences = false;
        this.fCleanupProcessor.cleanupModel(structuredModel);
        this.fCleanupProcessor.refreshCleanupPreferences = true;
        String cleaned = structuredModel.getStructuredDocument().get();
        String expectedFileName = "invoice.afterCleanupInsertTags.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, cleaned);
        structuredModel.releaseFromRead();
    }

    public void testCleanupCompressEmptyElementTags() throws UnsupportedEncodingException, IOException {
        IStructuredModel structuredModel = this.getModel("small.xml");
        IStructuredCleanupPreferences cleanupPreferences = this.fCleanupProcessor.getCleanupPreferences();
        cleanupPreferences.setCompressEmptyElementTags(true);
        cleanupPreferences.setInsertRequiredAttrs(false);
        cleanupPreferences.setInsertMissingTags(false);
        cleanupPreferences.setQuoteAttrValues(false);
        cleanupPreferences.setFormatSource(true);
        cleanupPreferences.setConvertEOLCodes(false);
        this.fCleanupProcessor.refreshCleanupPreferences = false;
        this.fCleanupProcessor.cleanupModel(structuredModel);
        this.fCleanupProcessor.refreshCleanupPreferences = true;
        String cleaned = structuredModel.getStructuredDocument().get();
        String expectedFileName = "small.afterCompressEmptyElementTags.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, cleaned);
        structuredModel.releaseFromRead();
    }

    public void testCleanupHTML() throws UnsupportedEncodingException, IOException {
        IStructuredModel structuredModel = this.getModel("cleanup.html");
        IStructuredCleanupPreferences cleanupPreferences = this.fHTMLCleanupProcessor.getCleanupPreferences();
        cleanupPreferences.setTagNameCase(2);
        cleanupPreferences.setAttrNameCase(1);
        cleanupPreferences.setCompressEmptyElementTags(false);
        cleanupPreferences.setInsertRequiredAttrs(false);
        cleanupPreferences.setInsertMissingTags(true);
        cleanupPreferences.setQuoteAttrValues(true);
        cleanupPreferences.setFormatSource(false);
        cleanupPreferences.setConvertEOLCodes(false);
        this.fHTMLCleanupProcessor.refreshCleanupPreferences = false;
        this.fHTMLCleanupProcessor.cleanupModel(structuredModel);
        this.fHTMLCleanupProcessor.refreshCleanupPreferences = true;
        String cleaned = structuredModel.getStructuredDocument().get();
        String expectedFileName = "cleanup.afterCleanup.html";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, cleaned);
        structuredModel.releaseFromRead();
    }

    public void testCleanupHTMLtwice() throws UnsupportedEncodingException, IOException {
        IStructuredModel structuredModel = this.getModel("cleanup.afterCleanup.html");
        IStructuredCleanupPreferences cleanupPreferences = this.fHTMLCleanupProcessor.getCleanupPreferences();
        cleanupPreferences.setTagNameCase(2);
        cleanupPreferences.setAttrNameCase(1);
        cleanupPreferences.setCompressEmptyElementTags(false);
        cleanupPreferences.setInsertRequiredAttrs(false);
        cleanupPreferences.setInsertMissingTags(true);
        cleanupPreferences.setQuoteAttrValues(true);
        cleanupPreferences.setFormatSource(false);
        cleanupPreferences.setConvertEOLCodes(false);
        this.fHTMLCleanupProcessor.refreshCleanupPreferences = false;
        this.fHTMLCleanupProcessor.cleanupModel(structuredModel);
        this.fHTMLCleanupProcessor.refreshCleanupPreferences = true;
        String cleaned = structuredModel.getStructuredDocument().get();
        String expectedFileName = "cleanup.afterCleanup.html";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, cleaned);
        structuredModel.releaseFromRead();
    }

    /*
     * Exception decompiling
     */
    protected String readFile(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 92->95)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void printException(Exception exception) {
        exception.printStackTrace();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStructuredModel getModel(String fileName) throws UnsupportedEncodingException, IOException {
        IStructuredModel structuredModel = null;
        InputStream inputStream = null;
        try {
            String input = this.getFile(fileName);
            inputStream = new ByteArrayInputStream(input.getBytes("UTF-8"));
            String id = inputStream.toString().concat(fileName);
            structuredModel = this.fModelManager.getModelForRead(id, inputStream, null);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (Exception exception) {
            return structuredModel;
        }
        inputStream.close();
        return structuredModel;
    }

    protected String getFile(String fileName) throws IOException {
        return this.readFile("testfiles/".concat(fileName));
    }

    protected void compare(String testcaseName, String expected, String cleaned) {
        if (cleaned.compareTo(expected) != 0) {
            CleanupTester.assertTrue((boolean)false);
        }
    }
}

