/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.tests.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLElement;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.ContextManager;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Parameter;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Server;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Connector;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Engine;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Host;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Listener;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlTestCase
extends TestCase {
    protected static Properties testProperties;

    protected void setUp() throws Exception {
        if (testProperties == null) {
            testProperties = new Properties();
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("XmlTests.properties");
            testProperties.load(is);
        }
    }

    private InputStream getXmlInputStream(String testId) {
        String xml;
        if (testProperties == null) {
            XmlTestCase.fail((String)"XmlTests.properties file was not loaded.");
        }
        if ((xml = testProperties.getProperty(testId)) == null) {
            XmlTestCase.fail((String)("XML data for test " + testId + " was not found."));
        }
        return new ByteArrayInputStream(xml.getBytes());
    }

    private org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server getXml40Server(String testId) {
        Factory factory = new Factory();
        factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
        try {
            return (org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server)factory.loadDocument(this.getXmlInputStream(testId));
        }
        catch (Exception e) {
            XmlTestCase.fail((String)("Exception occurred loading " + testId + " XML: " + e.getMessage()));
            return null;
        }
    }

    private Context getXml40Context(String testId) {
        Factory factory = new Factory();
        factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
        try {
            return (Context)factory.loadDocument(this.getXmlInputStream(testId));
        }
        catch (Exception e) {
            XmlTestCase.fail((String)("Exception occurred loading " + testId + " XML: " + e.getMessage()));
            return null;
        }
    }

    private Server getXml32Server(String testId) {
        Factory factory = new Factory();
        factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server32");
        try {
            return (Server)factory.loadDocument(this.getXmlInputStream(testId));
        }
        catch (Exception e) {
            XmlTestCase.fail((String)("Exception occurred loading " + testId + " XML: " + e.getMessage()));
            return null;
        }
    }

    public void testDefaultServerXml50() {
        org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server server = this.getXml40Server("default.serverxml.50");
        XmlTestCase.assertNotNull((Object)server);
        String port = server.getPort();
        XmlTestCase.assertEquals((String)"8005", (String)port);
        XmlTestCase.assertEquals((int)server.getListenerCount(), (int)2);
        Listener listener = server.getListener(0);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.mbeans.ServerLifecycleListener", (String)listener.getClassName());
        listener = server.getListener(1);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.mbeans.GlobalResourcesLifecycleListener", (String)listener.getClassName());
        XmlTestCase.assertEquals((int)1, (int)server.getServiceCount());
        Service service = server.getService(0);
        XmlTestCase.assertNotNull((Object)service);
        XmlTestCase.assertEquals((String)"Catalina", (String)service.getName());
        XmlTestCase.assertEquals((int)2, (int)service.getConnectorCount());
        Connector connector = service.getConnector(0);
        XmlTestCase.assertNotNull((Object)connector);
        XmlTestCase.assertEquals((String)"8080", (String)connector.getPort());
        XmlTestCase.assertNull((Object)connector.getProtocol());
        connector = service.getConnector(1);
        XmlTestCase.assertNotNull((Object)connector);
        XmlTestCase.assertEquals((String)"8009", (String)connector.getPort());
        XmlTestCase.assertEquals((String)"AJP/1.3", (String)connector.getProtocol());
        Engine engine = service.getEngine();
        XmlTestCase.assertNotNull((Object)engine);
        XmlTestCase.assertEquals((String)"Catalina", (String)engine.getName());
        XmlTestCase.assertEquals((String)"localhost", (String)engine.getDefaultHost());
        XmlTestCase.assertEquals((int)engine.getHostCount(), (int)1);
        Host host = engine.getHost(0);
        XmlTestCase.assertNotNull((Object)host);
        XmlTestCase.assertEquals((String)"localhost", (String)host.getName());
        XmlTestCase.assertEquals((String)"webapps", (String)host.getAppBase());
        XmlTestCase.assertEquals((String)"true", (String)host.getAttributeValue("unpackWARs"));
        XmlTestCase.assertEquals((String)"true", (String)host.getAttributeValue("autoDeploy"));
        XmlTestCase.assertEquals((int)0, (int)host.getContextCount());
    }

    public void testDefaultServerXml55() {
        org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server server = this.getXml40Server("default.serverxml.55");
        XmlTestCase.assertNotNull((Object)server);
        String port = server.getPort();
        XmlTestCase.assertEquals((String)"8005", (String)port);
        XmlTestCase.assertEquals((int)server.getListenerCount(), (int)4);
        Listener listener = server.getListener(0);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.core.AprLifecycleListener", (String)listener.getClassName());
        listener = server.getListener(1);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.mbeans.ServerLifecycleListener", (String)listener.getClassName());
        listener = server.getListener(2);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.mbeans.GlobalResourcesLifecycleListener", (String)listener.getClassName());
        listener = server.getListener(3);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.storeconfig.StoreConfigLifecycleListener", (String)listener.getClassName());
        XmlTestCase.assertEquals((int)server.getServiceCount(), (int)1);
        Service service = server.getService(0);
        XmlTestCase.assertNotNull((Object)service);
        XmlTestCase.assertEquals((String)"Catalina", (String)service.getName());
        XmlTestCase.assertEquals((int)2, (int)service.getConnectorCount());
        Connector connector = service.getConnector(0);
        XmlTestCase.assertNotNull((Object)connector);
        XmlTestCase.assertEquals((String)"8080", (String)connector.getPort());
        XmlTestCase.assertNull((Object)connector.getProtocol());
        connector = service.getConnector(1);
        XmlTestCase.assertNotNull((Object)connector);
        XmlTestCase.assertEquals((String)"8009", (String)connector.getPort());
        XmlTestCase.assertEquals((String)"AJP/1.3", (String)connector.getProtocol());
        Engine engine = service.getEngine();
        XmlTestCase.assertNotNull((Object)engine);
        XmlTestCase.assertEquals((String)"Catalina", (String)engine.getName());
        XmlTestCase.assertEquals((String)"localhost", (String)engine.getDefaultHost());
        XmlTestCase.assertEquals((int)1, (int)engine.getHostCount());
        Host host = engine.getHost(0);
        XmlTestCase.assertNotNull((Object)host);
        XmlTestCase.assertEquals((String)"localhost", (String)host.getName());
        XmlTestCase.assertEquals((String)"webapps", (String)host.getAppBase());
        XmlTestCase.assertEquals((String)"true", (String)host.getAttributeValue("unpackWARs"));
        XmlTestCase.assertEquals((String)"true", (String)host.getAttributeValue("autoDeploy"));
        XmlTestCase.assertEquals((int)0, (int)host.getContextCount());
    }

    public void testDefaultServerXml60() {
        org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server server = this.getXml40Server("default.serverxml.60");
        XmlTestCase.assertNotNull((Object)server);
        String port = server.getPort();
        XmlTestCase.assertEquals((String)"8005", (String)port);
        XmlTestCase.assertEquals((int)4, (int)server.getListenerCount());
        Listener listener = server.getListener(0);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.core.AprLifecycleListener", (String)listener.getClassName());
        listener = server.getListener(1);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.core.JasperListener", (String)listener.getClassName());
        listener = server.getListener(2);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.mbeans.ServerLifecycleListener", (String)listener.getClassName());
        listener = server.getListener(3);
        XmlTestCase.assertNotNull((Object)listener);
        XmlTestCase.assertEquals((String)"org.apache.catalina.mbeans.GlobalResourcesLifecycleListener", (String)listener.getClassName());
        XmlTestCase.assertEquals((int)1, (int)server.getServiceCount());
        Service service = server.getService(0);
        XmlTestCase.assertNotNull((Object)service);
        XmlTestCase.assertEquals((String)"Catalina", (String)service.getName());
        XmlTestCase.assertEquals((int)2, (int)service.getConnectorCount());
        Connector connector = service.getConnector(0);
        XmlTestCase.assertNotNull((Object)connector);
        XmlTestCase.assertEquals((String)"8080", (String)connector.getPort());
        XmlTestCase.assertEquals((String)"HTTP/1.1", (String)connector.getProtocol());
        connector = service.getConnector(1);
        XmlTestCase.assertNotNull((Object)connector);
        XmlTestCase.assertEquals((String)"8009", (String)connector.getPort());
        XmlTestCase.assertEquals((String)"AJP/1.3", (String)connector.getProtocol());
        Engine engine = service.getEngine();
        XmlTestCase.assertNotNull((Object)engine);
        XmlTestCase.assertEquals((String)"Catalina", (String)engine.getName());
        XmlTestCase.assertEquals((String)"localhost", (String)engine.getDefaultHost());
        XmlTestCase.assertEquals((int)1, (int)engine.getHostCount());
        Host host = engine.getHost(0);
        XmlTestCase.assertNotNull((Object)host);
        XmlTestCase.assertEquals((String)"localhost", (String)host.getName());
        XmlTestCase.assertEquals((String)"webapps", (String)host.getAppBase());
        XmlTestCase.assertEquals((String)"true", (String)host.getAttributeValue("unpackWARs"));
        XmlTestCase.assertEquals((String)"true", (String)host.getAttributeValue("autoDeploy"));
        XmlTestCase.assertEquals((int)0, (int)host.getContextCount());
    }

    public void testServerInstance50() {
        org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server server = this.getXml40Server("default.serverxml.50");
        XmlTestCase.assertNotNull((Object)server);
        ServerInstance si = new ServerInstance(server, null, null);
        XmlTestCase.assertEquals((int)2, (int)server.getListenerCount());
        Listener[] listeners = si.getListeners();
        XmlTestCase.assertEquals((String)"org.apache.catalina.mbeans.ServerLifecycleListener", (String)listeners[0].getClassName());
        XmlTestCase.assertEquals((String)"org.apache.catalina.mbeans.GlobalResourcesLifecycleListener", (String)listeners[1].getClassName());
        Service service = si.getService();
        XmlTestCase.assertNotNull((Object)service);
        XmlTestCase.assertEquals((String)"Catalina", (String)service.getName());
        XmlTestCase.assertEquals((String)"8080", (String)si.getConnector(0).getPort());
        XmlTestCase.assertNull((Object)si.getConnector(0).getProtocol());
        XmlTestCase.assertEquals((String)"8009", (String)si.getConnector(1).getPort());
        XmlTestCase.assertEquals((String)"AJP/1.3", (String)si.getConnector(1).getProtocol());
        Connector[] connectors = si.getConnectors();
        XmlTestCase.assertEquals((int)2, (int)connectors.length);
        XmlTestCase.assertEquals((String)"8080", (String)connectors[0].getPort());
        XmlTestCase.assertNull((Object)connectors[0].getProtocol());
        XmlTestCase.assertEquals((String)"8009", (String)connectors[1].getPort());
        XmlTestCase.assertEquals((String)"AJP/1.3", (String)connectors[1].getProtocol());
        Engine engine = si.getEngine();
        XmlTestCase.assertNotNull((Object)engine);
        XmlTestCase.assertEquals((String)"Catalina", (String)engine.getName());
        XmlTestCase.assertEquals((String)"localhost", (String)engine.getDefaultHost());
        Host host = si.getHost();
        XmlTestCase.assertNotNull((Object)host);
        XmlTestCase.assertEquals((String)"localhost", (String)host.getName());
        XmlTestCase.assertEquals((String)"webapps", (String)host.getAppBase());
        XmlTestCase.assertEquals((String)"true", (String)host.getAttributeValue("unpackWARs"));
        XmlTestCase.assertEquals((String)"true", (String)host.getAttributeValue("autoDeploy"));
        Context[] contexts = si.getContexts();
        XmlTestCase.assertEquals((int)0, (int)contexts.length);
    }

    public void testServerInstance1() {
        org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server server = this.getXml40Server("serverxml.test1");
        XmlTestCase.assertNotNull((Object)server);
        ServerInstance si = new ServerInstance(server, "nonexistent_service", null);
        XmlTestCase.assertNull((Object)si.getService());
        XmlTestCase.assertEquals((String)"Service \"nonexistent_service\" was not found.", (String)si.getStatus().getMessage());
        si = new ServerInstance(server, null, null);
        XmlTestCase.assertNotNull((Object)si.getService());
        XmlTestCase.assertEquals((String)"Service", (String)si.getService().getName());
        si = new ServerInstance(server, "Service", null);
        XmlTestCase.assertNotNull((Object)si.getService());
        XmlTestCase.assertNull((Object)si.getEngine());
        XmlTestCase.assertEquals((String)"Engine element not found under Service \"Service\".", (String)si.getStatus().getMessage());
    }

    public void testServerInstance2() {
        org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server server = this.getXml40Server("serverxml.test2");
        XmlTestCase.assertNotNull((Object)server);
        ServerInstance si = new ServerInstance(server, "Service", "nonexistent_host");
        XmlTestCase.assertNotNull((Object)si.getService());
        XmlTestCase.assertNotNull((Object)si.getEngine());
        XmlTestCase.assertEquals((String)"Engine", (String)si.getEngine().getName());
        XmlTestCase.assertNull((Object)si.getHost());
        XmlTestCase.assertEquals((String)"Host \"nonexistent_host\" was not found under Engine \"Engine\" and Service \"Service\".", (String)si.getStatus().getMessage());
        si = new ServerInstance(server, "Service", null);
        XmlTestCase.assertNotNull((Object)si.getService());
        XmlTestCase.assertNotNull((Object)si.getEngine());
        XmlTestCase.assertEquals((String)"Engine", (String)si.getEngine().getName());
        XmlTestCase.assertNotNull((Object)si.getHost());
        XmlTestCase.assertEquals((String)"localhost", (String)si.getHost().getName());
        XmlTestCase.assertEquals((Object)new Path("/Base").append("Engine").append("localhost"), (Object)si.getContextXmlDirectory((IPath)new Path("/Base")));
        Context context = si.getContext(0);
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((String)"/WebApp1", (String)context.getPath());
        context = si.getContext(1);
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((String)"/WebApp2", (String)context.getPath());
        context = si.getContext(2);
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((String)"/WebApp3", (String)context.getPath());
        context = si.getContext(3);
        context.setPath("/WebApp4");
        Context[] contexts = si.getContexts();
        XmlTestCase.assertEquals((int)4, (int)contexts.length);
        XmlTestCase.assertEquals((String)"/WebApp1", (String)contexts[0].getPath());
        XmlTestCase.assertEquals((String)"/WebApp2", (String)contexts[1].getPath());
        XmlTestCase.assertEquals((String)"/WebApp3", (String)contexts[2].getPath());
        XmlTestCase.assertEquals((String)"/WebApp4", (String)contexts[3].getPath());
        context = si.createContext(2);
        context.setPath("/WebApp2b");
        contexts = si.getContexts();
        XmlTestCase.assertEquals((int)5, (int)contexts.length);
        XmlTestCase.assertEquals((String)"/WebApp1", (String)contexts[0].getPath());
        XmlTestCase.assertEquals((String)"/WebApp2", (String)contexts[1].getPath());
        XmlTestCase.assertEquals((String)"/WebApp2b", (String)contexts[2].getPath());
        XmlTestCase.assertEquals((String)"/WebApp3", (String)contexts[3].getPath());
        XmlTestCase.assertEquals((String)"/WebApp4", (String)contexts[4].getPath());
        XmlTestCase.assertTrue((boolean)si.removeContext("WebApp2b"));
        contexts = si.getContexts();
        XmlTestCase.assertEquals((int)4, (int)contexts.length);
        XmlTestCase.assertEquals((String)"/WebApp1", (String)contexts[0].getPath());
        XmlTestCase.assertEquals((String)"/WebApp2", (String)contexts[1].getPath());
        XmlTestCase.assertEquals((String)"/WebApp3", (String)contexts[2].getPath());
        XmlTestCase.assertEquals((String)"/WebApp4", (String)contexts[3].getPath());
        XmlTestCase.assertTrue((boolean)si.removeContext(3));
        contexts = si.getContexts();
        XmlTestCase.assertEquals((int)3, (int)contexts.length);
        XmlTestCase.assertEquals((String)"/WebApp1", (String)contexts[0].getPath());
        XmlTestCase.assertEquals((String)"/WebApp2", (String)contexts[1].getPath());
        XmlTestCase.assertEquals((String)"/WebApp3", (String)contexts[2].getPath());
        context = si.getContext("/WebApp1");
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((String)"/WebApp1", (String)context.getPath());
        XmlTestCase.assertEquals((Object)new Path("/Base/work/Engine/localhost/WebApp1"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), context));
        context = si.getContext("WebApp2");
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((String)"/WebApp2", (String)context.getPath());
        XmlTestCase.assertEquals((Object)new Path("/Base/relative/workdir"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), context));
        context = si.getContext("WebApp3");
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((String)"/WebApp3", (String)context.getPath());
        XmlTestCase.assertEquals((Object)new Path("/absolute/workdir"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), context));
        context = si.createContext(3);
        context.setPath("");
        context = si.getContext("");
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((String)"", (String)context.getPath());
        XmlTestCase.assertEquals((Object)new Path("/Base/work/Engine/localhost/_"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), context));
        XmlTestCase.assertEquals((Object)new Path("/Base/work/Engine/localhost"), (Object)si.getHostWorkDirectory((IPath)new Path("/Base")));
        XmlTestCase.assertNull((Object)si.getContext("nonexistent"));
        XmlTestCase.assertEquals((String)"Context with path \"/nonexistent\" was not found under Service \"Service\", Engine \"Engine\", and Host \"localhost\".", (String)si.getStatus().getMessage());
    }

    public void testServerInstance3() {
        org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server server = this.getXml40Server("serverxml.test3");
        XmlTestCase.assertNotNull((Object)server);
        ServerInstance si = new ServerInstance(server, "Service", null);
        Context context = si.getContext("/WebApp1");
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((Object)new Path("/Base/relative/host/WebApp1"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), context));
        context = si.getContext("WebApp2");
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((Object)new Path("/Base/relative/workdir"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), context));
        context = si.getContext("WebApp3");
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((Object)new Path("/absolute/workdir"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), context));
    }

    public void testDefaultServerXml32() {
        Server server = this.getXml32Server("default.serverxml.32");
        XmlTestCase.assertNotNull((Object)server);
        ContextManager contextManager = server.getContextManager();
        XmlTestCase.assertNotNull((Object)contextManager);
        XmlTestCase.assertEquals((int)2, (int)contextManager.getConnectorCount());
        XmlTestCase.assertNotNull((Object)contextManager.getConnector(0));
        Parameter parameter = contextManager.getConnector(0).getParameter(0);
        XmlTestCase.assertEquals((String)"handler", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"org.apache.tomcat.service.http.HttpConnectionHandler", (String)parameter.getValue());
        parameter = contextManager.getConnector(0).getParameter(1);
        XmlTestCase.assertEquals((String)"port", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"8080", (String)parameter.getValue());
        XmlTestCase.assertNotNull((Object)contextManager.getConnector(1));
        parameter = contextManager.getConnector(1).getParameter(0);
        XmlTestCase.assertEquals((String)"handler", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"org.apache.tomcat.service.connector.Ajp12ConnectionHandler", (String)parameter.getValue());
        parameter = contextManager.getConnector(1).getParameter(1);
        XmlTestCase.assertEquals((String)"port", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"8007", (String)parameter.getValue());
        XmlTestCase.assertEquals((int)2, (int)contextManager.getContextCount());
        XmlTestCase.assertNotNull((Object)contextManager.getContext(0));
        XmlTestCase.assertEquals((String)"/examples", (String)contextManager.getContext(0).getPath());
        XmlTestCase.assertNotNull((Object)contextManager.getContext(1));
        XmlTestCase.assertEquals((String)"/admin", (String)contextManager.getContext(1).getPath());
    }

    public void testServerInstance32() {
        Server server = this.getXml32Server("default.serverxml.32");
        XmlTestCase.assertNotNull((Object)server);
        org.eclipse.jst.server.tomcat.core.internal.xml.server32.ServerInstance si = new org.eclipse.jst.server.tomcat.core.internal.xml.server32.ServerInstance(server);
        XmlTestCase.assertNotNull((Object)si.getContextManager());
        org.eclipse.jst.server.tomcat.core.internal.xml.server32.Connector[] connectors = si.getConnectors();
        XmlTestCase.assertNotNull((Object)connectors);
        XmlTestCase.assertEquals((int)2, (int)connectors.length);
        Parameter parameter = connectors[0].getParameter(0);
        XmlTestCase.assertEquals((String)"handler", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"org.apache.tomcat.service.http.HttpConnectionHandler", (String)parameter.getValue());
        parameter = connectors[0].getParameter(1);
        XmlTestCase.assertEquals((String)"port", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"8080", (String)parameter.getValue());
        parameter = connectors[1].getParameter(0);
        XmlTestCase.assertEquals((String)"handler", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"org.apache.tomcat.service.connector.Ajp12ConnectionHandler", (String)parameter.getValue());
        parameter = connectors[1].getParameter(1);
        XmlTestCase.assertEquals((String)"port", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"8007", (String)parameter.getValue());
        parameter = si.getConnector(0).getParameter(0);
        XmlTestCase.assertEquals((String)"handler", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"org.apache.tomcat.service.http.HttpConnectionHandler", (String)parameter.getValue());
        parameter = si.getConnector(0).getParameter(1);
        XmlTestCase.assertEquals((String)"port", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"8080", (String)parameter.getValue());
        parameter = si.getConnector(1).getParameter(0);
        XmlTestCase.assertEquals((String)"handler", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"org.apache.tomcat.service.connector.Ajp12ConnectionHandler", (String)parameter.getValue());
        parameter = si.getConnector(1).getParameter(1);
        XmlTestCase.assertEquals((String)"port", (String)parameter.getName());
        XmlTestCase.assertEquals((String)"8007", (String)parameter.getValue());
        org.eclipse.jst.server.tomcat.core.internal.xml.server32.Context[] contexts = si.getContexts();
        XmlTestCase.assertNotNull((Object)contexts);
        XmlTestCase.assertEquals((int)2, (int)contexts.length);
        XmlTestCase.assertEquals((String)"/examples", (String)contexts[0].getPath());
        XmlTestCase.assertEquals((String)"/admin", (String)contexts[1].getPath());
        XmlTestCase.assertEquals((String)"/examples", (String)si.getContext(0).getPath());
        XmlTestCase.assertEquals((String)"/admin", (String)si.getContext(1).getPath());
        XmlTestCase.assertEquals((String)"/examples", (String)si.getContext("examples").getPath());
        XmlTestCase.assertEquals((String)"/admin", (String)si.getContext("/admin").getPath());
        org.eclipse.jst.server.tomcat.core.internal.xml.server32.Context context = si.createContext(2);
        context.setPath("/WebApp1");
        contexts = si.getContexts();
        XmlTestCase.assertNotNull((Object)contexts);
        XmlTestCase.assertEquals((int)3, (int)contexts.length);
        XmlTestCase.assertEquals((String)"/examples", (String)contexts[0].getPath());
        XmlTestCase.assertEquals((String)"/admin", (String)contexts[1].getPath());
        XmlTestCase.assertEquals((String)"/WebApp1", (String)contexts[2].getPath());
        XmlTestCase.assertEquals((Object)new Path("/Base/work/localhost_8080%2Fexamples"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), si.getContext("examples")));
        XmlTestCase.assertEquals((Object)new Path("/Base/work/localhost_8080%2Fadmin"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), si.getContext("admin")));
        XmlTestCase.assertEquals((Object)new Path("/Base/work/localhost_8080%2FWebApp1"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), si.getContext("WebApp1")));
        XmlTestCase.assertTrue((boolean)si.removeContext(2));
        contexts = si.getContexts();
        XmlTestCase.assertNotNull((Object)contexts);
        XmlTestCase.assertEquals((int)2, (int)contexts.length);
        XmlTestCase.assertEquals((String)"/examples", (String)contexts[0].getPath());
        XmlTestCase.assertEquals((String)"/admin", (String)contexts[1].getPath());
        context = si.createContext(2);
        context.setPath("");
        context = si.getContext("");
        XmlTestCase.assertNotNull((Object)context);
        XmlTestCase.assertEquals((String)"", (String)context.getPath());
        XmlTestCase.assertEquals((Object)new Path("/Base/work/localhost_8080"), (Object)si.getContextWorkDirectory((IPath)new Path("/Base"), si.getContext("")));
        XmlTestCase.assertEquals((Object)si.getServerWorkDirectory((IPath)new Path("/Base")), (Object)new Path("/Base/work"));
    }

    public void testTomcatContextComparison() {
        Context context = this.getXml40Context("tomcat.context.50");
        XmlTestCase.assertTrue((boolean)context.isEquivalentTest((XMLElement)context));
        Context context2 = this.getXml40Context("tomcat.context.50");
        XmlTestCase.assertTrue((boolean)context.isEquivalentTest((XMLElement)context2));
        XmlTestCase.assertTrue((boolean)context2.isEquivalentTest((XMLElement)context));
        String docBase = context2.getDocBase();
        context2.setDocBase(String.valueOf(docBase) + "X");
        XmlTestCase.assertTrue((!context.isEquivalentTest((XMLElement)context2) ? 1 : 0) != 0);
        XmlTestCase.assertTrue((!context2.isEquivalentTest((XMLElement)context) ? 1 : 0) != 0);
        context.setDocBase(String.valueOf(docBase) + "X");
        XmlTestCase.assertTrue((boolean)context.isEquivalentTest((XMLElement)context2));
        XmlTestCase.assertTrue((boolean)context2.isEquivalentTest((XMLElement)context));
        Element realm = context2.getSubElement("Realm");
        XmlTestCase.assertNotNull((Object)realm);
        Node parent = realm.getParentNode();
        XmlTestCase.assertNotNull((Object)parent);
        XmlTestCase.assertTrue((parent == context2.getElementNode() ? 1 : 0) != 0);
        parent.removeChild(realm);
        XmlTestCase.assertTrue((!context.isEquivalentTest((XMLElement)context2) ? 1 : 0) != 0);
        XmlTestCase.assertTrue((!context2.isEquivalentTest((XMLElement)context) ? 1 : 0) != 0);
        parent.insertBefore(realm, parent.getFirstChild());
        XmlTestCase.assertTrue((!context.isEquivalentTest((XMLElement)context2) ? 1 : 0) != 0);
        XmlTestCase.assertTrue((!context2.isEquivalentTest((XMLElement)context) ? 1 : 0) != 0);
        parent.removeChild(realm);
        parent.appendChild(realm);
        XmlTestCase.assertTrue((boolean)context.isEquivalentTest((XMLElement)context2));
        XmlTestCase.assertTrue((boolean)context2.isEquivalentTest((XMLElement)context));
    }
}

