/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.unittest;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.jst.ws.tests.axis.tomcat.v50.WSWizardTomcat50Test;
import org.eclipse.jst.ws.tests.util.JUnitUtils;
import org.eclipse.wst.command.internal.env.eclipse.AccumulateStatusHandler;

public final class BUJavaAxisTC50
extends WSWizardTomcat50Test {
    private final String WS_RUNTIMEID_AXIS = "org.eclipse.jst.ws.axis.creation.axisWebServiceRT";
    private String PROJECT_NAME = "TestWeb";
    private IFile sourceFile_;

    public static Test suite() {
        return new TestSuite(BUJavaAxisTC50.class);
    }

    protected void installInputData() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        IPath destPath = ResourceUtils.getJavaSourceLocation((IProject)webProject);
        IFolder folder = (IFolder)ResourceUtils.findResource((IPath)destPath);
        JUnitUtils.copyTestData("BUJava/src", folder, this.env_, null);
        this.sourceFile_ = folder.getFile((IPath)new Path("foo/Echo.java"));
        JUnitUtils.syncBuildProject(webProject, this.env_, null);
    }

    protected void createProjects() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        if (webProject == null || !webProject.exists()) {
            this.createWebModule(this.PROJECT_NAME, this.PROJECT_NAME, 14);
        }
    }

    private void createWebModule(String projectNm, String componentName, int j2eeVersion) {
        CreateModuleCommand cmc = new CreateModuleCommand();
        cmc.setJ2eeLevel(new Integer(j2eeVersion).toString());
        cmc.setModuleName(componentName);
        cmc.setModuleType(1);
        cmc.setProjectName(projectNm);
        cmc.setServerFactoryId("org.eclipse.jst.server.tomcat.50");
        cmc.setServerInstanceId(this.server_.getId());
        cmc.execute(null, null);
        System.out.println("Done creating Web Project, " + projectNm);
    }

    protected void initJ2EEWSRuntimeServerDefaults() throws Exception {
        JUnitUtils.setWSRuntimeServer("org.eclipse.jst.ws.axis.creation.axisWebServiceRT", "org.eclipse.jst.server.tomcat.50");
        JUnitUtils.setServiceScenarioDefault();
    }

    protected void initInitialSelection() throws Exception {
        this.initialSelection_ = new StructuredSelection((Object)this.sourceFile_);
    }

    public void testBUJavaAxisTC50() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        JUnitUtils.disableWSIDialog(webProject);
        IStatus[] status = JUnitUtils.launchCreationWizard("org.eclipse.jst.ws.creation.ui.wizard.serverwizard", "org.eclipse.core.resources.IFile", this.initialSelection_);
        this.verifyOutput(status);
    }

    private final void verifyOutput(IStatus[] status) throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        IFolder webContentFolder = (IFolder)J2EEUtils.getWebContentContainer((IProject)webProject);
        IFolder wsdlFolder = webContentFolder.getFolder("wsdl");
        if (!wsdlFolder.exists()) {
            this.runEventLoop(3000);
            System.out.println("Running event loop..");
        }
        BUJavaAxisTC50.assertTrue((boolean)wsdlFolder.exists());
        System.out.println("BU wsdl folder exists? = " + wsdlFolder.exists());
        if (wsdlFolder.members().length <= 0) {
            this.runEventLoop(3000);
            System.out.println("Running event loop..");
        }
        BUJavaAxisTC50.assertTrue((wsdlFolder.members().length > 0 ? 1 : 0) != 0);
        System.out.println("BU wsdl file exists? = " + (wsdlFolder.members().length > 0));
        AccumulateStatusHandler statusHandler = new AccumulateStatusHandler(status);
        IStatus[] s = statusHandler.getErrorReports();
        if (s.length > 0) {
            int i = 0;
            while (i < s.length) {
                this.logBadStatus(s[i]);
                System.out.println("Error message for report #" + i + ": " + s[i].getMessage());
                ++i;
            }
        }
        BUJavaAxisTC50.assertEquals((String)"BU Unexpected number of client error reports", (int)0, (int)s.length);
    }

    protected void deleteInputData() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        webProject.delete(true, true, null);
        BUJavaAxisTC50.assertFalse((boolean)webProject.exists());
    }
}

