/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy;

import org.eclipse.jem.internal.proxy.awt.IStandardAwtBeanProxyFactory;
import org.eclipse.jem.internal.proxy.awt.JavaStandardAwtBeanConstants;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IDimensionBeanProxy;
import org.eclipse.jem.internal.proxy.core.IPointBeanProxy;
import org.eclipse.jem.internal.proxy.core.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.tests.proxy.AbstractTestProxy;

public class TestAWTProxy
extends AbstractTestProxy {
    private JavaStandardAwtBeanConstants constants;

    public TestAWTProxy() {
    }

    public TestAWTProxy(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.constants = JavaStandardAwtBeanConstants.getConstants((ProxyFactoryRegistry)this.registry);
        TestAWTProxy.assertNotNull((Object)this.constants);
        if (!this.constants.isAWTAvailable()) {
            this.constants = null;
        }
    }

    public void testAWTColor() throws ClassCastException, ThrowableProxy, InstantiationException {
        if (this.constants == null) {
            return;
        }
        IBeanTypeProxy colorType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Color");
        TestAWTProxy.assertNotNull((Object)colorType);
        IBeanProxy colorProxy = colorType.newInstance("java.awt.Color.cyan");
        TestAWTProxy.assertNotNull((Object)colorProxy);
        TestAWTProxy.assertEquals((String)"java.awt.Color[r=0,g=255,b=255]", (String)colorProxy.toBeanString());
    }

    public void testAWTProxyFactory() {
        if (this.constants == null) {
            return;
        }
        IStandardAwtBeanProxyFactory awtProxyFactory = (IStandardAwtBeanProxyFactory)this.registry.getBeanProxyFactoryExtension("standard-java.awt");
        TestAWTProxy.assertNotNull((Object)awtProxyFactory);
        IDimensionBeanProxy dimBean = awtProxyFactory.createDimensionBeanProxyWith(5, 6);
        TestAWTProxy.assertNotNull((Object)dimBean);
        TestAWTProxy.assertEquals((String)"java.awt.Dimension[width=5,height=6]", (String)dimBean.toBeanString());
        TestAWTProxy.assertEquals((int)5, (int)dimBean.getWidth());
        TestAWTProxy.assertEquals((int)6, (int)dimBean.getHeight());
        IPointBeanProxy pointBean = awtProxyFactory.createPointBeanProxyWith(5, 6);
        TestAWTProxy.assertNotNull((Object)pointBean);
        TestAWTProxy.assertEquals((String)"java.awt.Point[x=5,y=6]", (String)pointBean.toBeanString());
        TestAWTProxy.assertEquals((int)5, (int)pointBean.getX());
        TestAWTProxy.assertEquals((int)6, (int)pointBean.getY());
        IRectangleBeanProxy rectBean = awtProxyFactory.createBeanProxyWith(5, 6, 7, 8);
        TestAWTProxy.assertNotNull((Object)rectBean);
        TestAWTProxy.assertEquals((String)"java.awt.Rectangle[x=5,y=6,width=7,height=8]", (String)rectBean.toBeanString());
        TestAWTProxy.assertEquals((int)5, (int)rectBean.getX());
        TestAWTProxy.assertEquals((int)6, (int)rectBean.getY());
        TestAWTProxy.assertEquals((int)7, (int)rectBean.getWidth());
        TestAWTProxy.assertEquals((int)8, (int)rectBean.getHeight());
    }

    public void testAWTSpecialsInitString() throws ClassCastException, ThrowableProxy, InstantiationException {
        if (this.constants == null) {
            return;
        }
        IBeanTypeProxy dimType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Dimension");
        TestAWTProxy.assertNotNull((Object)dimType);
        IDimensionBeanProxy dimBean = (IDimensionBeanProxy)dimType.newInstance("new java.awt.Dimension(7,8)");
        TestAWTProxy.assertNotNull((Object)dimBean);
        TestAWTProxy.assertEquals((String)"java.awt.Dimension[width=7,height=8]", (String)dimBean.toBeanString());
        IBeanTypeProxy pointType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Point");
        IPointBeanProxy pointBean = (IPointBeanProxy)pointType.newInstance("new java.awt.Point(5,6)");
        TestAWTProxy.assertNotNull((Object)pointBean);
        TestAWTProxy.assertEquals((String)"java.awt.Point[x=5,y=6]", (String)pointBean.toBeanString());
        IBeanTypeProxy rectType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Rectangle");
        IRectangleBeanProxy rectBean = (IRectangleBeanProxy)rectType.newInstance("new java.awt.Rectangle(5,6,7,8)");
        TestAWTProxy.assertNotNull((Object)rectBean);
        TestAWTProxy.assertEquals((String)"java.awt.Rectangle[x=5,y=6,width=7,height=8]", (String)rectBean.toBeanString());
    }
}

