/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.css2.property.LengthMeta;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class BorderSpacingMeta
extends CSSPropertyMeta {
    public static final int[] INITIAL_SPACING = new int[]{3, 3};

    public BorderSpacingMeta() {
        super(false, INITIAL_SPACING);
    }

    protected String[] getKeywordValues() {
        return EMPTY_KEYWORDS;
    }

    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        if (value == null || value.getCssValueType() == 3) {
            return INITIAL_SPACING;
        }
        if (value.getCssValueType() == 1) {
            int intvalue = this.toIntValue(value.getCssText(), style);
            if (intvalue >= 0) {
                return new int[]{intvalue, intvalue};
            }
            return INITIAL_SPACING;
        }
        if (value.getCssValueType() == 2) {
            CSSValueList list = (CSSValueList)value;
            if (list.getLength() >= 2) {
                int i1 = this.toIntValue(list.item(0).getCssText(), style);
                int i2 = this.toIntValue(list.item(1).getCssText(), style);
                if (i1 < 0) {
                    i1 = 0;
                }
                if (i2 < 0) {
                    i2 = 0;
                }
                return new int[]{i1, i2};
            }
            return INITIAL_SPACING;
        }
        return INITIAL_SPACING;
    }

    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        int intvalue;
        String spacing;
        if ("table".equalsIgnoreCase(htmltag) && (spacing = DOMUtil.getAttributeIgnoreCase(element, "cellspacing")) != null && (intvalue = this.toIntValue(spacing, style)) >= 0) {
            return new int[]{intvalue, intvalue};
        }
        return super.calculateHTMLAttributeOverride(element, htmltag, propertyName, style);
    }

    protected int toIntValue(String valuetext, ICSSStyle style) {
        Object length = LengthMeta.toLength(valuetext, style, 0, style.getCSSFont());
        if (length instanceof Length && !((Length)length).isPercentage()) {
            return ((Length)length).getValue();
        }
        return Integer.MIN_VALUE;
    }
}

