/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.JavaSearchScope;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.ide.IDE;

public class JavaUIHelper {
    public static void doOpenClass(IProject project, String className) {
        String path = String.valueOf(className.replace('.', '/')) + ".java";
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IJavaElement result = javaProject.findElement((IPath)new Path(path));
                JavaUI.openInEditor((IJavaElement)result);
            } else {
                IResource resource = project.findMember((IPath)new Path(path));
                if (resource != null && resource instanceof IFile) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static boolean doesClassExist(IProject project, String className) {
        String path = String.valueOf(className.replace('.', '/')) + ".java";
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IJavaElement result = javaProject.findElement((IPath)new Path(path));
                return result != null;
            }
            IResource resource = project.findMember((IPath)new Path(path));
            return resource != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static SelectionDialog openSelectionDialog(Shell shell, IJavaSearchScope searchScope, int typeFlag) {
        try {
            return JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)typeFlag, (boolean)false);
        }
        catch (JavaModelException e) {
            JSFUICommonPlugin.getLogger(JavaUIHelper.class).error(e);
            return null;
        }
    }

    public static SelectionDialog openSelectionDialog(Shell shell, IProject project, String superType, int typeFlag) {
        IJavaSearchScope searchScope = JavaUIHelper.findSearchScope(project, superType);
        return JavaUIHelper.openSelectionDialog(shell, searchScope, typeFlag);
    }

    public static SelectionDialog openSelectionDialog(Shell shell, IProject project, String superType) {
        IJavaSearchScope searchScope = JavaUIHelper.findSearchScope(project, superType);
        return JavaUIHelper.openSelectionDialog(shell, searchScope, 256);
    }

    public static IJavaSearchScope findSearchScope(IProject project, String superType) {
        if (project != null) {
            if (superType == null || "".equals(superType)) {
                superType = "java.lang.Object";
            }
            return new JavaSearchScope(project, superType);
        }
        return SearchEngine.createWorkspaceScope();
    }
}

