/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.performance;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.WSDLException;
import junit.framework.Assert;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLReaderImpl;

public class ReadOAGISWSDLTestcase
extends PerformanceTestCase {
    private List defs = new ArrayList();

    public void testReadWSDL() throws MalformedURLException, WSDLException {
        File dir;
        String oagis80Dir = System.getProperty("oagis80Dir");
        Assert.assertNotNull((Object)oagis80Dir);
        if (!oagis80Dir.endsWith("/") && !oagis80Dir.endsWith("\\")) {
            oagis80Dir = String.valueOf(oagis80Dir) + "/";
        }
        if ((dir = new File(String.valueOf(oagis80Dir) + "OAGIS8.0/ws/wsdl")).exists() && dir.isDirectory()) {
            File[] wsdls = dir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".wsdl");
                }
            });
            this.tagAsSummary("Read OAGIS WSDL", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
            this.startMeasuring();
            int i = 0;
            while (i < wsdls.length) {
                this.readWSDL(wsdls[i].toURL().toString());
                ++i;
            }
            this.stopMeasuring();
            this.commitMeasurements();
            this.assertPerformance();
        } else {
            ReadOAGISWSDLTestcase.fail((String)dir.toString());
        }
    }

    private void readWSDL(String location) throws WSDLException {
        WSDLReaderImpl reader = new WSDLReaderImpl();
        this.defs.add(reader.readWSDL(location));
    }
}

