/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.model;

import java.io.IOException;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.tests.model.AbstractModelTest;
import org.eclipse.wst.css.core.tests.util.FileUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class CSSStyleRuleTest
extends AbstractModelTest {
    public void testInsertTextNumbers() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSStyleRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSStyleRuleTest.assertEquals((int)3, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(0);
        CSSStyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleRuleTest.assertTrue((boolean)(rule instanceof CSSStyleRule));
        CSSStyleDeclaration declaration = ((CSSStyleRule)rule).getStyle();
        CSSStyleRuleTest.assertEquals((int)20, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("NUMBER");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(1, 123.456f));
        value = declaration.getPropertyCSSValue("PERCENTAGE");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(2, 123.456f));
        value = declaration.getPropertyCSSValue("EMS");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(3, 123.456f));
        value = declaration.getPropertyCSSValue("EXS");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(4, 123.456f));
        value = declaration.getPropertyCSSValue("PX");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(5, 123.456f));
        value = declaration.getPropertyCSSValue("PX2");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(5, -123.0f));
        value = declaration.getPropertyCSSValue("CM");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(6, 123.456f));
        value = declaration.getPropertyCSSValue("MM");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(7, 123.456f));
        value = declaration.getPropertyCSSValue("IN");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(8, 123.456f));
        value = declaration.getPropertyCSSValue("PT");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(9, 123.456f));
        value = declaration.getPropertyCSSValue("PC");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(10, 123.456f));
        value = declaration.getPropertyCSSValue("DEG");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(11, -123.456f));
        value = declaration.getPropertyCSSValue("RAD");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(12, 123.456f));
        value = declaration.getPropertyCSSValue("GRAD");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(13, 123.456f));
        value = declaration.getPropertyCSSValue("MS");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(14, 123.456f));
        value = declaration.getPropertyCSSValue("S");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(15, 123.456f));
        value = declaration.getPropertyCSSValue("HZ");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(16, 123.456f));
        value = declaration.getPropertyCSSValue("KHZ");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(17, 123.456f));
        value = declaration.getPropertyCSSValue("DIMENSION");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(18, -123.456f));
        value = declaration.getPropertyCSSValue("INTEGER");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(26, 123.0f));
    }

    public void testInsertTextStrings() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSStyleRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSStyleRuleTest.assertEquals((int)3, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(1);
        CSSStyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleRuleTest.assertTrue((boolean)(rule instanceof CSSStyleRule));
        CSSStyleDeclaration declaration = ((CSSStyleRule)rule).getStyle();
        CSSStyleRuleTest.assertEquals((int)11, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("STRING");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(19, "string"));
        value = declaration.getPropertyCSSValue("URI");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(20, "http://www.ibm.com/"));
        value = declaration.getPropertyCSSValue("IDENT");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "left"));
        value = declaration.getPropertyCSSValue("HASH");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(27, "#abcdef"));
        value = declaration.getPropertyCSSValue("URANGE");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(28, "U+20A7"));
        value = declaration.getPropertyCSSValue("SLASH");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(31, "/"));
        value = declaration.getPropertyCSSValue("COMMA");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(32, ","));
        value = declaration.getPropertyCSSValue("INHERIT_PRIMITIVE");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(33, "inherit"));
        value = declaration.getPropertyCSSValue("ATTR");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(22, "KEY"));
        value = declaration.getPropertyCSSValue("FORMAT");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(29, "truedoc"));
        value = declaration.getPropertyCSSValue("LOCAL");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(30, "Excelsior Roman"));
    }

    public void testInsertTextFunctions() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSStyleRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSStyleRuleTest.assertEquals((int)3, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(2);
        CSSStyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleRuleTest.assertTrue((boolean)(rule instanceof CSSStyleRule));
        CSSStyleDeclaration declaration = ((CSSStyleRule)rule).getStyle();
        CSSStyleRuleTest.assertEquals((int)3, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("COUNTER");
        this.checkPrimitiveCounter(value, "par-num", "upper-roman", null);
        value = declaration.getPropertyCSSValue("RECT");
        this.checkPrimitiveRect(value, new Object[]{new AbstractModelTest.PrimitiveNumber(26, 12.0f), new AbstractModelTest.PrimitiveNumber(26, 34.0f), new AbstractModelTest.PrimitiveNumber(26, 56.0f), new AbstractModelTest.PrimitiveNumber(26, 78.0f)});
        value = declaration.getPropertyCSSValue("RGBCOLOR");
        this.checkPrimitiveRgb(value, new Object[]{new AbstractModelTest.PrimitiveNumber(26, 255.0f), new AbstractModelTest.PrimitiveNumber(26, 128.0f), new AbstractModelTest.PrimitiveNumber(26, 0.0f)});
    }
}

