/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.wst.server.preview.internal.IMemento;
import org.eclipse.wst.server.preview.internal.Module;
import org.eclipse.wst.server.preview.internal.XMLMemento;

public class ServerConfig {
    private String configPath;
    private Module[] modules;
    private int port = 8080;

    public ServerConfig(String configPath) {
        this.configPath = configPath;
        this.init();
    }

    private void init() {
        File f = new File(this.configPath);
        if (!f.exists()) {
            System.err.println("Config doesn't exist at " + this.configPath);
        } else {
            try {
                IMemento memento = XMLMemento.loadMemento(f);
                Integer prt = memento.getInteger("port");
                if (prt != null) {
                    this.port = prt;
                }
                IMemento[] modules2 = memento.getChildren("module");
                int size = modules2.length;
                ArrayList<Module> list = new ArrayList<Module>(size);
                int i = 0;
                while (i < size) {
                    String name = modules2[i].getString("name");
                    boolean isStatic = "static".equals(modules2[i].getString("type"));
                    String path = modules2[i].getString("path");
                    String context = modules2[i].getString("context");
                    Module module = new Module(name, isStatic, context, path);
                    list.add(module);
                    ++i;
                }
                this.modules = new Module[list.size()];
                list.toArray(this.modules);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public Module[] getModules() {
        return this.modules;
    }
}

