/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jdtutility;

import java.util.Arrays;
import org.eclipse.jpt.core.internal.jdtutility.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.BooleanStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.CharacterStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.EnumArrayDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.NumberStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.PrimitiveTypeStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.StringExpressionConverter;
import org.eclipse.jpt.core.tests.internal.jdtutility.AnnotationTestCase;

public class MemberAnnotationElementAdapterTests
extends AnnotationTestCase {
    public MemberAnnotationElementAdapterTests(String name) {
        super(name);
    }

    private void createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        this.javaProject.createType("annot", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    private void createEnum(String enumName, String enumBody) throws Exception {
        this.javaProject.createType("enums", String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    public void testGetValue1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        this.createTestType("@annot.Foo(bar=\"xxx\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"xxx", (String)((String)aea.getValue()));
    }

    public void testGetValue2() throws Exception {
        this.createAnnotationAndMembers("Foo", "int bar();");
        this.createTestType("@annot.Foo(bar=48)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", NumberStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"48", (String)((String)aea.getValue()));
    }

    public void testGetValue3() throws Exception {
        this.createAnnotationAndMembers("Foo", "char bar();");
        this.createTestType("@annot.Foo(bar='c')");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", CharacterStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"c", (String)((String)aea.getValue()));
    }

    public void testGetValue4() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        this.createTestType("@annot.Foo(bar=false)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"false", (String)((String)aea.getValue()));
    }

    public void testGetValue5() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        this.createTestType("@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=false)))");
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"false", (String)((String)aea.getValue()));
    }

    public void testGetValue6() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean value();");
        this.createTestType("@annot.Foo(false)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"false", (String)((String)aea.getValue()));
    }

    public void testGetValueNull1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        this.createTestType("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueNull2() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueNull3() throws Exception {
        this.createAnnotationAndMembers("Baz", "String fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        this.createTestType("@annot.Foo(@annot.Bar(jimmy=@annot.Baz))");
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa3, (String)"fred");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueStringConcatenation() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        this.createTestType("@annot.Foo(bar=\"xxx\" + \"yyy\" + \"zzz\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"xxxyyyzzz", (String)((String)aea.getValue()));
    }

    public void testGetValueStringConstant() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        this.createTestType("private static final String FOO_BAR = \"xxx\"; @annot.Foo(bar=FOO_BAR + \"yyy\" + \"zzz\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"xxxyyyzzz", (String)((String)aea.getValue()));
    }

    public void testGetValueNumberArithmetic() throws Exception {
        this.createAnnotationAndMembers("Foo", "int bar();");
        this.createTestType("@annot.Foo(bar=47 - 7 + 2 * 1 / 1)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"42", (String)((String)aea.getValue()));
    }

    public void testGetValueNumberShift() throws Exception {
        this.createAnnotationAndMembers("Foo", "int bar();");
        this.createTestType("@annot.Foo(bar=2 << 2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"8", (String)((String)aea.getValue()));
    }

    public void testGetValueNumberConstant() throws Exception {
        this.createAnnotationAndMembers("Foo", "int bar();");
        this.createTestType("private static final int FOO_BAR = 77; @annot.Foo(bar=FOO_BAR)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"77", (String)((String)aea.getValue()));
    }

    public void testGetValueCharacterConstant() throws Exception {
        this.createAnnotationAndMembers("Foo", "char bar();");
        this.createTestType("private static final char FOO_BAR = 'Q'; @annot.Foo(bar=FOO_BAR)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forCharacters((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"Q", (String)((String)aea.getValue()));
    }

    public void testGetValueCharacterCast() throws Exception {
        this.createAnnotationAndMembers("Foo", "char bar();");
        this.createTestType("@annot.Foo(bar=(char) 0x41)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forCharacters((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"A", (String)((String)aea.getValue()));
    }

    public void testGetValueBooleanOperator1() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        this.createTestType("@annot.Foo(bar=7 > 2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"true", (String)((String)aea.getValue()));
    }

    public void testGetValueBooleanOperator2() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        this.createTestType("@annot.Foo(bar=7 == 2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"false", (String)((String)aea.getValue()));
    }

    public void testGetValueBooleanOperator3() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        this.createTestType("@annot.Foo(bar=(7 != 2) && false)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"false", (String)((String)aea.getValue()));
    }

    public void testGetValueBooleanOperator4() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        this.createTestType("@annot.Foo(bar=(7 != 2) ? false : true)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"false", (String)((String)aea.getValue()));
    }

    public void testGetValueInvalidValue1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        this.createTestType("@annot.Foo(bar=77)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueInvalidValue2() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        this.createTestType("@annot.Foo(bar=bazzzz)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueInvalidValue3() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        this.createTestType("@annot.Foo(bar=bazzzz)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueInvalidValue4() throws Exception {
        this.createAnnotationAndMembers("Foo", "char bar();");
        this.createTestType("@annot.Foo(bar=\"bazzzz\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forCharacters((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueInvalidValue5() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType("@annot.Foo(bar=\"java.lang.Object\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueInvalidValue6() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        this.createTestType("@annot.Foo(bar=enums.TestEnum.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueInvalidValue7() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String value = "\"false\"";
        String element = "fred=" + value;
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(" + element + ")))";
        this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueInvalidValue8() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        this.createTestType("@annot.Foo(bar={true, false})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[2], (Object[])aea.getValue()));
    }

    public void testGetValueInvalidValue9() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        this.createTestType("@annot.Foo(bar=77)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[1], (Object[])aea.getValue()));
    }

    public void testASTNode1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String value = "\"xxx\"";
        String element = "bar=" + value;
        String annotation = "@annot.Foo(" + element + ")";
        this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        ASTNodeTextRange textRange = new ASTNodeTextRange(aea.astNode());
        MemberAnnotationElementAdapterTests.assertEquals((int)this.source().indexOf(value), (int)textRange.getOffset());
        MemberAnnotationElementAdapterTests.assertEquals((int)value.length(), (int)textRange.getLength());
        MemberAnnotationElementAdapterTests.assertEquals((int)7, (int)textRange.getLineNumber());
    }

    public void testASTNode2() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String value = "false";
        String element = "fred=" + value;
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(" + element + ")))";
        this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"false", (String)((String)aea.getValue()));
        ASTNodeTextRange textRange = new ASTNodeTextRange(aea.astNode());
        MemberAnnotationElementAdapterTests.assertEquals((int)value.length(), (int)textRange.getLength());
    }

    public void testASTNode3() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value();");
        String element = "\"xxx\"";
        String annotation = "@annot.Foo(" + element + ")";
        this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa);
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        ASTNodeTextRange textRange = new ASTNodeTextRange(aea.astNode());
        MemberAnnotationElementAdapterTests.assertEquals((int)this.source().indexOf(element), (int)textRange.getOffset());
        MemberAnnotationElementAdapterTests.assertEquals((int)element.length(), (int)textRange.getLength());
    }

    public void testASTNode4() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value();");
        String annotation = "@annot.Foo";
        this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa);
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        ASTNodeTextRange textRange = new ASTNodeTextRange(aea.astNode());
        MemberAnnotationElementAdapterTests.assertEquals((int)this.source().indexOf(annotation), (int)textRange.getOffset());
        MemberAnnotationElementAdapterTests.assertEquals((int)annotation.length(), (int)textRange.getLength());
    }

    public void testSetValue1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String annotation = "@annot.Foo(bar=\"xxx\")";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain("Foo");
    }

    public void testSetValue2() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String annotation = "@annot.Foo(bar=\"xxx\")";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar", (boolean)false);
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain(annotation);
        this.assertSourceContains("@Foo");
    }

    public void testSetValue3() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=false)))";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain(annotation);
        this.assertSourceDoesNotContain("Foo");
        this.assertSourceDoesNotContain("Bar");
    }

    public void testSetValue3a() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=false)))";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar", false);
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz", false);
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain(annotation);
        this.assertSourceContains("@annot.Foo(@Bar)");
    }

    public void testSetValue4() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceContains("@Foo(bar=\"xxx\")");
    }

    public void testSetValue5() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=false)))";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"true");
        this.assertSourceDoesNotContain(annotation);
        this.assertSourceContains("@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=true)))");
    }

    public void testSetValue6() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        this.createTestType();
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"true");
        this.assertSourceContains("@Foo(@Bar(jimmy=@Baz(fred=true)))");
    }

    public void testSetValue7() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String annotation = "@annot.Foo(bar=\"xxx\")";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"yyy");
        this.assertSourceDoesNotContain(annotation);
        this.assertSourceContains("@annot.Foo(bar=\"yyy\")");
    }

    public void testSetValue8() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String annotation = "@annot.Foo";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceContains("@Foo(bar=\"xxx\")");
    }

    public void testSetValue9() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value(); String bar();");
        String annotation = "@annot.Foo(\"zzz\")";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceDoesNotContain(annotation);
        this.assertSourceContains("@Foo(value=\"zzz\", bar=\"xxx\")");
    }

    public void testSetValue10() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar(); String baz();");
        String annotation = "@annot.Foo(bar=\"xxx\")";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"baz");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"yyy");
        this.assertSourceDoesNotContain(annotation);
        this.assertSourceContains("@annot.Foo(bar=\"xxx\", baz = \"yyy\")");
    }

    public void testSetValue11() throws Exception {
        this.createAnnotationAndMembers("Baz", "int fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz[] jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String annotation = "@annot.Foo(@annot.Bar(jimmy={@annot.Baz(fred=0), @annot.Baz(fred=1), @annot.Baz(fred=2), @annot.Baz(fred=3)}))";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedIndexedDeclarationAnnotationAdapter daa3 = new NestedIndexedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", 2, "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", NumberStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"2", (String)((String)aea.getValue()));
        aea.setValue((Object)"48");
        this.assertSourceContains("@annot.Foo(@annot.Bar(jimmy={@annot.Baz(fred=0), @annot.Baz(fred=1), @annot.Baz(fred=48), @annot.Baz(fred=3)}))");
    }

    public void testSetValue12() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value();");
        String annotation = "@annot.Foo";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"value");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceContains("@Foo(\"xxx\")");
    }

    public void testSetValue13() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value();");
        String annotation = "@annot.Foo(\"zzz\")";
        this.createTestType(annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"value");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceDoesNotContain(annotation);
        this.assertSourceContains("@annot.Foo(\"xxx\")");
    }

    public void testSimpleTypeLiteral1() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType("@annot.Foo(bar=java.lang.Object.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"java.lang.Object", (String)((String)aea.getValue()));
    }

    public void testSimpleTypeLiteral2() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"java.lang.Object");
        this.assertSourceContains("@Foo(bar=java.lang.Object.class)");
    }

    public void testSimpleTypeLiteral3() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType("@annot.Foo(bar=int.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testSimpleTypeLiteral4() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType("@annot.Foo(bar=java.util.Map.Entry.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"java.util.Map.Entry", (String)((String)aea.getValue()));
    }

    public void testPrimitiveTypeLiteral1() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType("@annot.Foo(bar=int.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", PrimitiveTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"int", (String)((String)aea.getValue()));
    }

    public void testPrimitiveTypeLiteral2() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", PrimitiveTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"int");
        this.assertSourceContains("@Foo(bar=int.class)");
    }

    public void testPrimitiveTypeLiteral3() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType("@annot.Foo(bar=java.lang.Object.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", PrimitiveTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testPrimitiveTypeLiteral4() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        this.createTestType("@annot.Foo(bar=void.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", PrimitiveTypeStringExpressionConverter.instance());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"void", (String)((String)aea.getValue()));
    }

    public void testGetValueEnum1() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        this.createTestType("@annot.Foo(bar=enums.TestEnum.XXX)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"enums.TestEnum.XXX", (String)((String)aea.getValue()));
    }

    public void testGetValueEnum2() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        this.createTestType("static enums.TestEnum.XXX", "@annot.Foo(bar=XXX)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"enums.TestEnum.XXX", (String)((String)aea.getValue()));
    }

    public void testGetValueEnum3() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        this.createTestType("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testGetValueEnum4() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        this.createTestType("enums.TestEnum", "@annot.Foo(bar=TestEnum.XXX)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"enums.TestEnum.XXX", (String)((String)aea.getValue()));
    }

    public void testSetValueEnum1() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        String annotation = "@annot.Foo(bar=XXX)";
        this.createTestType("static enums.TestEnum.XXX", annotation);
        this.assertSourceContains(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain("Foo");
    }

    public void testSetValueEnum2() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        String annotation = "@Foo(bar=XXX)";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"enums.TestEnum.XXX");
        this.assertSourceContains("import static enums.TestEnum.XXX;");
        this.assertSourceContains(annotation);
    }

    public void testGetValueStringArray() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        this.createTestType("@annot.Foo(bar={\"string0\", \"string1\"})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"string0", "string1"}, (Object[])aea.getValue()));
    }

    public void testGetValueStringArrayConcatenation() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        this.createTestType("@annot.Foo(bar={\"stri\" + \"ng0\", \"s\" + \"tring1\"})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"string0", "string1"}, (Object[])aea.getValue()));
    }

    public void testGetValueStringArrayEmpty() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        this.createTestType("@annot.Foo(bar={})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testGetValueStringArraySingleElement() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        this.createTestType("@annot.Foo(bar=\"string0\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"string0"}, (Object[])aea.getValue()));
    }

    public void testGetValueNullStringArray() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        this.createTestType("@annot.Foo()");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testSetValueStringArray() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        String annotation = "@Foo(bar={\"string0\",\"string1\"})";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[]{"string0", "string1"});
        this.assertSourceContains(annotation);
    }

    public void testSetValueStringArrayEmptyRemove() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        String annotation = "@Foo";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[0]);
        this.assertSourceDoesNotContain(annotation);
    }

    public void testSetValueStringArrayEmpty() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        String annotation = "@Foo(bar={})";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        AnnotationStringArrayExpressionConverter expressionConverter = new AnnotationStringArrayExpressionConverter(StringExpressionConverter.instance(), false);
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)expressionConverter);
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[0]);
        this.assertSourceContains(annotation);
    }

    public void testSetValueStringArraySingleElement() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        String annotation = "@Foo(bar=\"string0\")";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[]{"string0"});
        this.assertSourceContains(annotation);
    }

    public void testGetValueEnumArray() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        this.createTestType("@annot.Foo(bar={enums.TestEnum.XXX, enums.TestEnum.YYY})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"enums.TestEnum.XXX", "enums.TestEnum.YYY"}, (Object[])aea.getValue()));
    }

    public void testGetValueEnumArrayInvalidEntry() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        this.createTestType("@annot.Foo(bar={enums.TestEnum.XXX, 88})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        Object[] objectArray = new String[2];
        objectArray[0] = "enums.TestEnum.XXX";
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(objectArray, (Object[])aea.getValue()));
    }

    public void testGetValueEnumArrayEmpty() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        this.createTestType("@annot.Foo(bar={})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testGetValueEnumArraySingleElement() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        this.createTestType("@annot.Foo(bar=enums.TestEnum.XXX)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"enums.TestEnum.XXX"}, (Object[])aea.getValue()));
    }

    public void testGetValueEnumArraySingleElementInvalid() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        this.createTestType("@annot.Foo(bar=\"\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[1], (Object[])aea.getValue()));
    }

    public void testGetValueNullEnumArray() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        this.createTestType("@annot.Foo()");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testSetValueEnumArray() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        String annotation = "@Foo(bar={XXX,YYY})";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[]{"enums.TestEnum.XXX", "enums.TestEnum.YYY"});
        this.assertSourceContains("import static enums.TestEnum.XXX;");
        this.assertSourceContains("import static enums.TestEnum.YYY;");
        this.assertSourceContains(annotation);
    }

    public void testSetValueEnumArrayEmptyRemove() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        String annotation = "@Foo";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[0]);
        this.assertSourceDoesNotContain(annotation);
    }

    public void testSetValueEnumArrayEmpty() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        String annotation = "@Foo(bar={})";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", true, false);
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[0]);
        this.assertSourceContains(annotation);
    }

    public void testSetValueEnumArraySingleElement() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        String annotation = "@Foo(bar=XXX)";
        this.createTestType();
        this.assertSourceDoesNotContain(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        MemberAnnotationElementAdapter aea = new MemberAnnotationElementAdapter((Member)this.idField(), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[]{"enums.TestEnum.XXX"});
        this.assertSourceContains("import static enums.TestEnum.XXX;");
        this.assertSourceContains(annotation);
    }
}

